/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates.eglx.jtopen;

import java.io.StringWriter;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.gen.java.templates.eglx.jtopen.CommonUtilities;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.Environment;

public class AS400GenArrayResize {
    static AS400GenArrayResize INSTANCE = new AS400GenArrayResize();

    public void genArrayResizeParameter(FunctionParameter parameter, Context ctx, TabbedWriter out, Function functionContainer) {
        if (parameter.getType() instanceof ArrayType) {
            this.genResizeMember((Expression)this.getCountMember((Member)parameter, ctx), (LHSExpr)this.createMemberName((Member)parameter), (ArrayType)parameter.getType(), ctx, out, (Container)functionContainer, functionContainer);
        } else if (parameter.getType() instanceof LogicAndDataPart) {
            this.processFields((LogicAndDataPart)parameter.getType(), ctx, out, (LHSExpr)this.createMemberName((Member)parameter), functionContainer);
        }
    }

    private void genResizeMember(Expression cntMember, LHSExpr array, ArrayType arrayType, Context ctx, TabbedWriter out, Container countContainer, Function functionContainer) {
        if (cntMember != null) {
            this.genArrayResizeExpression(cntMember, ctx, out, (Expression)array, (Container)functionContainer);
        }
        this.genArrayResizeElements(arrayType, ctx, out, array, functionContainer);
    }

    private MemberAccess createMemberAccess(Member member, LHSExpr qual) {
        MemberAccess ma = JavaTemplate.factory.createMemberAccess();
        ma.setId(member.getId());
        ma.setMember(member);
        ma.setQualifier((Expression)qual);
        return ma;
    }

    private MemberName createMemberName(Member member) {
        MemberName mn = JavaTemplate.factory.createMemberName();
        mn.setId(member.getId());
        mn.setMember(member);
        return mn;
    }

    private MemberName getCountMember(Member member, Context ctx) {
        Annotation as400Array = CommonUtilities.getAnnotation(member, "eglx.jtopen.annotations.AS400Array", ctx);
        return as400Array == null ? null : (MemberName)as400Array.getValue("returnCountVariable");
    }

    private void genArrayResizeElements(ArrayType type, Context ctx, TabbedWriter out, LHSExpr array, Function functionContainer) {
        String tempName = ctx.nextTempName();
        TabbedWriter writer = ctx.getTabbedWriter();
        ArrayAccess arrayAccess = JavaTemplate.factory.createArrayAccess();
        arrayAccess.setArray((Expression)array);
        Field f = JavaTemplate.factory.createField();
        Type idxType = null;
        try {
            idxType = (Type)Environment.getCurrentEnv().find("egl:eglx.lang.EInt");
        }
        catch (Exception exception) {}
        f.setType(idxType);
        f.setName(tempName);
        MemberName idx = JavaTemplate.factory.createMemberName();
        idx.setId(tempName);
        idx.setMember((Member)f);
        arrayAccess.setIndex((Expression)idx);
        this.processElements(type.getElementType(), ctx, writer, arrayAccess, functionContainer);
        if (((StringWriter)writer.getWriter()).getBuffer().length() > 0) {
            out.print("for(int ");
            out.print(tempName);
            out.print("= 1; ");
            out.print(tempName);
            out.print(" <= ");
            this.genArrayGetSize(ctx, out, array, functionContainer);
            out.print("; ");
            out.print(tempName);
            out.println("++)");
            out.println("{");
            out.println(((StringWriter)writer.getWriter()).getBuffer().toString());
            out.println("}");
        }
    }

    private void processElements(Type type, Context ctx, TabbedWriter out, ArrayAccess arrayElement, Function functionContainer) {
        if (type instanceof LogicAndDataPart) {
            this.processFields((LogicAndDataPart)type, ctx, out, (LHSExpr)arrayElement, functionContainer);
        }
    }

    private void genArrayGetSize(Context ctx, TabbedWriter out, LHSExpr array, Function container) {
        QualifiedFunctionInvocation inv = JavaTemplate.factory.createQualifiedFunctionInvocation();
        inv.setId("getSize");
        inv.setQualifier((Expression)array);
        ctx.invoke("genExpression", (Expression)inv, (TemplateContext)ctx, out);
    }

    private void genArrayResizeExpression(Expression validElementCountVariable, Context ctx, TabbedWriter out, Expression array, Container container) {
        QualifiedFunctionInvocation inv = JavaTemplate.factory.createQualifiedFunctionInvocation();
        inv.setId("resize");
        Type idxType = null;
        try {
            idxType = (Type)Environment.getCurrentEnv().find("egl:eglx.lang.EInt");
        }
        catch (Exception exception) {}
        AsExpression cnt = IRUtils.createAsExpression((Expression)validElementCountVariable, (Type)idxType);
        inv.getArguments().add(cnt);
        inv.setQualifier(array);
        FunctionStatement stmt = JavaTemplate.factory.createFunctionStatement();
        stmt.setExpr((Expression)inv);
        stmt.setContainer(container);
        ctx.invoke("genStatement", (Statement)stmt, (TemplateContext)ctx, out);
    }

    private void processFields(LogicAndDataPart part, Context ctx, TabbedWriter out, LHSExpr qual, Function functionContainer) {
        for (Field field : part.getFields()) {
            if (field.getType() instanceof ArrayType) {
                MemberName mn = this.getCountMember((Member)field, ctx);
                this.genResizeMember((Expression)(mn == null ? null : this.createMemberAccess(mn.getMember(), qual)), (LHSExpr)this.createMemberAccess((Member)field, qual), (ArrayType)field.getType(), ctx, out, (Container)part, functionContainer);
                continue;
            }
            if (!(field.getType() instanceof LogicAndDataPart)) continue;
            this.processFields((LogicAndDataPart)field.getType(), ctx, out, (LHSExpr)this.createMemberAccess((Member)field, qual), functionContainer);
        }
    }
}

