/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.jdt.internal.launching.JavaLaunchableTester;

public class EGLLaunchableTester
extends PropertyTester {
    private static final String PROPERTY_HAS_PROJECT_NATURES = "hasProjectNatures";
    private static final String HAS_JAVA_MAIN_PROGRAM = "hasJavaMainProgram";
    private static final JavaLaunchableTester tester = new JavaLaunchableTester();

    protected Object resolveElement(Object receiver) {
        IEGLElement element = null;
        if (receiver instanceof IAdaptable) {
            IEGLElement eglElement = (IEGLElement)((IAdaptable)receiver).getAdapter(IEGLElement.class);
            if (eglElement != null && eglElement.exists()) {
                element = eglElement;
            } else {
                IFile ifile = (IFile)((IAdaptable)receiver).getAdapter(IFile.class);
                if (ifile != null && ifile.exists()) {
                    element = ifile;
                }
            }
        }
        return element;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object element = this.resolveElement(receiver);
        if (element == null) {
            return false;
        }
        if (HAS_JAVA_MAIN_PROGRAM.equals(property)) {
            return this.hasJavaMainProgram(element);
        }
        if (PROPERTY_HAS_PROJECT_NATURES.equals(property)) {
            return args.length > 0 && this.hasProjectNatures(element, args);
        }
        return false;
    }

    private boolean hasJavaMainProgram(Object element) {
        IResource resource;
        IFile eglFile = null;
        if (element instanceof IFile) {
            eglFile = (IFile)element;
        } else if (element instanceof IEGLElement && (resource = ((IEGLElement)element).getResource()).getType() == 1) {
            eglFile = (IFile)resource;
        }
        if (eglFile != null) {
            List<IFile> files = EGLLaunchableTester.getMainJavaOutputFiles(eglFile);
            return files != null && files.size() > 0;
        }
        return false;
    }

    private boolean hasProjectNatures(Object element, Object[] natures) {
        IProject project = null;
        if (element instanceof IEGLElement) {
            IEGLProject eproj = ((IEGLElement)element).getEGLProject();
            if (eproj != null) {
                project = eproj.getProject();
            }
        } else if (element instanceof IFile) {
            project = ((IFile)element).getProject();
        }
        if (project != null) {
            return this.hasProjectNatures(project, natures);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasProjectNatures(IProject project, Object[] natures) {
        try {
            if (!project.isAccessible()) return false;
            int i = 0;
            while (true) {
                if (i >= natures.length) {
                    return true;
                }
                if (!project.hasNature((String)natures[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static List<IFile> getMainJavaOutputFiles(IFile eglFile) {
        List<IFile> files = EGLLaunchableTester.getJavaOutputFiles(eglFile);
        if (files != null && files.size() > 0) {
            ArrayList<IFile> mainFiles = new ArrayList<IFile>(files.size());
            for (IFile file : files) {
                if (!tester.test((Object)file, "hasMain", new Object[0], null)) continue;
                mainFiles.add(file);
            }
            return mainFiles;
        }
        return null;
    }

    public static List<IFile> getJavaOutputFiles(IFile eglFile) {
        IGenerator[] gens = ProjectSettingsUtility.getGenerators((IResource)eglFile);
        if (gens.length > 0) {
            IEGLElement o;
            ArrayList<IGenerator> javaGens = new ArrayList<IGenerator>(gens.length);
            IGenerator[] iGeneratorArray = gens;
            int n = gens.length;
            int n2 = 0;
            while (n2 < n) {
                IGenerator gen = iGeneratorArray[n2];
                if ("Java".equalsIgnoreCase(gen.getLanguage())) {
                    javaGens.add(gen);
                }
                ++n2;
            }
            if (javaGens.size() > 0 && (o = EGLCore.create((IFile)eglFile)) instanceof IEGLFile) {
                IEGLFile element = (IEGLFile)o;
                ProjectEnvironment env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(eglFile.getProject());
                try {
                    Environment.pushEnv((IEnvironment)env.getIREnvironment());
                    env.initIREnvironments();
                    ArrayList<IFile> files = new ArrayList<IFile>(javaGens.size());
                    IPackageDeclaration[] pkgDecl = element.getPackageDeclarations();
                    String[] pkg = pkgDecl != null && pkgDecl.length > 0 ? IRFileNameUtility.toIRFileName((String[])pkgDecl[0].getElementName().split("\\.")) : new String[]{};
                    IPart[] iPartArray = element.getParts();
                    int n3 = iPartArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPart ipart = iPartArray[n4];
                        if (ipart instanceof SourcePart && ((SourcePart)ipart).isProgram()) {
                            try {
                                String name = IRFileNameUtility.toIRFileName((String)ipart.getElementName());
                                Part part = env.findPart(InternUtil.intern((String[])pkg), InternUtil.intern((String)name));
                                for (org.eclipse.edt.compiler.IGenerator iGenerator : javaGens) {
                                    if (!(iGenerator instanceof IGenerator)) continue;
                                    try {
                                        IFile[] iFileArray = ((IGenerator)iGenerator).getOutputFiles(eglFile, part);
                                        int n5 = iFileArray.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            IFile file = iFileArray[n6];
                                            files.add(file);
                                            ++n6;
                                        }
                                    }
                                    catch (CoreException coreException) {}
                                }
                            }
                            catch (PartNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n4;
                    }
                    ArrayList<IFile> arrayList = files;
                    return arrayList;
                }
                catch (EGLModelException e) {
                    e.printStackTrace();
                }
                finally {
                    Environment.popEnv();
                }
            }
        }
        return null;
    }
}

