/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class IntegerLiteralTemplate
extends JavaTemplate {
    public void genExpression(IntegerLiteral expr, Context ctx, TabbedWriter out) {
        Type type = expr.getType();
        if (type.equals(TypeUtils.Type_SMALLINT).booleanValue()) {
            out.print("(short) ");
            if (expr.isNegated().booleanValue()) {
                out.print('-');
            }
            out.print(this.trimLeadingZeros(expr.getUnsignedValue()));
        } else if (type.equals(TypeUtils.Type_INT).booleanValue()) {
            if (expr.isNegated().booleanValue()) {
                out.print('-');
            }
            out.print(this.trimLeadingZeros(expr.getUnsignedValue()));
        } else if (type.equals(TypeUtils.Type_BIGINT).booleanValue()) {
            if (expr.isNegated().booleanValue()) {
                out.print('-');
            }
            out.print(this.trimLeadingZeros(expr.getUnsignedValue()));
            out.print('L');
        } else {
            BigDecimal bd = new BigDecimal(expr.getValue());
            BigInteger unscaled = bd.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            out.print("new java.math.BigDecimal( new java.math.BigInteger( new byte[] {");
            int i = 0;
            while (i < bytes.length) {
                if (bytes[i] >= 0) {
                    out.print(" 0x" + Integer.toHexString(bytes[i] & 0xFF));
                } else {
                    out.print(" (byte)0x" + Integer.toHexString(bytes[i] & 0xFF));
                }
                if (i < bytes.length - 1) {
                    out.print(',');
                }
                ++i;
            }
            out.print(" } ), ");
            out.print(bd.scale());
            out.print(')');
        }
    }

    private String trimLeadingZeros(String str) {
        int start = 0;
        int stop = str.length() - 1;
        while (str.charAt(start) == '0' && start < stop) {
            ++start;
        }
        return start == 0 ? str : str.substring(start);
    }
}

