/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.IGenerator;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.StatementValidator;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.SystemEnvironmentUtil;
import org.eclipse.edt.compiler.SystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2Binding;
import org.eclipse.edt.mof.egl.impl.ProgramImpl;
import org.eclipse.edt.mof.egl.lookup.EglLookupDelegate;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class BaseCompiler
implements ICompiler {
    protected String systemEnvironmentRootPath;
    private ISystemEnvironment systemEnvironment;
    protected String id;
    protected String name;
    protected List<IGenerator> generators = new ArrayList<IGenerator>();
    protected String version;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name != null && name.length() == 0 ? null : name;
    }

    @Override
    public String getName() {
        return this.name == null ? this.id : this.name;
    }

    @Override
    public String getSystemEnvironmentPath() {
        if (this.systemEnvironmentRootPath == null) {
            this.systemEnvironmentRootPath = SystemEnvironmentUtil.getSystemLibraryPath(ProgramImpl.class, "lib");
        }
        return this.systemEnvironmentRootPath;
    }

    @Override
    public List<IGenerator> getGenerators() {
        return this.generators;
    }

    @Override
    public void addGenerator(IGenerator generator) {
        this.generators.add(generator);
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    @Override
    public synchronized ISystemEnvironment getSystemEnvironment(IBuildNotifier notifier) {
        if (this.systemEnvironment == null) {
            this.systemEnvironment = this.createSystemEnvironment(notifier);
        }
        return this.systemEnvironment;
    }

    protected ISystemEnvironment createSystemEnvironment(IBuildNotifier notifier) {
        SystemEnvironment sysEnv = new SystemEnvironment(Environment.getCurrentEnv(), null, this.getAllImplicitlyUsedEnumerations(), this);
        Environment.getCurrentEnv().registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
        sysEnv.initializeSystemPackages(this.getSystemEnvironmentPath(), new SystemPackageBuildPathEntryFactory(new Mof2Binding(sysEnv)), notifier);
        return sysEnv;
    }

    @Override
    public List<String> getImplicitlyUsedEnumerations() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getAllImplicitlyUsedEnumerations() {
        return this.getImplicitlyUsedEnumerations();
    }

    @Override
    public StatementValidator getValidatorFor(Statement stmt) {
        return null;
    }
}

