/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NilBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.StereotypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.lookup.SystemEnvironmentPackageNames;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class AnnotationBinding
extends DataBinding
implements IAnnotationBinding {
    private transient List fields = Collections.EMPTY_LIST;
    private boolean isCalculated;

    public AnnotationBinding(String caseSensitiveInternedName, IPartBinding declarer, ITypeBinding typeBinding) {
        this(caseSensitiveInternedName, declarer, typeBinding, false);
    }

    public AnnotationBinding(String caseSensitiveInternedName, IPartBinding declarer, ITypeBinding typeBinding, boolean suppressDefaultFields) {
        super(caseSensitiveInternedName, declarer, typeBinding);
        IAnnotationTypeBinding aTypeBinding;
        if (!suppressDefaultFields && this.getType() != null && 18 == this.getType().getKind() && (aTypeBinding = (IAnnotationTypeBinding)this.getType()) != null) {
            if (aTypeBinding.hasSingleValue() && this.getAnnotationType().getAnnotation(StereotypeAnnotationTypeBinding.getInstance()) == null) {
                String singleFieldName = (String)aTypeBinding.getCaseSensitiveFieldNames().iterator().next();
                this.addField(new AnnotationFieldBinding(singleFieldName, declarer, aTypeBinding.getSingleValueType(), aTypeBinding));
            }
            for (String nextName : aTypeBinding.getCaseSensitiveFieldNames()) {
                Object defaultValue = aTypeBinding.getDefaultValueForField(InternUtil.intern((String)nextName));
                if (defaultValue == null) continue;
                AnnotationFieldBinding aFieldBinding = new AnnotationFieldBinding(nextName, declarer, ((IAnnotationTypeBinding)aTypeBinding.findData(InternUtil.intern((String)nextName)).getType()).getSingleValueType(), aTypeBinding);
                aFieldBinding.setValue(defaultValue, null, null, DefaultCompilerOptions.getInstance(), false);
                aFieldBinding.setCalculated(true);
                this.addAnnotation(aFieldBinding);
            }
        }
    }

    @Override
    public Object getValue() {
        IAnnotationTypeBinding aTypeBinding;
        ITypeBinding type = this.getType();
        if (18 == type.getKind() && (aTypeBinding = (IAnnotationTypeBinding)type).hasSingleValue()) {
            String singleFieldName = (String)aTypeBinding.getFieldNames().iterator().next();
            return ((IAnnotationBinding)this.findData(singleFieldName)).getValue();
        }
        return null;
    }

    @Override
    public IAnnotationTypeBinding getAnnotationType() {
        return (IAnnotationTypeBinding)this.getType();
    }

    @Override
    public int getKind() {
        return 13;
    }

    @Override
    public boolean isAnnotationBinding() {
        return true;
    }

    @Override
    public void setValue(Object value, IProblemRequestor problemRequestor, Expression expression, ICompilerOptions compilerOptions) {
        this.setValue(value, problemRequestor, expression, compilerOptions, true);
    }

    @Override
    public void setValue(Object value, IProblemRequestor problemRequestor, Expression expression, ICompilerOptions compilerOptions, boolean performValidation) {
        IAnnotationTypeBinding myType;
        if (!performValidation) {
            this.primSetValue(value);
            return;
        }
        if (!this.isValidExpressionForAnnotationValue(expression)) {
            problemRequestor.acceptProblem((Node)expression, 3127, new String[]{this.caseSensitiveInternedName});
            return;
        }
        boolean valid = true;
        ITypeBinding expressionType = expression.resolveTypeBinding();
        if (expressionType instanceof AnnotationTypeBindingImpl) {
            expressionType = ((AnnotationTypeBindingImpl)expressionType).getAnnotationRecord();
        }
        if ((myType = (IAnnotationTypeBinding)this.typeBinding).hasSingleValue()) {
            ITypeBinding singleValueType = myType.getSingleValueType();
            if (2 == singleValueType.getKind() && this.typeIsResolvable(((ArrayTypeBinding)singleValueType).getElementType())) {
                if (this.validateIsArrayOfNames(expression, problemRequestor, myType.getCaseSensitiveName())) {
                    expression.setTypeBinding(IBinding.NOT_FOUND_BINDING);
                    this.primSetValue(value);
                }
                return;
            }
            if (this.typeIsResolvable(singleValueType)) {
                if (this.validateIsName(expression, problemRequestor, myType.getCaseSensitiveName())) {
                    expression.setTypeBinding(IBinding.NOT_FOUND_BINDING);
                    this.primSetValue(value);
                }
                return;
            }
        } else {
            problemRequestor.acceptProblem((Node)expression, 3128, new String[]{this.caseSensitiveInternedName});
        }
        if (problemRequestor != null && expression != null) {
            VariableBinding vBinding;
            if (value instanceof VariableBinding && (vBinding = (VariableBinding)value).isConstant() && 4 != vBinding.getKind()) {
                value = ((VariableBinding)value).getConstantValue();
            }
            if (SystemPartManager.TYPEREF_BINDING == myType.getSingleValueType()) {
                valid = value instanceof ITypeBinding;
            } else {
                boolean bl = valid = expressionType != null && this.valueMatchesType(value, expressionType, myType.getSingleValueType());
                if (valid) {
                    if (NilBinding.INSTANCE == expressionType) {
                        valid = false;
                    }
                } else if (AbstractBinder.annotationIs(this.typeBinding, new String[]{"egl", "ui"}, "ValidValues")) {
                    valid = value instanceof Object[];
                }
            }
        }
        if (valid) {
            if (myType.hasSingleValue()) {
                this.primSetValue(value);
            }
        } else if (value != null && expressionType != null) {
            this.issueTypeMismatchError(myType.getSingleValueType(), expressionType, problemRequestor, expression);
        }
    }

    private boolean isValidExpressionForAnnotationValue(Expression expr) {
        final boolean[] valid = new boolean[]{true};
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(NewExpression newExpression) {
                valid[0] = false;
                return false;
            }

            @Override
            public boolean visit(FunctionInvocation functionInvocation) {
                valid[0] = false;
                return false;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }
        };
        expr.accept(visitor);
        return valid[0];
    }

    private boolean valueMatchesType(Object value, ITypeBinding valueType, ITypeBinding singleValueType) {
        if (singleValueType == null) {
            return true;
        }
        switch (singleValueType.getKind()) {
            case 3: {
                switch (((PrimitiveTypeBinding)singleValueType).getPrimitive().getType()) {
                    case 10: {
                        return value instanceof Number;
                    }
                    case 4: 
                    case 19: {
                        return value instanceof String;
                    }
                    case 3: {
                        return value instanceof Boolean;
                    }
                    case 0: {
                        return true;
                    }
                }
            }
            case 2: {
                if (value instanceof Object[] && 2 == valueType.getKind()) {
                    Object[] objAry = (Object[])value;
                    ITypeBinding elementType = ((ArrayTypeBinding)valueType).getElementType();
                    ITypeBinding singleValueElementType = ((ArrayTypeBinding)singleValueType).getElementType();
                    int i = 0;
                    while (i < objAry.length) {
                        if (!this.valueMatchesType(objAry[i], elementType, singleValueElementType)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        }
        if (TypeCompatibilityUtil.compatibilityAnnotationMatches(valueType, singleValueType)) {
            return true;
        }
        if (Binding.isValidBinding(valueType) && Binding.isValidBinding(singleValueType)) {
            valueType = valueType.getNonNullableInstance();
            singleValueType = singleValueType.getNonNullableInstance();
        }
        return valueType == singleValueType;
    }

    protected void primSetValue(Object value) {
        IAnnotationTypeBinding aTypeBinding;
        ITypeBinding type = this.getType();
        if (18 == type.getKind() && (aTypeBinding = (IAnnotationTypeBinding)type).hasSingleValue()) {
            String singleFieldName = (String)aTypeBinding.getFieldNames().iterator().next();
            IDataBinding findData = this.findData(singleFieldName);
            if (Binding.isValidBinding(findData)) {
                ((AnnotationBinding)findData).primSetValue(value);
            }
            return;
        }
        throw new UnsupportedOperationException("primSetValue() called for annotation " + this.getName() + ", which does not have a single value");
    }

    private void issueTypeMismatchError(ITypeBinding annotationValueType, ITypeBinding suppliedType, IProblemRequestor problemRequestor, Expression expression) {
        if (19 == annotationValueType.getKind()) {
            problemRequestor.acceptProblem((Node)expression, 3054, new String[]{this.caseSensitiveInternedName, ((EnumerationTypeBinding)annotationValueType).getEnumerationsAsCommaList()});
        } else if (PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN) == annotationValueType) {
            problemRequestor.acceptProblem((Node)expression, 3054, new String[]{this.caseSensitiveInternedName, "yes, no"});
        } else if (SystemPartManager.SQLSTRING_BINDING == annotationValueType) {
            problemRequestor.acceptProblem((Node)expression, 3080, new String[]{this.caseSensitiveInternedName});
        } else if (AbstractBinder.annotationIs(this.typeBinding, new String[]{"egl", "ui"}, "ValidValues")) {
            problemRequestor.acceptProblem(expression, 7670);
        } else if (suppliedType != null) {
            block0 : switch (annotationValueType.getKind()) {
                case 3: {
                    switch (((PrimitiveTypeBinding)annotationValueType).getPrimitive().getType()) {
                        case 10: {
                            problemRequestor.acceptProblem((Node)expression, 3059, new String[]{this.getCaseSensitiveName()});
                            break block0;
                        }
                        case 4: 
                        case 19: {
                            problemRequestor.acceptProblem((Node)expression, 3060, new String[]{this.getCaseSensitiveName()});
                            break block0;
                        }
                    }
                    this.issueDefaultTypeMismatchMessage(annotationValueType, suppliedType, problemRequestor, expression);
                    break;
                }
                case 2: {
                    ITypeBinding singleValueElementType = ((ArrayTypeBinding)annotationValueType).getElementType();
                    switch (singleValueElementType.getKind()) {
                        case 3: {
                            switch (((PrimitiveTypeBinding)singleValueElementType).getPrimitive().getType()) {
                                case 10: {
                                    problemRequestor.acceptProblem((Node)expression, 3055, new String[]{this.getCaseSensitiveName()});
                                    break block0;
                                }
                                case 4: 
                                case 19: {
                                    problemRequestor.acceptProblem((Node)expression, 3056, new String[]{this.getCaseSensitiveName()});
                                    break block0;
                                }
                            }
                            this.issueDefaultTypeMismatchMessage(annotationValueType, suppliedType, problemRequestor, expression);
                            break block0;
                        }
                        case 2: {
                            singleValueElementType = ((ArrayTypeBinding)singleValueElementType).getElementType();
                            switch (singleValueElementType.getKind()) {
                                case 3: {
                                    switch (((PrimitiveTypeBinding)singleValueElementType).getPrimitive().getType()) {
                                        case 10: {
                                            problemRequestor.acceptProblem((Node)expression, 3058, new String[]{this.getCaseSensitiveName()});
                                            break;
                                        }
                                        case 4: 
                                        case 19: {
                                            problemRequestor.acceptProblem((Node)expression, 3057, new String[]{this.getCaseSensitiveName()});
                                        }
                                    }
                                    break block0;
                                }
                            }
                            this.issueDefaultTypeMismatchMessage(annotationValueType, suppliedType, problemRequestor, expression);
                            break block0;
                        }
                    }
                    this.issueDefaultTypeMismatchMessage(annotationValueType, suppliedType, problemRequestor, expression);
                    break;
                }
                default: {
                    this.issueDefaultTypeMismatchMessage(annotationValueType, suppliedType, problemRequestor, expression);
                }
            }
        }
    }

    private void issueDefaultTypeMismatchMessage(ITypeBinding annotationValueType, ITypeBinding suppliedType, IProblemRequestor problemRequestor, Expression expression) {
        problemRequestor.acceptProblem((Node)expression, 6653, new String[]{StatementValidator.getShortTypeString(annotationValueType), StatementValidator.getShortTypeString(suppliedType), String.valueOf(this.getName()) + "=" + expression.getCanonicalString()});
    }

    private boolean typeIsResolvable(ITypeBinding singleValueType) {
        IPartBinding matchingSystemPart = (IPartBinding)SystemPartManager.findType(singleValueType.getName());
        if (matchingSystemPart == singleValueType) {
            return SystemEnvironmentPackageNames.EGL_CORE_REFLECT == matchingSystemPart.getPackageName() && matchingSystemPart != SystemPartManager.SQLSTRING_BINDING;
        }
        return false;
    }

    @Override
    public IAnnotationBinding getAnnotationFor(IAnnotationTypeBinding annotationType, IDataBinding[] path) {
        return this.getAnnotation(annotationType);
    }

    @Override
    public boolean isForElement() {
        return false;
    }

    @Override
    public boolean isAnnotationField() {
        return false;
    }

    @Override
    public IAnnotationBinding getAnnotationFor(IAnnotationTypeBinding annotationType, IDataBinding[] path, int index) {
        return this.getAnnotation(annotationType, index);
    }

    @Override
    protected ITypeBinding getTypeBinding(ITypeBinding typeBinding, IDataBinding dataBinding) {
        return typeBinding;
    }

    private boolean validateIsArrayOfNames(final Expression rootExpression, final IProblemRequestor problemRequestor, final String annotationName) {
        final boolean[] valid = new boolean[]{true};
        rootExpression.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                problemRequestor.acceptProblem((Node)rootExpression, 2064, new String[]{expression.getCanonicalString(), annotationName});
                valid[0] = false;
                return false;
            }

            @Override
            public boolean visit(ArrayLiteral arrayLiteral) {
                Iterator iter = arrayLiteral.getExpressions().iterator();
                while (iter.hasNext()) {
                    if (AnnotationBinding.this.validateIsName((Expression)iter.next(), problemRequestor, annotationName)) continue;
                    valid[0] = false;
                }
                return false;
            }
        });
        return valid[0];
    }

    private boolean validateIsName(Expression expression, final IProblemRequestor problemRequestor, final String annotationName) {
        final boolean[] valid = new boolean[]{true};
        expression.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                problemRequestor.acceptProblem((Node)expression, 2060, new String[]{expression.getCanonicalString(), annotationName});
                valid[0] = false;
                return false;
            }

            @Override
            public boolean visit(NullLiteral nilLiteral) {
                return false;
            }

            @Override
            public boolean visitName(Name name) {
                return false;
            }
        });
        return valid[0];
    }

    @Override
    public void addAnnotation(IAnnotationBinding annotation) {
        if (annotation.isAnnotationField()) {
            if (this.fields == Collections.EMPTY_LIST) {
                this.fields = new ArrayList();
            }
            this.fields.add(annotation);
        } else if (this != annotation) {
            super.addAnnotation(annotation);
        }
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding lastFound = IBinding.NOT_FOUND_BINDING;
        if (this.fields.size() > 0) {
            simpleName = InternUtil.intern((String)simpleName);
            for (IDataBinding binding : this.fields) {
                if (binding.getName() != simpleName) continue;
                lastFound = binding;
            }
        }
        return lastFound;
    }

    @Override
    public IAnnotationTypeBinding getEnclosingAnnotationType() {
        return null;
    }

    @Override
    public List getAnnotationFields() {
        return this.fields;
    }

    @Override
    public void addField(IAnnotationBinding newField) {
        if (this.fields == Collections.EMPTY_LIST) {
            this.fields = new ArrayList();
        }
        this.fields.add(newField);
    }

    @Override
    public boolean isCopiedAnnotationBinding() {
        return false;
    }

    @Override
    public void addFields(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.addField((IAnnotationBinding)i.next());
        }
    }

    @Override
    public ITypeBinding getType() {
        if (this.typeBinding instanceof AnnotationTypeBindingImpl) {
            IEnvironment env;
            AnnotationTypeBindingImpl temp = (AnnotationTypeBindingImpl)this.typeBinding;
            if (temp.getAnnotationRecord().isValid) {
                return super.getType();
            }
            IEnvironment iEnvironment = env = this.getDeclaringPart() != null ? this.getDeclaringPart().getEnvironment() : null;
            if (env == null) {
                return null;
            }
            temp.setAnnotationRecord((FlexibleRecordBinding)this.realizeTypeBinding(temp.getAnnotationRecord(), env));
        }
        return super.getType();
    }

    @Override
    public boolean isStaticPartDataBinding() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Map map = this.getFieldsHashMap();
        out.writeInt(map.size());
        for (String key : map.keySet()) {
            Object value = map.get(key);
            out.writeUTF(key);
            if (value instanceof ITypeBinding) {
                out.writeBoolean(true);
                this.writeTypeBindingReference(out, (ITypeBinding)value);
                continue;
            }
            out.writeBoolean(false);
            if (value instanceof Node) {
                out.writeUnshared(null);
                continue;
            }
            out.writeUnshared(value);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int len = in.readInt();
        this.fields = Collections.EMPTY_LIST;
        int i = 0;
        while (i < len) {
            String key = in.readUTF();
            boolean isType = in.readBoolean();
            Object value = isType ? this.readTypeBindingReference(in) : in.readUnshared();
            AnnotationFieldBinding field = new AnnotationFieldBinding(key, null, (ITypeBinding)PrimitiveTypeBinding.getInstance(Primitive.ANY), null);
            field.setValue(value, null, null, null, false);
            this.addField(field);
            ++i;
        }
    }

    private Map getFieldsHashMap() {
        HashMap<String, Object> map = Collections.EMPTY_MAP;
        if (this.getAnnotationFields().size() > 0) {
            map = new HashMap<String, Object>();
            for (AnnotationFieldBinding field : this.getAnnotationFields()) {
                if (field.getValue() instanceof Expression) {
                    map.put(field.getCaseSensitiveName().toUpperCase().toLowerCase(), field.getValue().toString());
                    continue;
                }
                map.put(field.getCaseSensitiveName().toUpperCase().toLowerCase(), field.getValue());
            }
        }
        return map;
    }

    @Override
    public boolean isCalculatedValue() {
        return this.isCalculated;
    }

    public void setCalculated(boolean b) {
        this.isCalculated = b;
    }

    public AnnotationBinding createCopy() {
        AnnotationBinding copy = new AnnotationBinding(this.getCaseSensitiveName(), this.getDeclaringPart(), this.getType(), true);
        this.populateCopy(copy);
        return copy;
    }

    protected void populateCopy(AnnotationBinding copy) {
        copy.setCalculated(this.isCalculatedValue());
        copy.addAnnotations(this.getAnnotations());
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            copy.addField(((AnnotationFieldBinding)i.next()).createCopy());
        }
    }
}

