/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.AmbiguousFunctionBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.DataBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FunctionBindingWithImplicitQualifier;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class BindingUtilities {
    private static List annotationsForRecordsWithResourceAssocation = Arrays.asList(new PackageAndName(new String[]{"egl", "io", "file"}, "IndexedRecord"), new PackageAndName(new String[]{"egl", "io", "mq"}, "MQRecord"), new PackageAndName(new String[]{"egl", "io", "file"}, "RelativeRecord"), new PackageAndName(new String[]{"egl", "io", "file"}, "CSVRecord"), new PackageAndName(new String[]{"egl", "io", "file"}, "SerialRecord"));

    public static void addToUnqualifiedBindingNameMap(Map map, IDataBinding dataBindingWhichContainsNewBinding, IDataBinding newBinding) {
        String newBindingName;
        map.put(newBindingName, map.containsKey(newBindingName = newBinding.getName()) ? AmbiguousDataBinding.getInstance() : (dataBindingWhichContainsNewBinding == null ? newBinding : new DataBindingWithImplicitQualifier(newBinding, dataBindingWhichContainsNewBinding)));
    }

    public static void addAllToUnqualifiedBindingNameMap(Map map, IDataBinding dataBindingWhichContainsNewBindings, Map newBindings) {
        Iterator iter = newBindings.keySet().iterator();
        while (iter.hasNext()) {
            String nextKey;
            map.put(nextKey, map.containsKey(nextKey = (String)iter.next()) ? AmbiguousDataBinding.getInstance() : (dataBindingWhichContainsNewBindings == null ? newBindings.get(nextKey) : new DataBindingWithImplicitQualifier((IDataBinding)newBindings.get(nextKey), dataBindingWhichContainsNewBindings)));
        }
    }

    public static void addToUnqualifiedFunctionNameMap(Map map, IFunctionBinding functionBinding, IDataBinding dataBindingWhichContainsFunctionBinding) {
        String newBindingName;
        map.put(newBindingName, map.containsKey(newBindingName = functionBinding.getName()) ? AmbiguousFunctionBinding.getInstance() : (dataBindingWhichContainsFunctionBinding == null ? functionBinding : new FunctionBindingWithImplicitQualifier(functionBinding, dataBindingWhichContainsFunctionBinding)));
    }

    public static ITypeBinding getBaseType(IDataBinding dataBinding) {
        return dataBinding.getType().getBaseType();
    }

    public static void addResourceAssociationBindingToMap(Map namesToBindingsMap, IDataBinding ioObject) {
        ITypeBinding typeFromIOObject = BindingUtilities.getBaseType(ioObject);
        if (BindingUtilities.hasResourceAssociation(typeFromIOObject)) {
            if (namesToBindingsMap.containsKey(FixedRecordBinding.RESOURCEASSOCIATION.getName())) {
                IDataBinding dBinding = (IDataBinding)namesToBindingsMap.get(FixedRecordBinding.RESOURCEASSOCIATION.getName());
                if (dBinding == AmbiguousDataBinding.getInstance()) {
                    return;
                }
                DataBindingWithImplicitQualifier dbFromMap = (DataBindingWithImplicitQualifier)dBinding;
                if (dbFromMap.getWrappedDataBinding() != AmbiguousDataBinding.getInstance()) {
                    ITypeBinding typeFromMap = BindingUtilities.getBaseType(dbFromMap.getImplicitQualifier());
                    String fileOrQueueNameFromMap = null;
                    String fileOrQueueNameFromIOObject = null;
                    if (typeFromIOObject.getAnnotation(new String[]{"egl", "io", "mq"}, "MQRecord") != null) {
                        fileOrQueueNameFromMap = BindingUtilities.getQueueNameValue(typeFromMap);
                        fileOrQueueNameFromIOObject = BindingUtilities.getQueueNameValue(typeFromIOObject);
                    } else {
                        fileOrQueueNameFromMap = BindingUtilities.getFileNameValue(typeFromMap);
                        fileOrQueueNameFromIOObject = BindingUtilities.getFileNameValue(typeFromIOObject);
                    }
                    if (fileOrQueueNameFromMap == null && fileOrQueueNameFromIOObject == null || fileOrQueueNameFromMap != fileOrQueueNameFromIOObject) {
                        namesToBindingsMap.put(FixedRecordBinding.RESOURCEASSOCIATION.getName(), AmbiguousDataBinding.getInstance());
                    }
                }
            } else {
                BindingUtilities.addToUnqualifiedBindingNameMap(namesToBindingsMap, ioObject, FixedRecordBinding.RESOURCEASSOCIATION);
            }
        }
    }

    private static String getFileNameValue(ITypeBinding type) {
        IAnnotationBinding fileNameAnnotation;
        IAnnotationBinding subTypeAnnotation = type.getAnnotation(new String[]{"egl", "io", "file"}, "IndexedRecord");
        if (subTypeAnnotation == null) {
            subTypeAnnotation = type.getAnnotation(new String[]{"egl", "io", "file"}, "SerialRecord");
        }
        if (subTypeAnnotation == null) {
            subTypeAnnotation = type.getAnnotation(new String[]{"egl", "io", "file"}, "RelativeRecord");
        }
        if (subTypeAnnotation == null) {
            subTypeAnnotation = type.getAnnotation(new String[]{"egl", "io", "file"}, "CSVRecord");
        }
        if (subTypeAnnotation != null && IBinding.NOT_FOUND_BINDING != (fileNameAnnotation = (IAnnotationBinding)subTypeAnnotation.findData(InternUtil.intern((String)"fileName")))) {
            return InternUtil.intern((String)fileNameAnnotation.getValue().toString());
        }
        return null;
    }

    private static String getQueueNameValue(ITypeBinding type) {
        IAnnotationBinding queueNameAnnotation;
        IAnnotationBinding subTypeAnnotation = type.getAnnotation(new String[]{"egl", "io", "mq"}, "MQRecord");
        if (subTypeAnnotation != null && IBinding.NOT_FOUND_BINDING != (queueNameAnnotation = (IAnnotationBinding)subTypeAnnotation.findData(InternUtil.intern((String)"queueName")))) {
            return InternUtil.intern((String)queueNameAnnotation.getValue().toString());
        }
        return null;
    }

    public static boolean hasResourceAssociation(ITypeBinding type) {
        for (PackageAndName next : annotationsForRecordsWithResourceAssocation) {
            if (type.getAnnotation(next.pkg, next.name) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLooseType(ITypeBinding typeBinding) {
        if (3 == typeBinding.getKind()) {
            PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)typeBinding;
            Primitive prim = primTypeBinding.getPrimitive();
            if (Primitive.CHAR == prim || Primitive.MBCHAR == prim || Primitive.DBCHAR == prim || Primitive.HEX == prim || Primitive.UNICODE == prim) {
                return primTypeBinding.getLength() == 0;
            }
            if (Primitive.INTERVAL == prim) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidDeclarationType(ITypeBinding typeBinding) {
        if (2 == typeBinding.getKind()) {
            return BindingUtilities.isValidDeclarationType(((ArrayTypeBinding)typeBinding).getElementType());
        }
        if (StatementValidator.isAnnotationRecord(typeBinding)) {
            return false;
        }
        return 3 == typeBinding.getKind() || 6 == typeBinding.getKind() || 7 == typeBinding.getKind() || 17 == typeBinding.getKind() || 19 == typeBinding.getKind() || SystemPartManager.findType(typeBinding.getName()) == typeBinding || typeBinding.isReference();
    }

    private static class PackageAndName {
        String[] pkg;
        String name;

        public PackageAndName(String[] pkg, String name) {
            this.pkg = pkg;
            this.name = name;
        }
    }
}

