/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DynamicDataBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class DataBinding
extends Binding
implements IDataBinding {
    Map propertyOverrides = Collections.EMPTY_MAP;
    protected transient ITypeBinding typeBinding;
    private transient IPartBinding declarer;

    public DataBinding(String caseSensitiveInternedName, IPartBinding declarer, ITypeBinding typeBinding) {
        super(caseSensitiveInternedName);
        this.declarer = declarer;
        this.typeBinding = typeBinding;
        this.typeBinding = this.getTypeBinding(typeBinding, this);
    }

    @Override
    public ITypeBinding getType() {
        return this.realizeTypeBinding(this.typeBinding, this.declarer != null ? this.declarer.getEnvironment() : null);
    }

    public void setType(ITypeBinding partBinding) {
        this.typeBinding = partBinding;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.shouldSerializeTypeBinding()) {
            this.writeTypeBindingReference(out, this.typeBinding);
        }
    }

    protected boolean shouldSerializeTypeBinding() {
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.shouldSerializeTypeBinding()) {
            this.typeBinding = this.readTypeBindingReference(in);
        }
    }

    @Override
    public boolean isDataBinding() {
        return true;
    }

    @Override
    public IDataBinding copyDataBinding(HashMap itemMapping) {
        throw new UnsupportedOperationException("copy() not overriden for " + this.getClass().getName());
    }

    @Override
    public IPartBinding getDeclaringPart() {
        return this.declarer;
    }

    public void setDeclarer(IPartBinding declarer) {
        this.declarer = declarer;
    }

    @Override
    public boolean isDataBindingWithImplicitQualifier() {
        return false;
    }

    @Override
    public IDataBinding getWrappedDataBinding() {
        return null;
    }

    @Override
    public IDataBinding getImplicitQualifier() {
        return null;
    }

    @Override
    public IAnnotationBinding getAnnotationFor(IAnnotationTypeBinding annotationType, IDataBinding[] path) {
        if (path == null || path.length == 0) {
            return this.getAnnotation(annotationType);
        }
        IAnnotationBinding result = null;
        if (this.propertyOverrides.size() > 0) {
            String key = this.getPathString(path);
            List list = (List)this.propertyOverrides.get(key);
            if (list != null) {
                result = this.getAnnotation(annotationType, list);
            }
            if (result != null) {
                return result;
            }
        }
        if (path.length > 1) {
            IDataBinding binding = path[0];
            IDataBinding[] newPath = new IDataBinding[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            return binding.getAnnotationFor(annotationType, newPath);
        }
        return path[0].getAnnotation(annotationType);
    }

    private String getPathString(IDataBinding[] path) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < path.length) {
            if (path[i] != null && path[i] != IBinding.NOT_FOUND_BINDING) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(".");
                }
                if (path[i].getKind() == 5) {
                    buffer.append(((StructureItemBinding)path[i]).getParentQualifiedName());
                } else {
                    buffer.append(path[i].getName());
                }
            }
            ++i;
        }
        return InternUtil.intern((String)buffer.toString());
    }

    @Override
    public IAnnotationBinding getAnnotationFor(String[] packageName, String annotationName, IDataBinding[] path) {
        if (path == null || path.length == 0) {
            return this.getAnnotation(packageName, annotationName);
        }
        if (this.propertyOverrides.size() > 0) {
            IAnnotationBinding result = null;
            String key = this.getPathString(path);
            List list = (List)this.propertyOverrides.get(key);
            if (list != null) {
                result = this.getAnnotation(packageName, annotationName, list);
            }
            if (result != null) {
                return result;
            }
        }
        if (path.length > 1) {
            IDataBinding binding = path[0];
            IDataBinding[] newPath = new IDataBinding[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            return binding.getAnnotationFor(packageName, annotationName, newPath);
        }
        return path[0].getAnnotation(packageName, annotationName);
    }

    @Override
    public List getAnnotationsFor(IDataBinding[] path) {
        String key;
        List list;
        if (path == null || path.length == 0) {
            return this.getAnnotations();
        }
        List result = new ArrayList();
        if (this.propertyOverrides.size() > 0 && (list = (List)this.propertyOverrides.get(key = this.getPathString(path))) != null) {
            result = list;
        }
        if (path.length > 1) {
            IDataBinding binding = path[0];
            IDataBinding[] newPath = new IDataBinding[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            this.addNonExisting(binding.getAnnotationsFor(newPath), result);
            return result;
        }
        this.addNonExisting(path[0].getAnnotations(), result);
        return result;
    }

    private void addNonExisting(List sourceAnnotations, List targetAnnotations) {
        HashSet<ITypeBinding> annotationTypesInTargetList = new HashSet<ITypeBinding>();
        Iterator iter = targetAnnotations.iterator();
        while (iter.hasNext()) {
            annotationTypesInTargetList.add(((IAnnotationBinding)iter.next()).getType());
        }
        for (IAnnotationBinding next : sourceAnnotations) {
            if (this.contains(annotationTypesInTargetList, next.getType())) continue;
            targetAnnotations.add(next);
        }
    }

    private boolean contains(Collection listOfTypes, ITypeBinding type) {
        for (ITypeBinding nextType : listOfTypes) {
            if (nextType.getPackageName() != type.getPackageName() || nextType.getName() != type.getName()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAnnotationBinding getAnnotation(IAnnotationTypeBinding annotationType) {
        IAnnotationBinding result = super.getAnnotation(annotationType);
        if (result == null && this.getType() != null && this.getType() != IBinding.NOT_FOUND_BINDING && this.getType().getBaseType() != null && this.getType().getBaseType() != IBinding.NOT_FOUND_BINDING) {
            return this.getType().getBaseType().getAnnotation(annotationType);
        }
        return result;
    }

    @Override
    public IAnnotationBinding getAnnotationFor(IAnnotationTypeBinding annotationType, IDataBinding[] path, int index) {
        if (path == null || path.length == 0) {
            return this.getAnnotation(annotationType, index);
        }
        IAnnotationBinding result = null;
        if (this.propertyOverrides.size() > 0) {
            String key = this.getPathString(path);
            List list = (List)this.propertyOverrides.get(key);
            if (list != null && (result = this.getAnnotation(annotationType, list, index)) == null) {
                result = this.getAnnotation(annotationType, list);
            }
            if (result != null) {
                return result;
            }
        }
        if (path.length > 1) {
            IDataBinding binding = path[0];
            IDataBinding[] newPath = new IDataBinding[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            result = binding.getAnnotationFor(annotationType, newPath, index);
            if (result == null) {
                return binding.getAnnotationFor(annotationType, newPath);
            }
            return result;
        }
        result = path[0].getAnnotation(annotationType, index);
        if (result == null) {
            return path[0].getAnnotation(annotationType);
        }
        return result;
    }

    @Override
    public IAnnotationBinding getAnnotationFor(String[] packageName, String annotationName, IDataBinding[] path, int index) {
        if (path == null || path.length == 0) {
            return this.getAnnotation(packageName, annotationName, index);
        }
        IAnnotationBinding result = null;
        if (this.propertyOverrides.size() > 0) {
            String key = this.getPathString(path);
            List list = (List)this.propertyOverrides.get(key);
            if (list != null && (result = this.getAnnotation(packageName, annotationName, list, index)) == null) {
                result = this.getAnnotation(packageName, annotationName, list);
            }
            if (result != null) {
                return result;
            }
        }
        if (path.length > 1) {
            IDataBinding binding = path[0];
            IDataBinding[] newPath = new IDataBinding[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            result = binding.getAnnotationFor(packageName, annotationName, newPath, index);
            if (result == null) {
                return binding.getAnnotationFor(packageName, annotationName, newPath);
            }
            return result;
        }
        result = path[0].getAnnotation(packageName, annotationName, index);
        if (result == null) {
            return path[0].getAnnotation(packageName, annotationName);
        }
        return result;
    }

    @Override
    public IAnnotationBinding getAnnotation(String[] packageName, String annotationName) {
        IAnnotationBinding result = super.getAnnotation(packageName, annotationName);
        if (result == null && this.getType() != null && this.getType() != IBinding.NOT_FOUND_BINDING && this.getType().getBaseType() != null && this.getType().getBaseType() != IBinding.NOT_FOUND_BINDING) {
            return this.getType().getBaseType().getAnnotation(packageName, annotationName);
        }
        return result;
    }

    @Override
    public void addAnnotation(IAnnotationBinding annotation) {
        if (annotation.isAnnotationField()) {
            IAnnotationBinding myStereotype = this.getAnnotation(annotation.getEnclosingAnnotationType());
            AnnotationBinding newStereotype = new AnnotationBinding(myStereotype.getCaseSensitiveName(), this.declarer, myStereotype.getType());
            Iterator iter = myStereotype.getAnnotationFields().iterator();
            while (iter.hasNext()) {
                newStereotype.addField((IAnnotationBinding)iter.next());
            }
            newStereotype.addField(annotation);
            super.addAnnotation(newStereotype);
        } else {
            super.addAnnotation(annotation);
        }
    }

    @Override
    public void addAnnotation(IAnnotationBinding annotation, IDataBinding[] path) {
        if (path == null || path.length == 0) {
            this.addAnnotation(annotation);
            return;
        }
        this.addAnnotation(annotation, this.getPathString(path));
    }

    public void addAnnotation(IAnnotationBinding annotation, String path) {
        ArrayList<IAnnotationBinding> list;
        if (path == null) {
            this.addAnnotation(annotation);
            return;
        }
        if (this.propertyOverrides == Collections.EMPTY_MAP) {
            this.propertyOverrides = new HashMap();
        }
        if ((list = (ArrayList<IAnnotationBinding>)this.propertyOverrides.get(path)) == null) {
            list = new ArrayList<IAnnotationBinding>();
            this.propertyOverrides.put(path, list);
        }
        list.add(annotation);
    }

    @Override
    public IDataBinding findData(String simpleName) {
        FixedRecordBinding recordBinding;
        if (this.getType() == null || this.getType() == IBinding.NOT_FOUND_BINDING) {
            return IBinding.NOT_FOUND_BINDING;
        }
        if (this.getType().isDynamicallyAccessible()) {
            return new DynamicDataBinding(InternUtil.internCaseSensitive((String)simpleName), this.getDeclaringPart());
        }
        IDataBinding result = this.getType().getBaseType().findData(simpleName);
        if (result != IBinding.NOT_FOUND_BINDING) {
            return result;
        }
        if (this.isFixedRecordType() && (result = (IDataBinding)(recordBinding = (FixedRecordBinding)this.getType()).getSimpleNamesToDataBindingsMap().get(simpleName)) != null) {
            return result;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    private boolean isFixedRecordType() {
        ITypeBinding type = this.getType();
        if (type == null || this.getType() == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        return type.getKind() == 6;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public Map getPropertyOverrides() {
        return this.propertyOverrides;
    }

    @Override
    public boolean isStaticPartDataBinding() {
        return false;
    }
}

