/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class DelegateBindingCompletor
extends AbstractBinder {
    private DelegateBinding delegateBinding;
    private IProblemRequestor problemRequestor;
    private Set definedParameters = new HashSet();
    private String canonicalDelegateName;

    public DelegateBindingCompletor(Scope currentScope, DelegateBinding delegateBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, delegateBinding, dependencyRequestor, compilerOptions);
        this.delegateBinding = delegateBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Delegate delegate) {
        delegate.getName().setBinding(this.delegateBinding);
        this.canonicalDelegateName = delegate.getName().getCanonicalName();
        this.delegateBinding.setPrivate(delegate.isPrivate());
        if (delegate.hasReturnType()) {
            ITypeBinding typeBinding = null;
            try {
                typeBinding = this.bindType(delegate.getReturnType());
                if (this.checkReturnType(delegate.getReturnType(), typeBinding)) {
                    this.delegateBinding.setReturnType(typeBinding);
                    this.delegateBinding.setReturnTypeIsSqlNullable(delegate.returnTypeIsSqlNullable());
                }
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return true;
    }

    @Override
    public void endVisit(Delegate delegate) {
        this.delegateBinding.setValid(true);
    }

    private boolean checkReturnType(Type type, ITypeBinding typeBinding) {
        if (!typeBinding.isReference() && 17 != typeBinding.getKind() && 3 != typeBinding.getKind() && 6 != typeBinding.getKind() && 7 != typeBinding.getKind() && 19 != typeBinding.getKind() && typeBinding != DictionaryBinding.INSTANCE && typeBinding != ArrayDictionaryBinding.INSTANCE) {
            this.problemRequestor.acceptProblem((Node)type, 4914, new String[]{type.getCanonicalName(), this.canonicalDelegateName});
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(FunctionParameter functionParameter) {
        String parmName = functionParameter.getName().getIdentifier();
        Type parmType = functionParameter.getType();
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.bindType(parmType);
        }
        catch (ResolutionException e) {
            functionParameter.getName().setBinding(new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), this.delegateBinding, IBinding.NOT_FOUND_BINDING, null));
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return false;
        }
        FunctionParameterBinding funcParmBinding = new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), this.delegateBinding, typeBinding, null);
        functionParameter.getName().setBinding(funcParmBinding);
        if (!BindingUtilities.isValidDeclarationType(typeBinding)) {
            this.problemRequestor.acceptProblem((Node)parmType, 4902, new String[]{functionParameter.getName().getCanonicalName(), this.canonicalDelegateName});
            return false;
        }
        FunctionParameter.AttrType attrType = functionParameter.getAttrType();
        if (attrType == FunctionParameter.AttrType.FIELD) {
            funcParmBinding.setField(true);
        } else if (attrType == FunctionParameter.AttrType.SQLNULLABLE) {
            funcParmBinding.setSqlNullable(true);
        }
        funcParmBinding.setConst(functionParameter.isParmConst());
        FunctionParameter.UseType useType = functionParameter.getUseType();
        if (useType == FunctionParameter.UseType.IN) {
            funcParmBinding.setInput(true);
        } else if (useType == FunctionParameter.UseType.OUT) {
            funcParmBinding.setOutput(true);
        } else if (useType == null && Binding.isValidBinding(typeBinding) && typeBinding.isReference()) {
            funcParmBinding.setInput(true);
        }
        if (this.definedParameters.contains(parmName)) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 3012, new String[]{parmName, this.canonicalDelegateName});
        } else {
            this.delegateBinding.addParameter(funcParmBinding);
            this.definedParameters.add(parmName);
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, this.delegateBinding, this.delegateBinding, this.delegateBinding, -1, this.delegateBinding);
        SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.delegateBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(blockCompletor);
        return false;
    }
}

