/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.ClassConstantBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FieldLenUtility {
    IDataBinding dataBinding;
    private ICompilerOptions compilerOptions;
    private Scope currentScope;

    public FieldLenUtility(IDataBinding dataBinding, ICompilerOptions compilerOptions, Scope currentScope) {
        this.dataBinding = dataBinding;
        this.compilerOptions = compilerOptions;
        this.currentScope = currentScope;
    }

    public void checkFieldLen() {
        IAnnotationBinding annotation = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "FieldLen");
        if (annotation != null && annotation.getValue() != null) {
            return;
        }
        ITypeBinding type = this.dataBinding.getType().getBaseType();
        if (type.getKind() != 3) {
            return;
        }
        ITypeBinding fieldLenType = this.currentScope.findPackage(InternUtil.intern((String)"eglx")).resolvePackage(InternUtil.intern((String)"ui")).resolveType(InternUtil.intern((String)"FieldLen"));
        if (IBinding.NOT_FOUND_BINDING != fieldLenType) {
            AnnotationBinding fieldLen = new AnnotationBinding(InternUtil.internCaseSensitive((String)"FieldLen"), this.dataBinding.getDeclaringPart(), new AnnotationTypeBindingImpl((FlexibleRecordBinding)fieldLenType, this.dataBinding.getDeclaringPart()));
            fieldLen.setValue(new Integer(this.getDefaultFieldLen(type)), null, null, this.compilerOptions, false);
            fieldLen.setCalculated(true);
            this.dataBinding.addAnnotation(fieldLen);
        }
    }

    public int getDefaultFieldLen() {
        ITypeBinding type = this.dataBinding.getType().getBaseType();
        if (type.getKind() != 3) {
            return -1;
        }
        return this.getDefaultFieldLen(type);
    }

    private int getDefaultFieldLen(ITypeBinding type) {
        PrimitiveTypeBinding primType = (PrimitiveTypeBinding)type;
        Primitive prim = primType.getPrimitive();
        if (prim == Primitive.DATE) {
            return this.getDefaultDateFieldLen();
        }
        if (prim == Primitive.TIME) {
            return this.getDefaultTimeFieldLen();
        }
        if (prim == Primitive.TIMESTAMP) {
            return this.getDefaultTimeStampFieldLen();
        }
        return this.getDefaultFieldLen(primType);
    }

    private int getDefaultFieldLen(PrimitiveTypeBinding primType) {
        int length = primType.getLength();
        int scale = primType.getDecimals();
        switch (primType.getPrimitive().getType()) {
            case 12: {
                length += this.getNumericItemFormattingProperties(length, scale);
                if (scale > 0) {
                    ++length;
                }
                if (this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "Currency") != null) break;
                ++length;
                break;
            }
            case 17: {
                length = 10 + this.getNumericItemFormattingProperties(length, scale);
                break;
            }
            case 8: {
                length = 20 + this.getNumericItemFormattingProperties(length, scale);
                break;
            }
            case 1: 
            case 10: 
            case 18: {
                length += this.getNumericItemFormattingProperties(length, scale);
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 15: 
            case 16: {
                length += this.getNumericItemFormattingProperties(length, scale);
                if (scale <= 0) break;
                ++length;
                break;
            }
            case 5: {
                length *= 2;
                break;
            }
        }
        return length;
    }

    private int getNumericItemFormattingProperties(int precision, int scale) {
        EnumerationDataBinding sign;
        IAnnotationBinding signBinding;
        int length = 0;
        if (this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "Currency") != null) {
            String currencySymbol = null;
            IAnnotationBinding csBinding = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "CurrencySymbol");
            if (csBinding == null) {
                ++length;
            } else {
                currencySymbol = (String)csBinding.getValue();
                if (currencySymbol != null) {
                    length += currencySymbol.length();
                }
            }
        }
        if (this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "NumericSeparator") != null) {
            length += (precision - scale - 1) / 3;
        }
        if ((signBinding = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "Sign")) != null && (sign = (EnumerationDataBinding)signBinding.getValue()) != null) {
            if (sign.getName() == InternUtil.intern((String)"parens")) {
                length += 2;
            } else if (sign.getName() == InternUtil.intern((String)"leading") || sign.getName() == InternUtil.intern((String)"trailing")) {
                ++length;
            }
        }
        return length;
    }

    private int getDefaultDateFieldLen() {
        Object format;
        IAnnotationBinding binding = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "DateFormat");
        if (binding != null && (format = binding.getValue()) != null) {
            if (format instanceof IDataBinding) {
                IDataBinding dBinding = (IDataBinding)format;
                if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "vg"}, "VGVar", "SYSTEMGREGORIANDATEFORMAT") || AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "core"}, "StrLib", "DEFAULTDATEFORMAT")) {
                    return 10;
                }
                if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "vg"}, "VGVar", "SYSTEMJULIANDATEFORMAT")) {
                    return 8;
                }
            }
            if (format instanceof ClassConstantBinding) {
                return ((PrimitiveTypeBinding)((ClassConstantBinding)format).getType()).getLength();
            }
            return ((String)format).length();
        }
        return 10;
    }

    private int getDefaultTimeFieldLen() {
        Object format;
        IAnnotationBinding binding = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "TimeFormat");
        if (binding != null && (format = binding.getValue()) != null) {
            IDataBinding dBinding;
            if (format instanceof IDataBinding && AbstractBinder.dataBindingIs(dBinding = (IDataBinding)format, new String[]{"egl", "core"}, "StrLib", "DEFAULTTIMEFORMAT")) {
                return 8;
            }
            if (format instanceof ClassConstantBinding) {
                return ((PrimitiveTypeBinding)((ClassConstantBinding)format).getType()).getLength();
            }
            return ((String)format).length();
        }
        return 8;
    }

    private int getDefaultTimeStampFieldLen() {
        Object format;
        IAnnotationBinding binding = this.dataBinding.getAnnotation(new String[]{"egl", "ui"}, "TimestampFormat");
        if (binding != null && (format = binding.getValue()) != null) {
            IDataBinding dBinding;
            if (format instanceof IDataBinding && AbstractBinder.dataBindingIs(dBinding = (IDataBinding)format, new String[]{"egl", "core"}, "StrLib", "DEFAULTTIMESTAMPFORMAT")) {
                return 26;
            }
            if (format instanceof ClassConstantBinding) {
                return ((PrimitiveTypeBinding)((ClassConstantBinding)format).getType()).getLength();
            }
            return ((String)format).length();
        }
        return 26;
    }
}

