/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FileBindingCompletor
extends AbstractBinder {
    private FileBinding fileBinding;
    private IProblemRequestor problemRequestor;
    private List partImportDeclarations = new ArrayList();

    public FileBindingCompletor(Scope currentScope, FileBinding fileBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, fileBinding, dependencyRequestor, compilerOptions);
        this.fileBinding = fileBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(File file) {
        if (!file.hasPackageDeclaration()) {
            IPackageBinding defaultPackage = this.currentScope.getEnvironmentScope().getRootPackageBinding();
            this.fileBinding.setDeclaringPackage(defaultPackage);
        }
        return true;
    }

    @Override
    public void endVisit(File file) {
        this.processPartImportDeclarations();
        this.fileBinding.setValid(true);
    }

    private void processPartImportDeclarations() {
        HashMap<String, ITypeBinding> importedParts = new HashMap<String, ITypeBinding>();
        for (ImportDeclaration importDeclaration : this.partImportDeclarations) {
            Name name = importDeclaration.getName();
            try {
                ITypeBinding partBinding = this.bindTypeName(name);
                if (this.fileBinding.getDeclaringPackage() != null && this.fileBinding.getDeclaringPackage().getPackageName() == partBinding.getPackageName() || !((IPartBinding)partBinding).isPrivate()) {
                    if (importedParts.containsKey(partBinding.getName())) {
                        ITypeBinding resolvedBinding = (ITypeBinding)importedParts.get(partBinding.getName());
                        if (resolvedBinding.getPackageName() == partBinding.getPackageName()) continue;
                        this.problemRequestor.acceptProblem((Node)importDeclaration, 3328, new String[]{name.getCanonicalName()});
                        continue;
                    }
                    this.fileBinding.getPartBindings().add(partBinding);
                    importedParts.put(partBinding.getName(), partBinding);
                    continue;
                }
                this.problemRequestor.acceptProblem((Node)importDeclaration, 3260, new String[]{name.getCanonicalName()});
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
    }

    @Override
    public boolean visit(ImportDeclaration importDeclaration) {
        Name name = importDeclaration.getName();
        if (importDeclaration.isOnDemand()) {
            try {
                IPackageBinding packageBinding = this.bindPackageName(name);
                if (!this.fileBinding.getPackageBindings().contains(packageBinding)) {
                    this.fileBinding.getPackageBindings().add(packageBinding);
                }
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        } else {
            this.partImportDeclarations.add(importDeclaration);
        }
        return false;
    }

    @Override
    public boolean visit(PackageDeclaration packageDeclaration) {
        try {
            IPackageBinding packageBinding = this.bindPackageName(packageDeclaration.getName());
            this.fileBinding.setDeclaringPackage(packageBinding);
        }
        catch (ResolutionException resolutionException) {}
        return false;
    }

    public boolean visit(Part part) {
        return false;
    }
}

