/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;

public class HandlerBinding
extends FunctionContainerBinding {
    private List extendedInterfaces = Collections.EMPTY_LIST;
    private List constructors = Collections.EMPTY_LIST;
    private static final String[] EGLUIJSF = new String[]{"egl", "ui", "jsf"};

    public HandlerBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    private HandlerBinding(HandlerBinding old) {
        super(old);
        if (old.extendedInterfaces == Collections.EMPTY_LIST) {
            old.extendedInterfaces = new ArrayList();
        }
        if (old.constructors == Collections.EMPTY_LIST) {
            old.constructors = new ArrayList();
        }
        this.extendedInterfaces = old.extendedInterfaces;
        this.constructors = old.constructors;
    }

    @Override
    public void clear() {
        super.clear();
        this.extendedInterfaces = Collections.EMPTY_LIST;
        this.constructors = Collections.EMPTY_LIST;
    }

    public List getImplementedInterfaces() {
        return this.getExtendedInterfaces(new HashSet());
    }

    private List getExtendedInterfaces(Set interfacesAlreadyProcessed) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        for (ITypeBinding typeBinding : this.extendedInterfaces) {
            if (interfacesAlreadyProcessed.contains(typeBinding = this.realizeTypeBinding(typeBinding, this.getEnvironment())) || typeBinding.getKind() != 15) continue;
            result.add(typeBinding);
            result.addAll(((InterfaceBinding)typeBinding).getExtendedTypes(interfacesAlreadyProcessed));
        }
        return result;
    }

    public void addExtenedInterface(ITypeBinding interfaceBinding) {
        if (this.extendedInterfaces == Collections.EMPTY_LIST) {
            this.extendedInterfaces = new ArrayList();
        }
        this.extendedInterfaces.add(interfaceBinding);
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    public List getConstructors() {
        return this.constructors;
    }

    public void addConstructor(ConstructorBinding constructor) {
        if (this.constructors == Collections.EMPTY_LIST) {
            this.constructors = new ArrayList();
        }
        this.constructors.add(constructor);
    }

    @Override
    public int getKind() {
        return 10;
    }

    @Override
    protected byte[] getStructurallySignificantBytes() throws IOException {
        if (this.isJSFHandler()) {
            return this.calculateOnConstructionSignature();
        }
        return super.getStructurallySignificantBytes();
    }

    private boolean isJSFHandler() {
        return this.getAnnotation(EGLUIJSF, "JSFHandler") != null;
    }

    private byte[] calculateOnConstructionSignature() {
        IFunctionBinding funcBinding;
        Object value;
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        IDataBinding ocfField = this.getAnnotation(EGLUIJSF, "JSFHandler").findData("onConstructionFunction");
        if (ocfField != null && ocfField != IBinding.NOT_FOUND_BINDING && (value = ((IAnnotationBinding)ocfField).getValue()) instanceof IFunctionBinding && (funcBinding = (IFunctionBinding)value) != null && funcBinding != IBinding.NOT_FOUND_BINDING) {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);
                try {
                    for (FunctionParameterBinding parameter : funcBinding.getParameters()) {
                        objectOutputStream.writeBoolean(parameter.isInput());
                        objectOutputStream.writeBoolean(parameter.isOutput());
                        objectOutputStream.writeBoolean(parameter.isField());
                        objectOutputStream.writeBoolean(parameter.isSQLNullable());
                        this.writeTypeBindingReference(objectOutputStream, parameter.getType());
                    }
                }
                finally {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byteOutputStream.toByteArray();
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean isDeclarablePart() {
        return true;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        HandlerBinding nullable = new HandlerBinding(this);
        nullable.setNullable(true);
        return nullable;
    }

    @Override
    public boolean isInstantiable() {
        for (ConstructorBinding binding : this.getConstructors()) {
            if (binding.getParameters().size() != 0 || !binding.isPrivate()) continue;
            return false;
        }
        return super.isInstantiable();
    }
}

