/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class PackageBinding
extends Binding
implements IPackageBinding {
    private PackageBinding parent;
    private IEnvironment environment;
    private PackageBinding[] subPackages;
    private String[] packageName;

    public PackageBinding(String[] packageName, PackageBinding parent, IEnvironment environment) {
        super(packageName.length == 0 ? "" : packageName[packageName.length - 1]);
        this.packageName = packageName;
        this.parent = parent;
        this.environment = environment;
    }

    @Override
    public String[] getPackageName() {
        return this.packageName;
    }

    public PackageBinding getParent() {
        return this.parent;
    }

    private PackageBinding addPackage(String[] packageName) {
        PackageBinding packageBinding = new PackageBinding(packageName, this, this.environment);
        if (this.subPackages == null) {
            this.subPackages = new PackageBinding[]{packageBinding};
        } else {
            PackageBinding[] newSubPackages = new PackageBinding[this.subPackages.length + 1];
            System.arraycopy(this.subPackages, 0, newSubPackages, 0, this.subPackages.length);
            newSubPackages[this.subPackages.length] = packageBinding;
            this.subPackages = newSubPackages;
        }
        return packageBinding;
    }

    @Override
    public IPackageBinding resolvePackage(String simpleName) {
        if (this.subPackages != null) {
            int i = 0;
            while (i < this.subPackages.length) {
                if (this.subPackages[i].getName() == simpleName) {
                    return this.subPackages[i];
                }
                ++i;
            }
        }
        String[] subPackageName = new String[this.packageName.length + 1];
        System.arraycopy(this.packageName, 0, subPackageName, 0, this.packageName.length);
        subPackageName[this.packageName.length] = simpleName;
        subPackageName = InternUtil.intern((String[])subPackageName);
        if (this.environment.hasPackage(subPackageName)) {
            return this.addPackage(subPackageName);
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public ITypeBinding resolveType(String simpleName) {
        return this.environment.getPartBinding(this.packageName, simpleName);
    }

    @Override
    public boolean isPackageBinding() {
        return true;
    }
}

