/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;

public class PrimitiveTypeBindingImpl
extends PrimitiveTypeBinding {
    Primitive prim;
    int length;
    int decimals;
    String pattern;
    transient int bytes = -1;

    protected PrimitiveTypeBindingImpl(PrimitiveTypeBinding.PrimitiveSpec primSpec) {
        super(primSpec.toString());
        this.prim = primSpec.prim;
        this.length = primSpec.length;
        this.decimals = primSpec.decimals;
        this.pattern = primSpec.pattern;
    }

    private PrimitiveTypeBindingImpl(PrimitiveTypeBindingImpl old) {
        super(old.caseSensitiveInternedName);
        this.prim = old.prim;
        this.length = old.length;
        this.decimals = old.decimals;
        this.pattern = old.pattern;
        this.bytes = old.bytes;
    }

    private Object readResolve() {
        if (this.pattern == null) {
            return PrimitiveTypeBindingImpl.getInstance(this.prim, this.length, this.decimals);
        }
        return PrimitiveTypeBindingImpl.getInstance(this.prim, this.pattern);
    }

    @Override
    public Primitive getPrimitive() {
        return this.prim;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getDecimals() {
        return this.decimals;
    }

    @Override
    public String getTimeStampOrIntervalPattern() {
        return this.pattern;
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public boolean isReferentiallyEqual(ITypeBinding anotherTypeBinding) {
        return false;
    }

    @Override
    public ITypeBinding copyTypeBinding() {
        return this;
    }

    @Override
    public int getBytes() {
        if (this.bytes == -1) {
            this.bytes = this.length;
            switch (this.prim.getType()) {
                case 18: {
                    this.bytes = 2;
                    break;
                }
                case 10: {
                    this.bytes = 4;
                    break;
                }
                case 1: {
                    this.bytes = 8;
                    break;
                }
                case 17: {
                    this.bytes = 4;
                    break;
                }
                case 8: {
                    this.bytes = 8;
                    break;
                }
                case 2: {
                    if (this.bytes == 4) {
                        this.bytes = 2;
                        break;
                    }
                    if (this.bytes == 9) {
                        this.bytes = 4;
                        break;
                    }
                    if (this.bytes != 18) break;
                    this.bytes = 8;
                    break;
                }
                case 7: 
                case 12: 
                case 16: {
                    this.bytes = Math.round((float)(this.bytes + 1) / 2.0f);
                    break;
                }
                case 5: 
                case 19: 
                case 20: {
                    this.bytes *= 2;
                    break;
                }
                case 9: {
                    this.bytes /= 2;
                    break;
                }
                case 28: {
                    if (this.pattern == null) break;
                    TimestampOrIntervalSpec spec = TimestampOrIntervalSpec.createTimestampSpec(this.pattern);
                    this.bytes = spec.endCode - spec.startCode + spec.intervalPrecision;
                    break;
                }
                case 24: 
                case 25: {
                    if (this.pattern == null) break;
                    TimestampOrIntervalSpec spec = TimestampOrIntervalSpec.createIntervalSpec(this.pattern);
                    this.bytes = spec.endCode - spec.startCode + spec.intervalPrecision + 1;
                    break;
                }
            }
        }
        return this.bytes;
    }

    @Override
    public boolean isDynamic() {
        return this.prim == Primitive.ANY;
    }

    @Override
    public ITypeBinding getBaseType() {
        return this;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        PrimitiveTypeBindingImpl nullable = new PrimitiveTypeBindingImpl(this);
        nullable.setNullable(true);
        return nullable;
    }

    private static class TimestampOrIntervalSpec {
        byte intervalPrecision;
        byte startCode;
        byte endCode;
        public static final byte TU_YEAR = 0;
        public static final byte TU_MONTH = 2;
        public static final byte TU_DAY = 4;
        public static final byte TU_HOUR = 6;
        public static final byte TU_MINUTE = 8;
        public static final byte TU_SECOND = 10;
        public static final byte TU_F1 = 11;
        public static final byte TU_F2 = 12;
        public static final byte TU_F3 = 13;
        public static final byte TU_F4 = 14;
        public static final byte TU_F5 = 15;
        public static final byte TU_F6 = 16;

        private TimestampOrIntervalSpec() {
        }

        private static int intervalPrecision(String pattern) {
            int count = 1;
            char prevCh = pattern.charAt(0);
            int i = 1;
            while (i < pattern.length()) {
                if (pattern.charAt(i) != prevCh) break;
                prevCh = pattern.charAt(i);
                ++count;
                ++i;
            }
            return count;
        }

        private static int secondScale(String pattern) {
            int count = 1;
            char prevCh = pattern.charAt(pattern.length() - 1);
            int i = pattern.length() - 2;
            while (i >= 0) {
                if (pattern.charAt(i) != prevCh) break;
                prevCh = pattern.charAt(i);
                ++count;
                --i;
            }
            return count;
        }

        private static boolean isMonth(String pattern, String originalPattern, boolean bln) {
            if (bln) {
                int count = TimestampOrIntervalSpec.intervalPrecision(pattern);
                if (pattern.length() == count) {
                    int i = 0;
                    while (i < pattern.length()) {
                        if (originalPattern.charAt(i) != 'M') {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return pattern.charAt(count) == 'd';
            }
            int count = TimestampOrIntervalSpec.secondScale(pattern);
            if (pattern.length() == count) {
                int i = 0;
                while (i < pattern.length()) {
                    if (originalPattern.charAt(i) != 'M') {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return pattern.charAt(pattern.length() - count - 1) == 'y';
        }

        private static boolean isMinute(String pattern, String originalPattern, boolean bln) {
            if (bln) {
                int count = TimestampOrIntervalSpec.intervalPrecision(pattern);
                if (pattern.length() == count) {
                    int i = 0;
                    while (i < pattern.length()) {
                        if (originalPattern.charAt(i) != 'm') {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return pattern.charAt(count) == 's';
            }
            int count = TimestampOrIntervalSpec.secondScale(pattern);
            if (pattern.length() == count) {
                int i = 0;
                while (i < pattern.length()) {
                    if (originalPattern.charAt(i) != 'm') {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return pattern.charAt(pattern.length() - count - 1) == 'h';
        }

        public static TimestampOrIntervalSpec createIntervalSpec(String mixedCasePattern) {
            int intervalPrecision = 4;
            int startCode = 0;
            int endCode = 2;
            if (mixedCasePattern != null) {
                String pattern = mixedCasePattern.toLowerCase();
                if (pattern.startsWith("yy")) {
                    intervalPrecision = (byte)TimestampOrIntervalSpec.intervalPrecision(pattern);
                    startCode = 0;
                } else if (pattern.startsWith("mm") && TimestampOrIntervalSpec.isMonth(pattern, mixedCasePattern, true)) {
                    intervalPrecision = (byte)TimestampOrIntervalSpec.intervalPrecision(pattern);
                    startCode = 2;
                } else if (pattern.startsWith("dd")) {
                    intervalPrecision = (byte)TimestampOrIntervalSpec.intervalPrecision(pattern);
                    startCode = 4;
                } else if (pattern.startsWith("hh")) {
                    intervalPrecision = (byte)TimestampOrIntervalSpec.intervalPrecision(pattern);
                    startCode = 6;
                } else if (pattern.startsWith("mm") && TimestampOrIntervalSpec.isMinute(pattern, mixedCasePattern, true)) {
                    intervalPrecision = (byte)TimestampOrIntervalSpec.intervalPrecision(pattern);
                    startCode = 8;
                } else if (pattern.startsWith("ss")) {
                    intervalPrecision = (byte)TimestampOrIntervalSpec.intervalPrecision(pattern);
                    startCode = 10;
                }
                if (pattern.endsWith("yy")) {
                    endCode = 0;
                } else if (pattern.endsWith("mm") && TimestampOrIntervalSpec.isMonth(pattern, mixedCasePattern, false)) {
                    endCode = 2;
                } else if (pattern.endsWith("dd")) {
                    endCode = 4;
                } else if (pattern.endsWith("hh")) {
                    endCode = 6;
                } else if (pattern.endsWith("mm") && TimestampOrIntervalSpec.isMinute(pattern, mixedCasePattern, false)) {
                    endCode = 8;
                } else if (pattern.endsWith("ss")) {
                    endCode = 10;
                } else if (pattern.endsWith("f")) {
                    switch (TimestampOrIntervalSpec.secondScale(pattern)) {
                        case 1: {
                            endCode = 11;
                            break;
                        }
                        case 2: {
                            endCode = 12;
                            break;
                        }
                        case 3: {
                            endCode = 13;
                            break;
                        }
                        case 4: {
                            endCode = 14;
                            break;
                        }
                        case 5: {
                            endCode = 15;
                            break;
                        }
                        case 6: {
                            endCode = 16;
                        }
                    }
                }
            }
            TimestampOrIntervalSpec result = new TimestampOrIntervalSpec();
            result.startCode = startCode;
            result.endCode = (byte)endCode;
            result.intervalPrecision = (byte)intervalPrecision;
            return result;
        }

        public static TimestampOrIntervalSpec createTimestampSpec(String mixedCasePattern) {
            int length = 4;
            int startCode = 0;
            int endCode = 10;
            if (mixedCasePattern != null) {
                String pattern = mixedCasePattern.toLowerCase();
                if (pattern.startsWith("yy")) {
                    length = 4;
                    startCode = 0;
                } else if (pattern.startsWith("mm") && TimestampOrIntervalSpec.isMonth(pattern, mixedCasePattern, true)) {
                    length = 2;
                    startCode = 2;
                } else if (pattern.startsWith("dd")) {
                    length = 2;
                    startCode = 4;
                } else if (pattern.startsWith("hh")) {
                    length = 2;
                    startCode = 6;
                } else if (pattern.startsWith("mm") && TimestampOrIntervalSpec.isMinute(pattern, mixedCasePattern, true)) {
                    length = 2;
                    startCode = 8;
                } else if (pattern.startsWith("ss")) {
                    length = 2;
                    startCode = 10;
                }
                if (pattern.endsWith("yy")) {
                    endCode = 0;
                } else if (pattern.endsWith("mm") && TimestampOrIntervalSpec.isMonth(pattern, mixedCasePattern, false)) {
                    endCode = 2;
                } else if (pattern.endsWith("dd")) {
                    endCode = 4;
                } else if (pattern.endsWith("hh")) {
                    endCode = 6;
                } else if (pattern.endsWith("mm") && TimestampOrIntervalSpec.isMinute(pattern, mixedCasePattern, false)) {
                    endCode = 8;
                } else if (pattern.endsWith("ss")) {
                    endCode = 10;
                } else if (pattern.endsWith("f")) {
                    switch (TimestampOrIntervalSpec.secondScale(pattern)) {
                        case 1: {
                            endCode = 11;
                            break;
                        }
                        case 2: {
                            endCode = 12;
                            break;
                        }
                        case 3: {
                            endCode = 13;
                            break;
                        }
                        case 4: {
                            endCode = 14;
                            break;
                        }
                        case 5: {
                            endCode = 15;
                            break;
                        }
                        case 6: {
                            endCode = 16;
                        }
                    }
                }
            }
            TimestampOrIntervalSpec result = new TimestampOrIntervalSpec();
            result.startCode = startCode;
            result.endCode = (byte)endCode;
            result.intervalPrecision = (byte)length;
            return result;
        }
    }
}

