/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;

public class ServiceBinding
extends FunctionContainerBinding {
    private List extendedInterfaces = Collections.EMPTY_LIST;

    public ServiceBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    private ServiceBinding(ServiceBinding old) {
        super(old);
        if (old.extendedInterfaces == Collections.EMPTY_LIST) {
            old.extendedInterfaces = new ArrayList();
        }
        this.extendedInterfaces = old.extendedInterfaces;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    public List getImplementedInterfaces() {
        return this.getExtendedInterfaces(new HashSet());
    }

    private List getExtendedInterfaces(Set interfacesAlreadyProcessed) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        for (ITypeBinding typeBinding : this.extendedInterfaces) {
            if (interfacesAlreadyProcessed.contains(typeBinding = this.realizeTypeBinding(typeBinding, this.getEnvironment())) || typeBinding.getKind() != 15) continue;
            result.add(typeBinding);
            result.addAll(((InterfaceBinding)typeBinding).getExtendedTypes(interfacesAlreadyProcessed));
        }
        return result;
    }

    public void addExtenedInterface(ITypeBinding interfaceBinding) {
        if (this.extendedInterfaces == Collections.EMPTY_LIST) {
            this.extendedInterfaces = new ArrayList();
        }
        this.extendedInterfaces.add(interfaceBinding);
    }

    @Override
    public int getKind() {
        return 14;
    }

    @Override
    public void clear() {
        super.clear();
        this.extendedInterfaces = Collections.EMPTY_LIST;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    @Override
    public IDataBinding findPublicData(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        ServiceBinding nullable = new ServiceBinding(this);
        nullable.setNullable(true);
        return nullable;
    }

    @Override
    public boolean isInstantiable() {
        return false;
    }
}

