/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SyntaxError;

public class File
extends Node {
    private PackageDeclaration packageDeclarationOpt;
    private List importDeclarations;
    private List partsList;
    private Map partsMap;
    protected List blockComments;
    protected List lineComments;
    protected List lineBreaks;
    private List syntaxErrors;

    public File(PackageDeclaration packageDeclaration, List importDeclarations, List parts, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (packageDeclaration != null) {
            this.packageDeclarationOpt = packageDeclaration;
            packageDeclaration.setParent(this);
        }
        this.importDeclarations = this.setParent(importDeclarations);
        this.partsList = this.setParent(parts);
    }

    public List getImportDeclarations() {
        return this.importDeclarations;
    }

    public boolean hasPackageDeclaration() {
        return this.packageDeclarationOpt != null;
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclarationOpt;
    }

    public List getParts() {
        return this.partsList;
    }

    public boolean hasPart(String partName) {
        return this.getPart(partName) != null;
    }

    public Part getPart(String partName) {
        if (this.partsMap == null) {
            this.partsMap = new HashMap();
            for (Part nextPart : this.partsList) {
                this.partsMap.put(nextPart.getIdentifier(), nextPart);
            }
        }
        return (Part)this.partsMap.get(partName);
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.packageDeclarationOpt != null) {
                this.packageDeclarationOpt.accept(visitor);
            }
            File.acceptChildren(visitor, this.importDeclarations);
            File.acceptChildren(visitor, this.partsList);
        }
        visitor.endVisit(this);
    }

    protected void setSyntaxErrors(List syntaxErrors) {
        this.syntaxErrors = syntaxErrors;
    }

    protected List getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public boolean accept(ISyntaxErrorRequestor syntaxErrorRequestor) {
        boolean hasSyntaxError = false;
        Iterator iter = this.syntaxErrors.iterator();
        while (iter.hasNext()) {
            hasSyntaxError = true;
            SyntaxError syntaxError = (SyntaxError)iter.next();
            int problemType = syntaxError.type;
            int startOffset = syntaxError.startOffset;
            int endOffset = syntaxError.endOffset;
            int[] symbolTypes = syntaxError.symbolTypes;
            switch (problemType) {
                case 2112: {
                    syntaxErrorRequestor.incorrectPhrase(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2111: {
                    syntaxErrorRequestor.unexpectedPhrase(startOffset, endOffset);
                    break;
                }
                case 2100: {
                    syntaxErrorRequestor.missingNonTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2101: {
                    syntaxErrorRequestor.incorrectNonTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2102: {
                    syntaxErrorRequestor.missingPreviousNonTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2103: {
                    syntaxErrorRequestor.incorrectPreviousNonTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2109: {
                    syntaxErrorRequestor.unexpectedPreviousTerminal(startOffset, endOffset);
                    break;
                }
                case 2107: {
                    syntaxErrorRequestor.missingPreviousTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2108: {
                    syntaxErrorRequestor.incorrectPreviousTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2110: {
                    syntaxErrorRequestor.missingScopeCloser(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2106: {
                    syntaxErrorRequestor.unexpectedTerminal(startOffset, endOffset);
                    break;
                }
                case 2104: {
                    syntaxErrorRequestor.missingTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2105: {
                    syntaxErrorRequestor.incorrectTerminal(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 3019: {
                    syntaxErrorRequestor.keywordAsName(symbolTypes[0], startOffset, endOffset);
                    break;
                }
                case 2113: {
                    syntaxErrorRequestor.panicPhrase(startOffset, endOffset);
                    break;
                }
                case 2114: {
                    syntaxErrorRequestor.tooManyErrors();
                    break;
                }
                case 2200: {
                    syntaxErrorRequestor.unclosedString(startOffset, endOffset);
                    break;
                }
                case 2201: {
                    syntaxErrorRequestor.unclosedBlockComment(startOffset, endOffset);
                    break;
                }
                case 2202: {
                    syntaxErrorRequestor.unclosedSQL(startOffset, endOffset);
                    break;
                }
                case 2203: {
                    syntaxErrorRequestor.unclosedSQLCondition(startOffset, endOffset);
                    break;
                }
                case 2204: {
                    syntaxErrorRequestor.unclosedDLI(startOffset, endOffset);
                    break;
                }
                case 2205: {
                    syntaxErrorRequestor.invalidEscapeSequence(startOffset, endOffset);
                    break;
                }
                case 2206: {
                    syntaxErrorRequestor.whitespaceInSQL(startOffset, endOffset);
                    break;
                }
                case 2207: {
                    syntaxErrorRequestor.whitespaceInSQLCondition(startOffset, endOffset);
                    break;
                }
                case 2208: {
                    syntaxErrorRequestor.whitespaceInDLI(startOffset, endOffset);
                    break;
                }
                case 2209: {
                    syntaxErrorRequestor.invalidCharacterInHexLiteral(startOffset, endOffset);
                    break;
                }
                case 2003: {
                    syntaxErrorRequestor.missingEndForPart(startOffset, endOffset);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized problem type");
                }
            }
        }
        return hasSyntaxError;
    }

    public List getBlockComments() {
        return this.blockComments;
    }

    public List getLineComments() {
        return this.lineComments;
    }

    public List getLineBreaks() {
        return this.lineBreaks;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        PackageDeclaration newPackageDeclaration = this.packageDeclarationOpt != null ? (PackageDeclaration)this.packageDeclarationOpt.clone() : null;
        return new File(newPackageDeclaration, this.cloneList(this.importDeclarations), this.cloneList(this.partsList), this.getOffset(), this.getOffset() + this.getLength());
    }

    public File cloneFilePart() {
        try {
            PackageDeclaration newPackageDeclaration = this.packageDeclarationOpt != null ? (PackageDeclaration)this.packageDeclarationOpt.clone() : null;
            ArrayList<Object> newImportDeclarations = new ArrayList<Object>();
            Iterator iter = this.importDeclarations.iterator();
            while (iter.hasNext()) {
                newImportDeclarations.add(((Node)iter.next()).clone());
            }
            return new File(newPackageDeclaration, newImportDeclarations, Collections.EMPTY_LIST, this.getOffset(), this.getOffset() + this.getLength());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void addImportDeclaration(ImportDeclaration newImport) {
        if (this.importDeclarations.isEmpty()) {
            this.importDeclarations = new ArrayList();
        }
        newImport.setParent(this);
        this.importDeclarations.add(newImport);
    }
}

