/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;

public class NestedFunction
extends Node {
    private SimpleName name;
    private boolean isPrivate;
    private boolean isStatic;
    private boolean isAbstract;
    private List functionParameters;
    private ReturnsDeclaration returnsOpt;
    private List stmts;

    public NestedFunction(Boolean privateAccessModifierOpt, Boolean staticAccessModifierOpt, SimpleName name, List functionParameters, ReturnsDeclaration returnsOpt, List stmts, boolean isAbstract, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
        this.isPrivate = privateAccessModifierOpt;
        this.isStatic = staticAccessModifierOpt;
        this.isAbstract = isAbstract;
        this.functionParameters = this.setParent(functionParameters);
        if (returnsOpt != null) {
            this.returnsOpt = returnsOpt;
            returnsOpt.setParent(this);
        }
        this.stmts = this.setParent(stmts);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Name getName() {
        return this.name;
    }

    public List getFunctionParameters() {
        return this.functionParameters;
    }

    public boolean hasReturnType() {
        return this.returnsOpt != null;
    }

    public Type getReturnType() {
        return this.returnsOpt.getType();
    }

    public ReturnsDeclaration getReturnDeclaration() {
        return this.returnsOpt;
    }

    public boolean returnTypeIsSqlNullable() {
        return this.returnsOpt.isSqlNullable();
    }

    public List getStmts() {
        return this.stmts;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
            NestedFunction.acceptChildren(visitor, this.functionParameters);
            if (this.returnsOpt != null) {
                this.returnsOpt.accept(visitor);
            }
            NestedFunction.acceptChildren(visitor, this.stmts);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ReturnsDeclaration newReturnsOpt = this.returnsOpt != null ? (ReturnsDeclaration)this.returnsOpt.clone() : null;
        return new NestedFunction(new Boolean(this.isPrivate), new Boolean(this.isStatic), (SimpleName)this.name.clone(), this.cloneList(this.functionParameters), newReturnsOpt, this.cloneList(this.stmts), this.isAbstract, this.getOffset(), this.getOffset() + this.getLength());
    }
}

