/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;

public class NonTerminalInsertionRecovery
extends AbstractRecovery {
    private int parseCheckDistance;
    private int missingNonTerminal;

    public NonTerminalInsertionRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        super(errorStack, realStack, tokenStream, problemRequestor);
    }

    @Override
    protected void performTrial() {
        short[] nonterminalCandidates = this.errorStack.getNonTerminalCandidates(this.errorStack.getCurrentState());
        int i = 0;
        while (i < nonterminalCandidates.length) {
            ParseStack trialStack = this.errorStack.createCopy();
            trialStack.processNonTerminal(nonterminalCandidates[i]);
            int trialDistance = trialStack.parseCheck(this.tokenStream);
            if (trialDistance > this.parseCheckDistance) {
                this.parseCheckDistance = trialDistance;
                this.missingNonTerminal = nonterminalCandidates[i];
            }
            ++i;
        }
    }

    @Override
    public float getMisspellingIndex() {
        return 0.0f;
    }

    @Override
    public int getParseCheckDistance() {
        return this.parseCheckDistance;
    }

    @Override
    public int performRecovery() {
        int lookAheadTerminalType = this.tokenStream.getLookAhead().symbolType;
        ParseStack newStack = this.errorStack.createCopy();
        newStack.processNonTerminal(this.missingNonTerminal);
        int highestNonTerminalType = newStack.getHighestNonTerminal(lookAheadTerminalType);
        this.problemRequestor.missingNonTerminal(highestNonTerminalType, this.tokenStream.getLookAhead().left, this.tokenStream.getLookAhead().right);
        int currentState = this.errorStack.getCurrentState();
        short gotoState = this.errorStack.get_reduce(currentState, highestNonTerminalType);
        Symbol nonTerminal = new Symbol(highestNonTerminalType, gotoState);
        this.realStack.push(nonTerminal);
        this.errorStack.processNonTerminal(highestNonTerminalType);
        return this.realStack.size() - 1;
    }
}

