/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;

public class OnExceptionBlock
extends Node {
    private List stmts;
    private SimpleName idOpt;
    private Type typeOpt;

    public OnExceptionBlock(List stmts, SimpleName idOpt, Type typeOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.stmts = this.setParent(stmts);
        if (idOpt != null) {
            this.idOpt = idOpt;
            idOpt.setParent(this);
        }
        if (typeOpt != null) {
            this.typeOpt = typeOpt;
            typeOpt.setParent(this);
        }
    }

    public List getStmts() {
        return this.stmts;
    }

    public boolean hasExceptionDeclaration() {
        return this.idOpt != null;
    }

    public Name getExceptionName() {
        return this.idOpt;
    }

    public Type getExceptionType() {
        return this.typeOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            OnExceptionBlock.acceptChildren(visitor, this.stmts);
            if (this.hasExceptionDeclaration()) {
                this.idOpt.accept(visitor);
                this.typeOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SimpleName newName = this.idOpt == null ? null : (SimpleName)this.idOpt.clone();
        Type newType = this.typeOpt == null ? null : (Type)this.typeOpt.clone();
        return new OnExceptionBlock(this.cloneList(this.stmts), newName, newType, this.getOffset(), this.getOffset() + this.getLength());
    }
}

