/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;

public class StructureItem
extends Node {
    private String levelOpt;
    private SimpleName name;
    private Type type;
    private SettingsBlock settingsBlockOpt;
    private Expression initializerOpt;
    String occursOpt;
    private boolean isFiller;
    private boolean isEmbedded;
    private IBinding binding;

    public StructureItem(String levelOpt, SimpleName name, Type type, String occursOpt, SettingsBlock settingsBlockOpt, Expression initializerOpt, boolean isFiller, boolean isEmbedded, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.levelOpt = levelOpt;
        if (name != null) {
            this.name = name;
            name.setParent(this);
        }
        if (type != null) {
            this.type = type;
            type.setParent(this);
        }
        this.occursOpt = occursOpt;
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        if (initializerOpt != null) {
            this.initializerOpt = initializerOpt;
            initializerOpt.setParent(this);
        }
        this.isFiller = isFiller;
        this.isEmbedded = isEmbedded;
    }

    public boolean hasLevel() {
        return this.levelOpt != null;
    }

    public String getLevel() {
        return this.levelOpt;
    }

    public Name getName() {
        return this.name;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasOccurs() {
        return this.occursOpt != null;
    }

    public String getOccurs() {
        return this.occursOpt;
    }

    public boolean isFiller() {
        return this.isFiller;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public boolean hasInitializer() {
        return this.initializerOpt != null;
    }

    public Expression getInitializer() {
        return this.initializerOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.name != null) {
                this.name.accept(visitor);
            }
            if (this.type != null) {
                this.type.accept(visitor);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
            if (this.initializerOpt != null) {
                this.initializerOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public IBinding resolveBinding() {
        if (this.binding != null) {
            return this.binding;
        }
        if (!this.isFiller && !this.isEmbedded) {
            return this.getName().resolveBinding();
        }
        return null;
    }

    public void setBinding(IBinding binding) {
        this.binding = binding;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        String newLevelOpt = this.levelOpt != null ? new String(this.levelOpt) : null;
        SimpleName newName = this.name != null ? (SimpleName)this.name.clone() : null;
        Type newType = this.type != null ? (Type)this.type.clone() : null;
        String newOccursOpt = this.occursOpt != null ? new String(this.occursOpt) : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        Expression newInitializerOpt = this.initializerOpt != null ? (Expression)this.initializerOpt.clone() : null;
        return new StructureItem(newLevelOpt, newName, newType, newOccursOpt, newSettingsBlockOpt, newInitializerOpt, this.isFiller, this.isEmbedded, this.getOffset(), this.getOffset() + this.getLength());
    }
}

