/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.LinkedList;
import java.util.List;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Terminal;

public class TokenStream
implements ITokenStream {
    private LinkedList cachedLookAheads;
    private LinkedList cachedLookAheadSymbols;
    private int cacheCapacity;
    private int rolledBack;
    private Scanner lexer;

    public TokenStream(int cacheCapacity, Scanner lexer) {
        this.cacheCapacity = cacheCapacity;
        this.lexer = lexer;
        Symbol symbol = this.lex();
        this.cachedLookAheadSymbols = new LinkedList();
        this.cachedLookAheadSymbols.addLast(symbol);
        Terminal terminal = new Terminal(symbol.sym, symbol.left, symbol.right, 0);
        this.cachedLookAheads = new LinkedList();
        this.cachedLookAheads.addLast(terminal);
    }

    protected Scanner getLexer() {
        return this.lexer;
    }

    public List getLexerErrors() {
        if (this.lexer instanceof Lexer) {
            return ((Lexer)this.lexer).getLexerErrors();
        }
        return null;
    }

    @Override
    public Terminal getLookAhead() {
        return (Terminal)this.cachedLookAheads.getFirst();
    }

    public Symbol getLookAheadSymbol() {
        return (Symbol)this.cachedLookAheadSymbols.getFirst();
    }

    @Override
    public void advanceLookAhead() {
        this.cachedLookAheadSymbols.removeFirst();
        this.cachedLookAheads.removeFirst();
        if (this.rolledBack == 0) {
            Symbol symbol = this.lex();
            this.cachedLookAheadSymbols.addLast(symbol);
            Terminal terminal = new Terminal(symbol.sym, symbol.left, symbol.right, 0);
            this.cachedLookAheads.addLast(terminal);
        }
        if (this.rolledBack > 0) {
            --this.rolledBack;
        }
    }

    @Override
    public void rollBack(Terminal terminal, Symbol symbol) {
        this.cachedLookAheads.addFirst(terminal);
        this.cachedLookAheadSymbols.addFirst(symbol);
        ++this.rolledBack;
    }

    @Override
    public int getCacheCapcity() {
        return this.cacheCapacity;
    }

    @Override
    public Terminal peekLookAhead(int pos) {
        while (pos >= this.cachedLookAheads.size()) {
            Symbol symbol = this.lex();
            this.cachedLookAheadSymbols.addLast(symbol);
            Terminal terminal = new Terminal(symbol.sym, symbol.left, symbol.right, 0);
            this.cachedLookAheads.addLast(terminal);
        }
        return (Terminal)this.cachedLookAheads.get(pos);
    }

    @Override
    public ITokenStream createTokenStreamAtOffset(int offset) {
        return new SubTokenStream(offset);
    }

    private Symbol lex() {
        try {
            Symbol symbol;
            block5: while (true) {
                symbol = this.lexer.next_token();
                switch (symbol.sym) {
                    case 64: 
                    case 65: 
                    case 66: {
                        continue block5;
                    }
                }
                break;
            }
            return symbol;
        }
        catch (Exception exception) {
            throw new RuntimeException("Should never happen");
        }
    }

    public String toString() {
        return this.cachedLookAheads.toString();
    }

    private class SubTokenStream
    implements ITokenStream {
        int offset;
        int cacheCapacity;

        SubTokenStream(int offset) {
            this.offset = offset;
            this.cacheCapacity = TokenStream.this.cacheCapacity - offset;
        }

        @Override
        public void advanceLookAhead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rollBack(Terminal terminal, Symbol symbol) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITokenStream createTokenStreamAtOffset(int offset) {
            return new SubTokenStream(this.offset + offset);
        }

        @Override
        public int getCacheCapcity() {
            return this.cacheCapacity;
        }

        @Override
        public Terminal getLookAhead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Terminal peekLookAhead(int pos) {
            return TokenStream.this.peekLookAhead(pos + this.offset);
        }

        public String toString() {
            return TokenStream.this.cachedLookAheads.subList(this.offset, TokenStream.this.cachedLookAheads.size()).toString();
        }
    }
}

