/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.TransferStatementBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class TransferStatement
extends Statement {
    private TransferTarget transferTargetOpt;
    private Expression expr;
    private Expression passingRecordOpt;
    private SettingsBlock settingsBlockOpt;
    private TransferStatementBinding statementBinding;

    public TransferStatement(TransferTarget transferTargetOpt, Expression expr, Expression passingRecordOpt, SettingsBlock settingsBlockOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.transferTargetOpt = transferTargetOpt;
        this.expr = expr;
        expr.setParent(this);
        if (passingRecordOpt != null) {
            this.passingRecordOpt = passingRecordOpt;
            passingRecordOpt.setParent(this);
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
    }

    public boolean isToProgram() {
        return this.transferTargetOpt == TransferTarget.PROGRAM || this.transferTargetOpt == null;
    }

    public boolean isToTransaction() {
        return this.transferTargetOpt == TransferTarget.TRANSACTION;
    }

    public Expression getInvocationTarget() {
        return this.expr;
    }

    public Name getTargetName() {
        throw new RuntimeException();
    }

    public boolean hasPassingRecord() {
        return this.passingRecordOpt != null;
    }

    public Expression getPassingRecord() {
        return this.passingRecordOpt;
    }

    public boolean isExternallyDefined() {
        return false;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            if (this.passingRecordOpt != null) {
                this.passingRecordOpt.accept(visitor);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Expression newPassingRecordOpt = this.passingRecordOpt != null ? (Expression)this.passingRecordOpt.clone() : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        return new TransferStatement(this.transferTargetOpt, (Expression)this.expr.clone(), newPassingRecordOpt, newSettingsBlockOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public TransferStatementBinding getStatementBinding() {
        return this.statementBinding;
    }

    public void setStatementBinding(TransferStatementBinding statementBinding) {
        this.statementBinding = statementBinding;
    }

    public static class TransferTarget {
        public static final TransferTarget PROGRAM = new TransferTarget();
        public static final TransferTarget TRANSACTION = new TransferTarget();

        private TransferTarget() {
        }
    }
}

