/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IOStatementClauseInfo;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.WithInlineClause;

public class WithInlineSQLClause
extends WithInlineClause {
    public static IOStatementClauseInfo INFO = new IOStatementClauseInfo(){

        @Override
        public String getClauseKeyword() {
            return "with";
        }

        @Override
        public String getContentPrefix() {
            return "#sql{";
        }

        @Override
        public String getContentSuffix() {
            return "}";
        }

        @Override
        public int getContentType() {
            return 1;
        }
    };
    private InlineSQLStatement sqlStmt;

    public WithInlineSQLClause(InlineSQLStatement sqlStmt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.sqlStmt = sqlStmt;
        sqlStmt.setParent(this);
    }

    public InlineSQLStatement getSqlStmt() {
        return this.sqlStmt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.sqlStmt.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new WithInlineSQLClause((InlineSQLStatement)this.sqlStmt.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public boolean isWithInlineSQL() {
        return true;
    }

    @Override
    public String getStatement() {
        return this.getSqlStmt().getValue();
    }
}

