/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import org.eclipse.edt.compiler.internal.EGLKeywordHandler;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;

public class EGLValidNameUtil {
    public static String getValidEglName(String eglName) {
        return EGLValidNameUtil.getValidEglName(eglName, false);
    }

    public static String getValidEglPackageName(String eglName) {
        return EGLValidNameUtil.getValidEglName(eglName, true);
    }

    private static String getValidEglName(String eglName, boolean forPackage) {
        if (eglName == null) {
            return "null";
        }
        if (EGLKeywordHandler.getKeywordHashSet().contains(eglName.toLowerCase())) {
            return "_" + eglName;
        }
        if (!EGLNameValidator.mildValidateCharacters(eglName, DefaultCompilerOptions.getInstance())) {
            return EGLValidNameUtil.fixName(eglName);
        }
        if (EGLNameValidator.startsWithEZE(eglName)) {
            return "_" + eglName;
        }
        return eglName;
    }

    public static String fixName(String name) {
        if (name == null) {
            return "null";
        }
        if (name.length() == 0) {
            return name;
        }
        StringBuffer eName = new StringBuffer(name);
        if (!Character.isJavaIdentifierStart(eName.charAt(0))) {
            eName.replace(0, 1, "_");
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                eName.replace(i, i + 1, "_");
            }
            ++i;
        }
        return eName.toString();
    }
}

