/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBindingCompletor;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultScope;
import org.eclipse.edt.compiler.internal.core.lookup.FlexibleRecordScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FlexibleRecordBinder
extends DefaultBinder {
    private FlexibleRecordBinding recordBinding;
    private Scope scope;

    public FlexibleRecordBinder(FlexibleRecordBinding recordBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, recordBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.recordBinding = recordBinding;
        this.scope = scope;
    }

    @Override
    public boolean visit(Record record) {
        record.accept(new FlexibleRecordBindingCompletor(this.scope, this.recordBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.currentScope = new FlexibleRecordScope(this.currentScope, this.recordBinding);
        return true;
    }

    @Override
    public boolean visit(StructureItem item) {
        if (item.hasSettingsBlock()) {
            item.getSettingsBlock().accept(this);
        }
        if (item.hasInitializer()) {
            item.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(Assignment assignment) {
        Scope currentScopeParent = this.currentScope.getParentScope();
        this.currentScope.setParentScope(new DefaultScope());
        assignment.getLeftHandSide().accept(this);
        this.currentScope.setParentScope(currentScopeParent);
        assignment.getRightHandSide().accept(this);
        return false;
    }
}

