/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.ForeignLanguageTypeBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NilBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.SystemFunctionParameterSpecialTypeBinding;
import org.eclipse.edt.compiler.binding.VariableBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CharLiteral;
import org.eclipse.edt.compiler.core.ast.DBCharLiteral;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.HexLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.MBCharLiteral;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FunctionArgumentValidator
extends DefaultASTVisitor {
    private static Map specialCaseArgumentCheckers = new HashMap();
    private static Map specialCaseFunctionCheckers;
    private IProblemRequestor problemRequestor;
    private IFunctionBinding functionBinding;
    private IPartBinding functionContainerBinding;
    private IInvocationNode fInvocationNode;
    private String canonicalFunctionName;
    private Iterator parameterIter;
    private int numArgs = 0;
    private ICompilerOptions compilerOptions;
    private static Map specialSystemFunctionParameterCheckers;

    static {
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(null, null, ArrayTypeBinding.APPENDELEMENT.getName()), 1), new ArrayElementArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(null, null, ArrayTypeBinding.APPENDALL.getName()), 1), new AppendAllArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "io", "dli"}, "DLILib", "EGLTDLI"), 2), new EGLTDLIArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(null, null, ArrayTypeBinding.INSERTELEMENT.getName()), 1), new ArrayElementArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(null, null, ArrayTypeBinding.INDEXOFELEMENT1.getName()), 1), new ArrayElementArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "BYTES"), 1), new BytesArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERT"), 1), new ConvertArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTBIDI"), 1), new ConvertBidiArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTBIDI"), 3), new ConvertBidiArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTENCODEDTEXTTOSTRING"), 1), new StringNotAllowedArgumentChecker(true));
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "MAXIMUMSIZE"), 1), new MaximumSizeArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "PURGE"), 1), new PurgeArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "SETERROR"), 1), new SetErrorArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "SIZE"), 1), new SizeArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "vg"}, "VGLib", "STARTTRANSACTION"), 1), new StartTransactionArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "vg"}, "VGLib", "STARTTRANSACTION"), 2), new StringNotAllowedArgumentChecker(true));
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "vg"}, "VGLib", "VGTDLI"), 2), new VGTDLIArgumentChecker());
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTUNICODENUMTONUMBER"), 1), new UnicodeConversionFunctionArgumentChecker(true));
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTUNSIGNEDUNICODENUMTONUMBER"), 1), new UnicodeConversionFunctionArgumentChecker(false));
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTNUMBERTOUNICODENUM"), 2), new UnicodeConversionFunctionArgumentChecker(true));
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERTNUMBERTOUNSIGNEDUNICODENUM"), 2), new UnicodeConversionFunctionArgumentChecker(false));
        specialCaseArgumentCheckers.put(new ArgInfo(new FunctionIdentifier(new String[]{"egl", "java"}, "PortalLib", "SETPORTLETSESSIONATTR"), 2), new NullNotAllowedArgumentChecker());
        specialCaseFunctionCheckers = new HashMap();
        specialCaseFunctionCheckers.put(new FunctionIdentifier(new String[]{"egl", "core"}, "SysLib", "CONVERT"), new ConvertArgumentChecker());
        specialSystemFunctionParameterCheckers = new HashMap();
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.ANYEGL, AnyEGLArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.ANYEGLORASJAVA, AnyEGLOrAsJavaArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.ARRAYORTABLE, ArrayOrTableArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.ATTRIBUTE, AttributeArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.CONSOLEFORM, ConsoleFormArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.OBJIDTYPE, ObjIdTypeArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.OBJIDTYPEOPT, ObjIdTypeOptArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.RECORD, RecordArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.FLEXIBLERECORD, FlexibleRecordArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.RECORDORDICTIONARY, RecordOrDictionaryArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.SERVICEORINTERFACE, ServiceOrInterfaceArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.TEXTFIELD, TextFieldArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.VAGTEXT, VAGTextArgumentChecker.INSTANCE);
        specialSystemFunctionParameterCheckers.put(SystemFunctionParameterSpecialTypeBinding.VAGTEXTORNUMERIC, VAGTextOrNumericChecker.INSTANCE);
    }

    private static IArgumentChecker getSpecialCaseArgChecker(IFunctionBinding functionBinding, int argNum) {
        IArgumentChecker result = (IArgumentChecker)specialCaseArgumentCheckers.get(new ArgInfo(new FunctionIdentifier(functionBinding), argNum));
        if (result == null) {
            result = (IArgumentChecker)specialCaseFunctionCheckers.get(new FunctionIdentifier(functionBinding));
        }
        return result;
    }

    public FunctionArgumentValidator(IFunctionBinding functionBinding, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.functionBinding = functionBinding;
        this.functionContainerBinding = functionContainerBinding;
        this.parameterIter = functionBinding.getParameters().iterator();
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        this.fInvocationNode = new FunctionInvocationNode(functionInvocation);
        functionInvocation.getTarget().accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SimpleName simpleName) {
                FunctionArgumentValidator.this.canonicalFunctionName = simpleName.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                String canonicalName = qualifiedName.getCanonicalName();
                FunctionArgumentValidator.this.canonicalFunctionName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
                return false;
            }
        });
        if (this.canonicalFunctionName == null) {
            this.canonicalFunctionName = functionInvocation.getTarget().getCanonicalString();
        }
        Iterator iter = functionInvocation.getArguments().iterator();
        while (iter.hasNext()) {
            this.checkArg((Expression)iter.next());
        }
        return false;
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        this.fInvocationNode = new CallInvocationNode(callStatement);
        this.canonicalFunctionName = callStatement.getInvocationTarget().getCanonicalString();
        if (!callStatement.hasArguments()) {
            return false;
        }
        Iterator iter = callStatement.getArguments().iterator();
        while (iter.hasNext()) {
            this.checkArg((Expression)iter.next());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArg(Expression argExpr) {
        FunctionParameterBinding parameterBinding;
        ++this.numArgs;
        if (!this.parameterIter.hasNext()) {
            if (!this.functionBinding.isSystemFunction() || this.functionBinding.getValidNumbersOfArguments()[0] != -1) return false;
            parameterBinding = (FunctionParameterBinding)this.functionBinding.getParameters().get(this.functionBinding.getParameters().size() - 1);
        } else {
            parameterBinding = (FunctionParameterBinding)this.parameterIter.next();
        }
        ITypeBinding parameterType = parameterBinding.getType();
        ITypeBinding argType = argExpr.resolveTypeBinding();
        if (argType == null || argType == IBinding.NOT_FOUND_BINDING) {
            return false;
        }
        if (!this.checkArgumentNotSetValuesExpression(argExpr)) {
            return false;
        }
        if (!this.checkNativeLibraryArgumentNotSubstructuredItem(argExpr)) {
            return false;
        }
        if (!this.checkPSBRecordNotUsedAsArgument(argType, argExpr)) {
            return false;
        }
        if (!this.checkSubstringNotUsedAsArgument(parameterBinding, argExpr)) {
            return false;
        }
        if (!this.checkArgumentUsedCorrectlyWithInAndOut(argExpr, parameterBinding, parameterType)) {
            return false;
        }
        if (!this.checkArgumentUsedCorrectlyWithNullable(argExpr, parameterBinding)) {
            return false;
        }
        if (!this.checkArgumentUsedCorrectlyWithField(argExpr, parameterBinding)) {
            return false;
        }
        IArgumentChecker specialCaseArgChecker = FunctionArgumentValidator.getSpecialCaseArgChecker(this.functionBinding, this.numArgs);
        if (specialCaseArgChecker != null) {
            specialCaseArgChecker.checkArg(this.numArgs, argExpr, argType, this.fInvocationNode, this.functionContainerBinding, this.problemRequestor, this.compilerOptions, this.functionBinding);
            if (specialCaseArgChecker.performsCompleteCheck()) {
                return false;
            }
        }
        boolean argMatchesParm = true;
        argMatchesParm = 23 == parameterType.getKind() ? this.checkArgForSpecialTypeParameter(argExpr, argType, parameterType, this.numArgs) : (parameterBinding.isInput() ? this.checkArgForInParameter(argExpr, argType, parameterBinding, parameterType, this.numArgs) : (parameterBinding.isOutput() ? this.checkArgForOutParameter(argExpr, argType, parameterBinding, parameterType, this.numArgs) : this.checkArgForInOutParameter(argExpr, argType, parameterBinding, parameterType, this.numArgs)));
        if (!argMatchesParm) {
            return false;
        }
        if (!this.checkNoDynamicTypesPassedToMathLibFunctions(argExpr, argType, parameterBinding, parameterType)) {
            return false;
        }
        this.checkNullPassedToNonNullable(argExpr, parameterType, parameterBinding);
        return false;
    }

    private void checkNullPassedToNonNullable(Expression argExpr, ITypeBinding parameterType, FunctionParameterBinding parameterBinding) {
        if (argExpr.resolveTypeBinding() == NilBinding.INSTANCE && Binding.isValidBinding(parameterType) && !parameterType.isNullable()) {
            this.problemRequestor.acceptProblem((Node)argExpr, 5619, new String[]{parameterBinding.getCaseSensitiveName(), this.functionBinding.getCaseSensitiveName()});
        }
    }

    @Override
    public void endVisit(FunctionInvocation functionInvocation) {
        if (!this.checkCorrectNumberOfArgumentsForSystemFunction()) {
            return;
        }
    }

    @Override
    public void endVisit(CallStatement callStatement) {
        if (!this.checkCorrectNumberOfArgumentsForSystemFunction()) {
            return;
        }
    }

    private boolean checkArgumentNotSetValuesExpression(final Expression argExpr) {
        final boolean[] result = new boolean[]{true};
        argExpr.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem(argExpr, 7511);
                result[0] = false;
                return false;
            }
        });
        return result[0];
    }

    private boolean checkNativeLibraryArgumentNotSubstructuredItem(Expression argExpr) {
        IDataBinding argDBinding;
        if (!this.functionBinding.isSystemFunction() && this.functionBinding.getDeclarer().getAnnotation(new String[]{"egl", "core"}, "NativeLibrary") != null && (argDBinding = argExpr.resolveDataBinding()) != null && argDBinding != IBinding.NOT_FOUND_BINDING && 5 == argDBinding.getKind() && !((StructureItemBinding)argDBinding).getChildren().isEmpty()) {
            this.problemRequestor.acceptProblem((Node)argExpr, 5618, new String[]{argExpr.getCanonicalString(), String.valueOf(this.functionBinding.getDeclarer().getCaseSensitiveName()) + "." + this.functionBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    private boolean checkPSBRecordNotUsedAsArgument(ITypeBinding argType, Expression argExpr) {
        if (argType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
            this.problemRequestor.acceptProblem((Node)argExpr, 7930, new String[]{argExpr.getCanonicalString()});
            return false;
        }
        return true;
    }

    private boolean checkSubstringNotUsedAsArgument(FunctionParameterBinding parm, Expression argExpr) {
        if (Binding.isValidBinding(parm) && !parm.isInput() && argExpr instanceof SubstringAccess) {
            this.problemRequestor.acceptProblem((Node)argExpr, 6649, new String[0]);
            return false;
        }
        return true;
    }

    private boolean checkArgumentUsedCorrectlyWithInAndOut(Expression argExpr, final FunctionParameterBinding parmBinding, ITypeBinding parmType) {
        VariableBinding variableBinding;
        ITypeBinding argTypeBinding = argExpr.resolveTypeBinding();
        if (!Binding.isValidBinding(argTypeBinding)) {
            return true;
        }
        final boolean[] expressionIsLiteralOrName = new boolean[]{true};
        final boolean[] foundError = new boolean[1];
        argExpr.accept(new NonLiteralAndNonNameExpressionVisitor(){

            @Override
            void handleExpressionThatIsNotNameOrLiteral(Expression expression) {
                if (!parmBinding.isInput()) {
                    if (FunctionArgumentValidator.this.functionBinding.isSystemFunction()) {
                        FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)expression, 5046, new String[]{FunctionArgumentValidator.this.functionBinding.getCaseSensitiveName()});
                    } else {
                        FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)expression, 6674, new String[]{expression.getCanonicalString(), FunctionArgumentValidator.this.functionBinding.getCaseSensitiveName()});
                    }
                    foundError[0] = true;
                }
                expressionIsLiteralOrName[0] = false;
            }
        });
        if (foundError[0]) {
            return false;
        }
        if (expressionIsLiteralOrName[0] && !parmBinding.isInput() && !this.checkArgNotConstantOrLiteral(argExpr, 6675)) {
            return false;
        }
        if (expressionIsLiteralOrName[0] && !parmBinding.isInput() && !parmBinding.isOutput() && !parmBinding.isConst() && 3 == parmType.getKind() && Primitive.isDateTimeType(((PrimitiveTypeBinding)parmType).getPrimitive()) && !this.checkArgNotConstantOrLiteral(argExpr, 6673)) {
            return false;
        }
        IDataBinding argDBinding = argExpr.resolveDataBinding();
        if (argDBinding != null && argDBinding != IBinding.NOT_FOUND_BINDING && (2 == argDBinding.getKind() || 3 == argDBinding.getKind() || 4 == argDBinding.getKind()) && (variableBinding = (VariableBinding)argDBinding).isReadOnly() && !parmBinding.isInput()) {
            this.problemRequestor.acceptProblem((Node)argExpr, 7741, new String[]{this.getCanonicalStringNoSubscripts(argExpr)});
            return false;
        }
        return true;
    }

    private boolean checkArgumentUsedCorrectlyWithNullable(Expression argExpr, FunctionParameterBinding parmBinding) {
        if (parmBinding.isSQLNullable()) {
            IDataBinding argDBinding = argExpr.resolveDataBinding();
            boolean argIsValid = false;
            if (argDBinding != null) {
                if (argDBinding == IBinding.NOT_FOUND_BINDING) {
                    argIsValid = true;
                } else {
                    IPartBinding declaringPart = argDBinding.getDeclaringPart();
                    IAnnotationBinding isNullableABinding = argDBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "IsSqlNullable");
                    if (isNullableABinding != null) {
                        argIsValid = isNullableABinding.getValue() == Boolean.YES;
                    } else if (6 == declaringPart.getKind()) {
                        if (argDBinding.getDeclaringPart().getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null) {
                            argIsValid = true;
                        }
                    } else {
                        argIsValid = 8 != declaringPart.getKind();
                    }
                }
            }
            if (!argIsValid) {
                this.problemRequestor.acceptProblem((Node)argExpr, 6682, new String[]{argExpr.getCanonicalString(), this.functionBinding.getCaseSensitiveName()});
                return false;
            }
        }
        return true;
    }

    private boolean checkArgumentUsedCorrectlyWithField(Expression argExpr, FunctionParameterBinding parmBinding) {
        if (parmBinding.isField() && !this.functionBinding.isSystemFunction()) {
            IDataBinding argDBinding = argExpr.resolveDataBinding();
            boolean argIsValid = false;
            if (argDBinding != null) {
                if (argDBinding == IBinding.NOT_FOUND_BINDING) {
                    argIsValid = true;
                } else if (argDBinding.getKind() == 0) {
                    argIsValid = ((FunctionParameterBinding)argDBinding).isField();
                } else if (7 == argDBinding.getKind()) {
                    argIsValid = true;
                }
            }
            if (!argIsValid) {
                this.problemRequestor.acceptProblem((Node)argExpr, 6683, new String[]{argExpr.getCanonicalString(), this.functionBinding.getCaseSensitiveName()});
                return false;
            }
        }
        return true;
    }

    private boolean checkArgNotConstantOrLiteral(Expression argExpr, final int problemKind) {
        IDataBinding argDBinding = argExpr.resolveDataBinding();
        if (argDBinding != null && argDBinding != IBinding.NOT_FOUND_BINDING && (2 == argDBinding.getKind() || 3 == argDBinding.getKind()) && ((VariableBinding)argDBinding).isConstant()) {
            this.problemRequestor.acceptProblem((Node)argExpr, problemKind, new String[]{argExpr.getCanonicalString(), this.functionBinding.getName()});
            return false;
        }
        final boolean[] foundError = new boolean[1];
        argExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisitName(Name name) {
            }

            @Override
            public void endVisit(ArrayAccess arrayAccess) {
            }

            @Override
            public void endVisit(FieldAccess fieldAccess) {
            }

            @Override
            public void endVisit(SubstringAccess substringAccess) {
            }

            @Override
            public void endVisitExpression(Expression expression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)expression, problemKind, new String[]{expression.getCanonicalString(), FunctionArgumentValidator.this.functionBinding.getCaseSensitiveName()});
                foundError[0] = true;
            }
        });
        return !foundError[0];
    }

    private boolean isLooseType(ITypeBinding parmType) {
        if (3 == parmType.getKind()) {
            PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)parmType;
            Primitive primitive = primTypeBinding.getPrimitive();
            if (primitive == Primitive.CHAR || primitive == Primitive.DBCHAR || primitive == Primitive.MBCHAR || primitive == Primitive.STRING || primitive == Primitive.HEX || primitive == Primitive.UNICODE || primitive == Primitive.NUM) {
                return primTypeBinding.getLength() == 0;
            }
            if (primitive == Primitive.INTERVAL) {
                return true;
            }
        }
        return SystemFunctionParameterSpecialTypeBinding.VAGTEXT == parmType;
    }

    private boolean isTypeCompatibleWithNullLiteral(ITypeBinding parmType) {
        if (3 == parmType.getKind()) {
            PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)parmType;
            Primitive primitive = primTypeBinding.getPrimitive();
            if (primitive == Primitive.NUMBER) {
                return false;
            }
            if (primitive == Primitive.CHAR || primitive == Primitive.DBCHAR || primitive == Primitive.MBCHAR || primitive == Primitive.HEX || primitive == Primitive.UNICODE || primitive == Primitive.DECIMAL || primitive == Primitive.NUM) {
                return primTypeBinding.getLength() != 0;
            }
        }
        return true;
    }

    private boolean checkArgForSpecialTypeParameter(Expression argExpr, ITypeBinding argType, ITypeBinding parmType, int argNum) {
        return ((ISpecialSystemFunctionParameterChecker)specialSystemFunctionParameterCheckers.get(parmType)).checkArgument(argExpr, argType, this.fInvocationNode, this.functionBinding, this.problemRequestor, argNum);
    }

    private boolean checkArgForInOrOutParameter(Expression argExpr, ITypeBinding argType, FunctionParameterBinding funcParmBinding, ITypeBinding parmType, int argNum) {
        if (FunctionArgumentValidator.isIORecord(parmType) && FunctionArgumentValidator.isRecord(argType)) {
            return this.checkArgForIORecordParameter(argExpr, argType, funcParmBinding, parmType);
        }
        if (this.qualifiedByActiveForm(argExpr)) {
            return true;
        }
        if (2 == parmType.getKind()) {
            return this.checkArgForInOrOutArrayParameter(argExpr, argType, funcParmBinding, parmType);
        }
        if (!(TypeCompatibilityUtil.isMoveCompatible(parmType, argType, argExpr, this.compilerOptions) || argType.isDynamic() || TypeCompatibilityUtil.areCompatibleExceptions(argType, parmType, this.compilerOptions))) {
            if (argType == SystemFunctionParameterSpecialTypeBinding.ANYEGLORASJAVA) {
                this.problemRequestor.acceptProblem((Node)argExpr, 4294, new String[]{Integer.toString(argNum), this.functionBinding.getCaseSensitiveName()});
            } else {
                this.problemRequestor.acceptProblem((Node)argExpr, 6731, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(argType), StatementValidator.getShortTypeString(parmType)});
            }
            return false;
        }
        return true;
    }

    private boolean checkArgForInParameter(Expression argExpr, ITypeBinding argType, FunctionParameterBinding funcParmBinding, ITypeBinding parmType, int argNum) {
        IDataBinding argDBinding = argExpr.resolveDataBinding();
        if (argDBinding != null) {
            if (!new RValueValidator(this.problemRequestor, this.compilerOptions, argDBinding, argExpr).validate()) {
                return false;
            }
            this.validateNotPCB(argDBinding, argExpr);
        }
        return this.checkArgForInOrOutParameter(argExpr, argType, funcParmBinding, parmType, argNum);
    }

    private void validateNotPCB(IDataBinding argDBinding, Expression argExpr) {
        IAnnotationBinding aBinding = argDBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "PCB");
        if (aBinding != null) {
            this.problemRequestor.acceptProblem((Node)argExpr, 7955, new String[]{argDBinding.getCaseSensitiveName()});
        }
    }

    private boolean checkArgForOutParameter(Expression argExpr, ITypeBinding argType, final FunctionParameterBinding funcParmBinding, ITypeBinding parmType, int argNum) {
        IDataBinding argDBinding = argExpr.resolveDataBinding();
        if (argDBinding != null && !new LValueValidator(this.problemRequestor, this.compilerOptions, argDBinding, argExpr, new LValueValidator.DefaultLValueValidationRules(){

            @Override
            public boolean canAssignToFunctionParmConst() {
                return funcParmBinding.isConst();
            }

            @Override
            public boolean canAssignToConstantVariables() {
                return funcParmBinding.isConst();
            }
        }).validate()) {
            return false;
        }
        this.validateNotThis(argExpr);
        if (!this.isRefCompatForOutParm(argType, parmType)) {
            this.problemRequestor.acceptProblem((Node)argExpr, 6716, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(argType, true), StatementValidator.getShortTypeString(parmType, true)});
            return false;
        }
        return this.checkArgForInOrOutParameter(argExpr, argType, funcParmBinding, parmType, argNum);
    }

    private boolean isRefCompatForOutParm(ITypeBinding argType, ITypeBinding parmType) {
        if (Binding.isValidBinding(argType) && Binding.isValidBinding(parmType)) {
            return TypeCompatibilityUtil.isReference(argType) == TypeCompatibilityUtil.isReference(parmType);
        }
        return true;
    }

    private static boolean isIORecord(ITypeBinding tBinding) {
        if (6 == tBinding.getKind() || 7 == tBinding.getKind()) {
            return tBinding.getAnnotation(new String[]{"egl", "io", "file"}, "SerialRecord") != null || tBinding.getAnnotation(new String[]{"egl", "io", "file"}, "IndexedRecord") != null || tBinding.getAnnotation(new String[]{"egl", "io", "file"}, "RelativeRecord") != null || tBinding.getAnnotation(new String[]{"egl", "io", "mq"}, "MQRecord") != null || tBinding.getAnnotation(new String[]{"egl", "io", "file"}, "CSVRecord") != null || tBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") != null;
        }
        return false;
    }

    private static boolean isRecord(ITypeBinding tBinding) {
        return 6 == tBinding.getKind() || 7 == tBinding.getKind();
    }

    private static boolean isFlexRecord(ITypeBinding tBinding) {
        return 7 == tBinding.getKind();
    }

    private static boolean isDictionary(ITypeBinding tBinding) {
        return 21 == tBinding.getKind();
    }

    private boolean checkArgForIORecordParameter(Expression argExpr, ITypeBinding argType, FunctionParameterBinding funcParmBinding, ITypeBinding parmType) {
        if (argType != parmType) {
            this.problemRequestor.acceptProblem((Node)argExpr, 6745, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(parmType)});
        }
        return true;
    }

    private boolean checkArgForInOrOutArrayParameter(Expression argExpr, ITypeBinding argType, FunctionParameterBinding funcParmBinding, ITypeBinding parmType) {
        if (argType.isDynamic() || !TypeCompatibilityUtil.isMoveCompatible(parmType, argType, argExpr, this.compilerOptions) && !TypeCompatibilityUtil.areCompatibleExceptions(argType, parmType, this.compilerOptions)) {
            this.problemRequestor.acceptProblem((Node)argExpr, 6731, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(argType), StatementValidator.getShortTypeString(parmType)});
            return false;
        }
        return true;
    }

    private boolean checkArgForInOutParameter(Expression argExpr, ITypeBinding argType, final FunctionParameterBinding funcParmBinding, ITypeBinding parmType, int argNum) {
        boolean argCompatible;
        IDataBinding argDBinding = argExpr.resolveDataBinding();
        if (argDBinding != null) {
            if (!new RValueValidator(this.problemRequestor, this.compilerOptions, argDBinding, argExpr).validate()) {
                return false;
            }
            if (!new LValueValidator(this.problemRequestor, this.compilerOptions, argDBinding, argExpr, new LValueValidator.DefaultLValueValidationRules(){

                @Override
                public boolean canAssignToFunctionReferences() {
                    return true;
                }

                @Override
                public boolean canAssignToPCB() {
                    return true;
                }

                @Override
                public boolean canAssignToConstantVariables() {
                    return true;
                }

                @Override
                public boolean canAssignToFunctionParmConst() {
                    return funcParmBinding.isConst();
                }
            }).validate()) {
                return false;
            }
        }
        if (FunctionArgumentValidator.isIORecord(parmType) && FunctionArgumentValidator.isRecord(argType)) {
            return this.checkArgForIORecordParameter(argExpr, argType, funcParmBinding, parmType);
        }
        if (this.qualifiedByActiveForm(argExpr)) {
            return true;
        }
        boolean bl = argCompatible = TypeCompatibilityUtil.isReferenceCompatible(argType, parmType, this.compilerOptions) || TypeCompatibilityUtil.areCompatibleExceptions(parmType, argType, this.compilerOptions);
        if (!argCompatible) {
            if (argType == SystemFunctionParameterSpecialTypeBinding.ANYEGLORASJAVA) {
                this.problemRequestor.acceptProblem((Node)argExpr, 4294, new String[]{Integer.toString(argNum), this.functionBinding.getCaseSensitiveName()});
            } else {
                this.problemRequestor.acceptProblem((Node)argExpr, 6716, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(argType, true), StatementValidator.getShortTypeString(parmType, true)});
            }
            return false;
        }
        this.validateNotThis(argExpr);
        return true;
    }

    private void validateNotThis(Expression expr) {
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(ThisExpression thisExpression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)thisExpression, 6754, new String[0]);
                return false;
            }
        };
        expr.accept(visitor);
    }

    private boolean isLiteral(Expression expr) {
        final boolean[] result = new boolean[1];
        expr.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(IntegerLiteral integerLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(DecimalLiteral decimalLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(FloatLiteral floatLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(BooleanLiteral booleanLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(StringLiteral stringLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(CharLiteral stringLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(DBCharLiteral stringLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(MBCharLiteral stringLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(HexLiteral stringLiteral) {
                result[0] = true;
                return false;
            }

            @Override
            public boolean visit(BinaryExpression binaryExpression) {
                result[0] = new AnnotationTypeBinding.IsStringLiteralChecker().isStringLiteral(binaryExpression);
                return false;
            }

            @Override
            public boolean visit(UnaryExpression unaryExpression) {
                return UnaryExpression.Operator.PLUS == unaryExpression.getOperator() || UnaryExpression.Operator.MINUS == unaryExpression.getOperator();
            }
        });
        return result[0];
    }

    private boolean qualifiedByActiveForm(Expression expr) {
        final boolean[] result = new boolean[1];
        expr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitName(Name name) {
                if (AbstractBinder.dataBindingIs(name.resolveDataBinding(), new String[]{"egl", "ui", "console"}, "ConsoleLib", "ACTIVEFORM")) {
                    result[0] = true;
                }
                return true;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                return true;
            }
        });
        return result[0];
    }

    private boolean checkNoDynamicTypesPassedToMathLibFunctions(Expression argExpr, ITypeBinding argType, FunctionParameterBinding funcParmBinding, ITypeBinding parmType) {
        if (argType.isDynamic() && AbstractBinder.typeIs(this.functionBinding.getDeclarer(), new String[]{"egl", "core"}, "MathLib") && !this.qualifiedByActiveForm(argExpr)) {
            if (funcParmBinding.isInput() || funcParmBinding.isOutput()) {
                this.problemRequestor.acceptProblem((Node)argExpr, 6731, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(argType), StatementValidator.getShortTypeString(parmType)});
            } else {
                this.problemRequestor.acceptProblem((Node)argExpr, 6716, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, StatementValidator.getShortTypeString(argType), StatementValidator.getShortTypeString(parmType)});
            }
            return false;
        }
        return true;
    }

    private boolean checkCorrectNumberOfArgumentsForSystemFunction() {
        int[] validNumbersOfArguments = this.functionBinding.getValidNumbersOfArguments();
        if (validNumbersOfArguments.length == 1) {
            if (this.numArgs != validNumbersOfArguments[0]) {
                this.problemRequestor.acceptProblem((Node)this.fInvocationNode.getTarget(), 5109, new String[]{this.canonicalFunctionName, Integer.toString(validNumbersOfArguments[0])});
                return false;
            }
        } else if (validNumbersOfArguments.length == 2 && validNumbersOfArguments[0] < 0) {
            int atLeastNumberOfArgs;
            if (validNumbersOfArguments[0] == -1 && this.numArgs < (atLeastNumberOfArgs = validNumbersOfArguments[1])) {
                this.problemRequestor.acceptProblem((Node)this.fInvocationNode.getTarget(), 5105, new String[]{this.canonicalFunctionName, Integer.toString(atLeastNumberOfArgs)});
                return false;
            }
        } else {
            StringBuffer argCountBuffer = new StringBuffer();
            boolean numargsOK = false;
            int loopcntr = 0;
            loopcntr = 0;
            while (loopcntr < validNumbersOfArguments.length) {
                if (this.numArgs == validNumbersOfArguments[loopcntr]) {
                    numargsOK = true;
                    break;
                }
                if (loopcntr != validNumbersOfArguments.length - 1) {
                    if (argCountBuffer.length() > 0) {
                        argCountBuffer.append(", ");
                    }
                    argCountBuffer.append(Integer.toString(validNumbersOfArguments[loopcntr]));
                }
                ++loopcntr;
            }
            if (!numargsOK) {
                this.problemRequestor.acceptProblem((Node)this.fInvocationNode.getTarget(), 5098, new String[]{this.canonicalFunctionName, argCountBuffer.toString(), Integer.toString(validNumbersOfArguments[loopcntr - 1])});
                return false;
            }
        }
        return true;
    }

    private String getCanonicalStringNoSubscripts(Expression expr) {
        final String[] result = new String[1];
        expr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                result[0] = expression.getCanonicalString();
                return false;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(ArrayAccess arrayAccess) {
                arrayAccess.getArray().accept(this);
                return false;
            }

            @Override
            public boolean visit(SubstringAccess substringAccess) {
                substringAccess.getPrimary().accept(this);
                return false;
            }
        });
        return result[0];
    }

    private static boolean isValidForConvertBidiTarget(Expression argExpr, final ITypeBinding argType) {
        final boolean[] argIsValid = new boolean[1];
        argExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisitName(Name name) {
                this.checkArg();
            }

            @Override
            public void endVisit(FieldAccess fieldAccess) {
                this.checkArg();
            }

            @Override
            public void endVisit(ArrayAccess arrayAccess) {
                this.checkArg();
            }

            private void checkArg() {
                argIsValid[0] = 3 == argType.getKind() && (((PrimitiveTypeBinding)argType).getPrimitive() == Primitive.CHAR || ((PrimitiveTypeBinding)argType).getPrimitive() == Primitive.UNICODE || ((PrimitiveTypeBinding)argType).getPrimitive() == Primitive.STRING);
            }
        });
        return argIsValid[0];
    }

    private static boolean isValidForConvertBidiConvTable(Expression argExpr) {
        final boolean[] argIsValid = new boolean[1];
        argExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisit(StringLiteral lit) {
                argIsValid[0] = true;
            }
        });
        return argIsValid[0];
    }

    private static boolean isValidForConvert(final Expression argExpr, final ITypeBinding argType) {
        final boolean[] argIsValid = new boolean[1];
        argExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisitName(Name name) {
                this.checkArg();
            }

            @Override
            public void endVisit(FieldAccess fieldAccess) {
                this.checkArg();
            }

            @Override
            public void endVisit(ArrayAccess arrayAccess) {
                this.checkArg();
            }

            @Override
            public void endVisit(SubstringAccess substringAccess) {
                this.checkArg();
            }

            private void checkArg() {
                if (2 == argType.getKind()) {
                    argIsValid[0] = FunctionArgumentValidator.isValidForConvert(argExpr, ((ArrayTypeBinding)argType).getElementType());
                } else if (argType.isDynamic()) {
                    argIsValid[0] = false;
                } else if (26 == argType.getKind()) {
                    argIsValid[0] = true;
                } else if (3 == argType.getKind()) {
                    Primitive prim = ((PrimitiveTypeBinding)argType).getPrimitive();
                    argIsValid[0] = prim != Primitive.BLOB && prim != Primitive.CLOB;
                } else if (6 == argType.getKind() || 7 == argType.getKind()) {
                    argIsValid[0] = true;
                }
            }
        });
        return argIsValid[0];
    }

    private static boolean isValidForSizeInBytes(final Expression argExpr, final ITypeBinding argType) {
        final boolean[] argIsValid = new boolean[1];
        argExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisitName(Name name) {
                this.checkArg();
            }

            @Override
            public void endVisit(FieldAccess fieldAccess) {
                this.checkArg();
            }

            @Override
            public void endVisit(ArrayAccess arrayAccess) {
                this.checkArg();
            }

            @Override
            public void endVisit(SubstringAccess substringAccess) {
                this.checkArg();
            }

            private void checkArg() {
                if (2 == argType.getKind()) {
                    argIsValid[0] = FunctionArgumentValidator.isValidForSizeInBytes(argExpr, ((ArrayTypeBinding)argType).getElementType());
                } else if (argType.isDynamic()) {
                    argIsValid[0] = false;
                } else if (26 == argType.getKind()) {
                    argIsValid[0] = true;
                } else if (3 == argType.getKind()) {
                    Primitive prim = ((PrimitiveTypeBinding)argType).getPrimitive();
                    argIsValid[0] = prim != Primitive.STRING && prim != Primitive.BLOB && prim != Primitive.CLOB;
                } else if (6 == argType.getKind() || 8 == argType.getKind()) {
                    argIsValid[0] = true;
                }
            }
        });
        return argIsValid[0];
    }

    private static Expression getQualifier(Expression target) {
        final Expression[] result = new Expression[1];
        target.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                result[0] = qualifiedName.getQualifier();
                return false;
            }

            @Override
            public boolean visit(FieldAccess fieldAccess) {
                result[0] = fieldAccess.getPrimary();
                return false;
            }
        });
        return result[0];
    }

    private static class AnyEGLArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new AnyEGLArgumentChecker();

        private AnyEGLArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (argType.isDynamic()) {
                argIsValid = true;
            } else if (3 == argType.getKind()) {
                Primitive prim = ((PrimitiveTypeBinding)argType).getPrimitive();
                boolean bl = argIsValid = prim != Primitive.BLOB && prim != Primitive.CLOB;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6732, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class AnyEGLOrAsJavaArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new AnyEGLOrAsJavaArgumentChecker();

        private AnyEGLOrAsJavaArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (argType.isDynamic()) {
                argIsValid = true;
            } else if (3 == argType.getKind()) {
                Primitive prim = ((PrimitiveTypeBinding)argType).getPrimitive();
                argIsValid = prim != Primitive.BLOB && prim != Primitive.CLOB;
            } else if (29 == argType.getKind()) {
                argIsValid = 2 == ((ForeignLanguageTypeBinding)argType).getForeignLanguageKind() || ForeignLanguageTypeBinding.NULL == argType || ForeignLanguageTypeBinding.OBJIDJAVA == argType;
            } else {
                boolean bl = argIsValid = 6 == argType.getKind();
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6732, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class AppendAllArgumentChecker
    extends CompleteCheckArgChecker {
        private AppendAllArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            boolean isValid = false;
            if (2 == argType.getKind()) {
                ArrayTypeBinding anyAry = ArrayTypeBinding.getInstance(PrimitiveTypeBinding.getInstance(Primitive.ANY));
                ITypeBinding qualifierType = FunctionArgumentValidator.getQualifier(fInvocationNode.getTarget()).resolveTypeBinding();
                isValid = qualifierType == anyAry || argType == anyAry ? true : TypeCompatibilityUtil.isMoveCompatible(qualifierType, argType, argExpr, compilerOptions);
            }
            if (!isValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6719, new String[]{FunctionArgumentValidator.getQualifier(fInvocationNode.getTarget()).getCanonicalString()});
            }
        }
    }

    private static class ArgInfo {
        private int argNum;
        private FunctionIdentifier fBinding;

        ArgInfo(FunctionIdentifier fBinding, int argNum) {
            this.fBinding = fBinding;
            this.argNum = argNum;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArgInfo) {
                ArgInfo otherArgInfo = (ArgInfo)obj;
                return this.fBinding.equals(otherArgInfo.fBinding) && this.argNum == otherArgInfo.argNum;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.fBinding.hashCode();
            result = 37 * result + this.argNum;
            return result;
        }
    }

    private static class ArrayElementArgumentChecker
    extends CompleteCheckArgChecker {
        private ArrayElementArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            ITypeBinding qualifierType = ((ArrayTypeBinding)FunctionArgumentValidator.getQualifier(fInvocationNode.getTarget()).resolveTypeBinding()).getElementType();
            if (!this.isCompatible(qualifierType, argExpr, argType, compilerOptions)) {
                problemRequestor.acceptProblem((Node)argExpr, 6688, new String[]{argExpr.getCanonicalString(), fInvocationNode.getTarget().getCanonicalString()});
            }
        }

        private boolean isCompatible(ITypeBinding arrayQualifierType, Expression argExpr, ITypeBinding argumentType, ICompilerOptions compilerOptions) {
            if (6 == arrayQualifierType.getKind()) {
                return 6 == argumentType.getKind();
            }
            return TypeCompatibilityUtil.isMoveCompatible(arrayQualifierType, argumentType, argExpr, compilerOptions);
        }
    }

    private static class ArrayOrTableArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new ArrayOrTableArgumentChecker();

        private ArrayOrTableArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            return true;
        }
    }

    private static class AttributeArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new AttributeArgumentChecker();

        private AttributeArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (6 == argType.getKind() || 7 == argType.getKind() || 3 == argType.getKind() || 2 == argType.getKind() || argType.isPartBinding() && AbstractBinder.typeIs(((IPartBinding)argType).getSubType(), new String[]{"egl", "idl", "java"}, "JavaObject")) {
                argIsValid = true;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6734, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class BytesArgumentChecker
    extends CompleteCheckArgChecker {
        private BytesArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            switch (argNum) {
                case 1: {
                    if (argType == null || FunctionArgumentValidator.isValidForSizeInBytes(argExpr, argType)) break;
                    problemRequestor.acceptProblem((Node)argExpr, 3450, new String[]{argExpr.getCanonicalString()});
                }
            }
        }
    }

    public static class CallInvocationNode
    implements IInvocationNode {
        CallStatement call;

        public CallInvocationNode(CallStatement call) {
            this.call = call;
        }

        @Override
        public Expression getTarget() {
            return this.call.getInvocationTarget();
        }

        @Override
        public List getArguments() {
            return this.call.getArguments();
        }
    }

    private static abstract class CompleteCheckArgChecker
    implements IArgumentChecker {
        private CompleteCheckArgChecker() {
        }

        @Override
        public boolean performsCompleteCheck() {
            return true;
        }
    }

    private static class ConsoleFormArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new ConsoleFormArgumentChecker();

        private ConsoleFormArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            return true;
        }
    }

    private static class ConvertArgumentChecker
    extends IncompleteCheckArgChecker {
        private ConvertArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            switch (argNum) {
                case 1: {
                    if (argType == null || FunctionArgumentValidator.isValidForConvert(argExpr, argType)) break;
                    problemRequestor.acceptProblem((Node)argExpr, 6736, new String[]{argExpr.getCanonicalString()});
                }
            }
        }
    }

    private static class ConvertBidiArgumentChecker
    extends IncompleteCheckArgChecker {
        private ConvertBidiArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            switch (argNum) {
                case 1: {
                    if (argType != null && !FunctionArgumentValidator.isValidForConvertBidiTarget(argExpr, argType)) {
                        problemRequestor.acceptProblem((Node)argExpr, 6752, new String[]{argExpr.getCanonicalString()});
                    }
                    return;
                }
                case 3: {
                    if (!FunctionArgumentValidator.isValidForConvertBidiConvTable(argExpr)) {
                        problemRequestor.acceptProblem((Node)argExpr, 6753, new String[]{argExpr.getCanonicalString()});
                    }
                    return;
                }
            }
        }
    }

    private static class EGLTDLIArgumentChecker
    extends CompleteCheckArgChecker {
        private EGLTDLIArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            if (functionContainerBinding != null && functionContainerBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLI") != null) {
                IDataBinding argDBinding = argExpr.resolveDataBinding();
                boolean argIsValid = false;
                if (argDBinding != null) {
                    if (argDBinding == IBinding.NOT_FOUND_BINDING) {
                        argIsValid = true;
                    } else if (EGLTDLIArgumentChecker.getPCBs(functionContainerBinding).contains(argDBinding)) {
                        argIsValid = true;
                    } else if (EGLTDLIArgumentChecker.getProgramParameterBindings(functionContainerBinding).contains(argDBinding)) {
                        argIsValid = true;
                    }
                }
                if (!argIsValid) {
                    problemRequestor.acceptProblem((Node)argExpr, 7934, new String[]{argExpr.getCanonicalString()});
                }
            }
        }

        private static List getPCBs(ITypeBinding type) {
            ITypeBinding psbTBinding;
            IDataBinding psbRec;
            IAnnotationBinding psbABinding;
            ArrayList result = new ArrayList();
            IAnnotationBinding dliABinding = type.getAnnotation(new String[]{"egl", "io", "dli"}, "DLI");
            if (dliABinding != null && (psbABinding = (IAnnotationBinding)dliABinding.findData(InternUtil.intern((String)"psb"))) != IBinding.NOT_FOUND_BINDING && (psbRec = (IDataBinding)psbABinding.getValue()) != IBinding.NOT_FOUND_BINDING && 7 == (psbTBinding = psbRec.getType()).getKind()) {
                result.addAll(((FlexibleRecordBinding)psbTBinding).getDeclaredFields());
            }
            return result;
        }

        private static List getProgramParameterBindings(ITypeBinding type) {
            ArrayList result = new ArrayList();
            if (13 == type.getKind()) {
                result.addAll(((ProgramBinding)type).getParameters());
            }
            return result;
        }
    }

    private static class FlexibleRecordArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new FlexibleRecordArgumentChecker();

        private FlexibleRecordArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (FunctionArgumentValidator.isFlexRecord(argType)) {
                argIsValid = true;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6738, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    public static class FunctionIdentifier {
        String[] enclosingPartPackageName;
        String enclosingPartName;
        String functionName;

        FunctionIdentifier(String[] enclosingPartPackageName, String enclosingPartName, String functionName) {
            if (enclosingPartPackageName != null) {
                this.enclosingPartPackageName = InternUtil.intern((String[])enclosingPartPackageName);
            }
            if (enclosingPartName != null) {
                this.enclosingPartName = InternUtil.intern((String)enclosingPartName);
            }
            this.functionName = InternUtil.intern((String)functionName);
        }

        public FunctionIdentifier(IFunctionBinding functionBinding) {
            IPartBinding declarer = functionBinding.getDeclarer();
            if (declarer != null) {
                this.enclosingPartPackageName = declarer.getPackageName();
                this.enclosingPartName = declarer.getName();
            }
            this.functionName = functionBinding.getName();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FunctionIdentifier)) {
                return false;
            }
            FunctionIdentifier funcId = (FunctionIdentifier)obj;
            return this.enclosingPartPackageName == funcId.enclosingPartPackageName && this.enclosingPartName == funcId.enclosingPartName && this.functionName == funcId.functionName;
        }

        public int hashCode() {
            int result = 17;
            if (this.enclosingPartPackageName != null) {
                result = 37 * result + this.enclosingPartPackageName.hashCode();
            }
            if (this.enclosingPartName != null) {
                result = 37 * result + this.enclosingPartName.hashCode();
            }
            if (this.functionName != null) {
                result = 37 * result + this.functionName.hashCode();
            }
            return result;
        }
    }

    public static class FunctionInvocationNode
    implements IInvocationNode {
        FunctionInvocation fInvoc;

        public FunctionInvocationNode(FunctionInvocation invoc) {
            this.fInvoc = invoc;
        }

        @Override
        public Expression getTarget() {
            return this.fInvoc.getTarget();
        }

        @Override
        public List getArguments() {
            return this.fInvoc.getArguments();
        }
    }

    private static interface IArgumentChecker {
        public boolean performsCompleteCheck();

        public void checkArg(int var1, Expression var2, ITypeBinding var3, IInvocationNode var4, IPartBinding var5, IProblemRequestor var6, ICompilerOptions var7, IFunctionBinding var8);
    }

    public static interface IInvocationNode {
        public Expression getTarget();

        public List getArguments();
    }

    private static interface ISpecialSystemFunctionParameterChecker {
        public boolean checkArgument(Expression var1, ITypeBinding var2, IInvocationNode var3, IFunctionBinding var4, IProblemRequestor var5, int var6);
    }

    private static abstract class IncompleteCheckArgChecker
    implements IArgumentChecker {
        private IncompleteCheckArgChecker() {
        }

        @Override
        public boolean performsCompleteCheck() {
            return false;
        }
    }

    private static class MaximumSizeArgumentChecker
    extends CompleteCheckArgChecker {
        private MaximumSizeArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            if (2 != argType.getKind()) {
                problemRequestor.acceptProblem((Node)argExpr, 6689, new String[]{argExpr.getCanonicalString()});
            }
        }
    }

    private static abstract class NonLiteralAndNonNameExpressionVisitor
    extends AbstractASTExpressionVisitor {
        private NonLiteralAndNonNameExpressionVisitor() {
        }

        @Override
        public void endVisit(ParenthesizedExpression parenthesizedExpression) {
            parenthesizedExpression.getExpression().accept(this);
        }

        @Override
        public void endVisitName(Name name) {
        }

        @Override
        public void endVisit(ArrayAccess arrayAccess) {
        }

        @Override
        public void endVisit(SubstringAccess substringAccess) {
        }

        @Override
        public void endVisit(FieldAccess fieldAccess) {
        }

        @Override
        public void endVisitExpression(Expression expression) {
            this.handleExpressionThatIsNotNameOrLiteral(expression);
        }

        abstract void handleExpressionThatIsNotNameOrLiteral(Expression var1);
    }

    private static class NullNotAllowedArgumentChecker
    extends IncompleteCheckArgChecker {
        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            if (argExpr instanceof NullLiteral) {
                problemRequestor.acceptProblem((Node)argExpr, 6704, new String[]{Integer.toString(argNum), functionBinding.getCaseSensitiveName()});
            }
        }
    }

    private static class ObjIdTypeArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new ObjIdTypeArgumentChecker();

        private ObjIdTypeArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            if (argType != ForeignLanguageTypeBinding.OBJIDJAVA) {
                problemRequestor.acceptProblem((Node)argExpr, 4296, new String[]{Integer.toString(argNum), functionBinding.getCaseSensitiveName()});
            }
            return true;
        }
    }

    private static class ObjIdTypeOptArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new ObjIdTypeOptArgumentChecker();

        private ObjIdTypeOptArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            if (argType != ForeignLanguageTypeBinding.OBJIDJAVA && 3 != argType.getKind()) {
                problemRequestor.acceptProblem((Node)argExpr, 4295, new String[]{Integer.toString(argNum), functionBinding.getCaseSensitiveName()});
            }
            return true;
        }
    }

    private static class PurgeArgumentChecker
    extends IncompleteCheckArgChecker {
        private PurgeArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            final StringBuffer argStr = new StringBuffer();
            argExpr.accept(new AbstractASTExpressionVisitor(){

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(BinaryExpression binaryExpression) {
                    return binaryExpression.getOperator() == BinaryExpression.Operator.PLUS;
                }

                @Override
                public boolean visit(StringLiteral stringLiteral) {
                    argStr.append(stringLiteral.getValue());
                    return false;
                }

                @Override
                public boolean visit(IntegerLiteral integerLiteral) {
                    argStr.append("xxxxxxxxx");
                    return false;
                }
            });
            if (argStr.length() > 8) {
                problemRequestor.acceptProblem(argExpr, 5131);
            }
        }
    }

    private static class RecordArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new RecordArgumentChecker();

        private RecordArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (FunctionArgumentValidator.isRecord(argType)) {
                argIsValid = true;
            } else if (new AnnotationTypeBinding.IsStringLiteralChecker().isStringLiteral(argExpr)) {
                argIsValid = true;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6738, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class RecordOrDictionaryArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new RecordOrDictionaryArgumentChecker();

        private RecordOrDictionaryArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (FunctionArgumentValidator.isRecord(argType)) {
                argIsValid = true;
            } else if (FunctionArgumentValidator.isDictionary(argType)) {
                argIsValid = true;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6729, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class ServiceOrInterfaceArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new ServiceOrInterfaceArgumentChecker();

        private ServiceOrInterfaceArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            boolean argIsValid = false;
            if (14 == argType.getKind()) {
                argIsValid = true;
            } else if (15 == argType.getKind()) {
                boolean bl = argIsValid = SystemPartManager.findType(argType.getName()) != argType;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6739, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class SetErrorArgumentChecker
    extends CompleteCheckArgChecker {
        private SetErrorArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression arg, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
        }
    }

    private static class SizeArgumentChecker
    extends CompleteCheckArgChecker {
        private SizeArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            switch (argNum) {
                case 1: {
                    if (argType == null) break;
                    boolean argIsValid = false;
                    if (2 == argType.getKind() || 5 == argType.getKind()) {
                        argIsValid = true;
                    } else {
                        IDataBinding argDBinding = argExpr.resolveDataBinding();
                        if (argDBinding != null) {
                            switch (argDBinding.getKind()) {
                                case 5: {
                                    argIsValid = ((StructureItemBinding)argDBinding).isMultiplyOccuring();
                                    break;
                                }
                                case 7: {
                                    argIsValid = ((FormFieldBinding)argDBinding).isMultiplyOccuring();
                                }
                            }
                        }
                    }
                    if (argIsValid) break;
                    problemRequestor.acceptProblem((Node)argExpr, 3452, new String[]{argExpr.getCanonicalString()});
                }
            }
        }
    }

    private static class StartTransactionArgumentChecker
    extends CompleteCheckArgChecker {
        private StartTransactionArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            if (6 != argType.getKind()) {
                problemRequestor.acceptProblem(argExpr, 5136);
            }
        }
    }

    private static class StringNotAllowedArgumentChecker
    extends IncompleteCheckArgChecker {
        private boolean stringLiteralIsAllowed;

        public StringNotAllowedArgumentChecker(boolean stringLiteralIsAllowed) {
            this.stringLiteralIsAllowed = stringLiteralIsAllowed;
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            if (3 == argType.getKind() && Primitive.STRING == ((PrimitiveTypeBinding)argType).getPrimitive()) {
                AnnotationTypeBinding.IsStringLiteralChecker checker;
                if (this.stringLiteralIsAllowed && (checker = new AnnotationTypeBinding.IsStringLiteralChecker()).isStringLiteral(argExpr)) {
                    return;
                }
                FunctionParameterBinding funcParmBinding = (FunctionParameterBinding)functionBinding.getParameters().get(argNum - 1);
                ITypeBinding parmType = funcParmBinding.getType();
                String canonicalFunctionName = functionBinding.getCaseSensitiveName();
                if (funcParmBinding.isInput() || funcParmBinding.isOutput()) {
                    problemRequestor.acceptProblem((Node)argExpr, 6731, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), canonicalFunctionName, StatementValidator.getShortTypeString(argType), StatementValidator.getShortTypeString(parmType)});
                } else if (funcParmBinding.isInputOutput()) {
                    problemRequestor.acceptProblem((Node)argExpr, 6716, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), canonicalFunctionName, StatementValidator.getShortTypeString(argType, true), StatementValidator.getShortTypeString(parmType, true)});
                }
            }
        }
    }

    private static class TextFieldArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new TextFieldArgumentChecker();

        private TextFieldArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            IDataBinding argDBinding = argExpr.resolveDataBinding();
            boolean argIsValid = false;
            if (argDBinding != null) {
                if (argDBinding == IBinding.NOT_FOUND_BINDING) {
                    argIsValid = true;
                } else if (7 == argDBinding.getKind()) {
                    argIsValid = ((FormFieldBinding)argDBinding).isTextFormField();
                } else if (argDBinding.getKind() == 0) {
                    argIsValid = ((FunctionParameterBinding)argDBinding).isField();
                }
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6740, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class UnicodeConversionFunctionArgumentChecker
    extends IncompleteCheckArgChecker {
        private boolean isSignedUnicode;

        public UnicodeConversionFunctionArgumentChecker(boolean isSignedUnicode) {
            this.isSignedUnicode = isSignedUnicode;
        }

        @Override
        public void checkArg(int argNum, Expression arg, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            Expression otherArgExpr;
            ITypeBinding otherArgType;
            PrimitiveTypeBinding primTBinding;
            if (fInvocationNode.getArguments().size() == 2 && 3 == argType.getKind() && Primitive.UNICODE == (primTBinding = (PrimitiveTypeBinding)argType).getPrimitive() && (otherArgType = (otherArgExpr = (Expression)fInvocationNode.getArguments().get(argNum == 1 ? 1 : 0)).resolveTypeBinding()) != null && 3 == otherArgType.getKind()) {
                PrimitiveTypeBinding otherPrimTBinding = (PrimitiveTypeBinding)otherArgType;
                Primitive otherPrim = otherPrimTBinding.getPrimitive();
                int requiredUnicodeLength = -1;
                int length = otherPrimTBinding.getLength();
                switch (otherPrim.getType()) {
                    case 18: {
                        requiredUnicodeLength = 6;
                        break;
                    }
                    case 10: {
                        requiredUnicodeLength = 11;
                        break;
                    }
                    case 1: {
                        requiredUnicodeLength = 20;
                        break;
                    }
                    case 2: {
                        switch (length) {
                            case 4: {
                                requiredUnicodeLength = 6;
                                break;
                            }
                            case 9: {
                                requiredUnicodeLength = 11;
                                break;
                            }
                            case 18: {
                                requiredUnicodeLength = 20;
                            }
                        }
                        break;
                    }
                    case 7: 
                    case 13: {
                        int evenLength = length;
                        if (evenLength % 2 == 1) {
                            --evenLength;
                        }
                        requiredUnicodeLength = evenLength + 2;
                        if (length != 32) break;
                        --requiredUnicodeLength;
                    }
                }
                if (requiredUnicodeLength != -1) {
                    if (!this.isSignedUnicode) {
                        --requiredUnicodeLength;
                    }
                    if (primTBinding.getLength() != requiredUnicodeLength) {
                        problemRequestor.acceptProblem((Node)arg, 7655, new String[]{otherArgExpr.getCanonicalString(), otherPrimTBinding.getName(), arg.getCanonicalString(), Integer.toString(requiredUnicodeLength), Integer.toString(primTBinding.getLength())});
                    }
                }
            }
        }
    }

    private static class VAGTextArgumentChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new VAGTextArgumentChecker();

        private VAGTextArgumentChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            Primitive prim;
            boolean argIsValid = false;
            if (3 == argType.getKind() && ((prim = ((PrimitiveTypeBinding)argType).getPrimitive()) == Primitive.CHAR || prim == Primitive.MBCHAR || prim == Primitive.DBCHAR || prim == Primitive.DBCHARLIT || prim == Primitive.HEX || prim == Primitive.NUM || prim == Primitive.UNICODE || prim == Primitive.STRING && ((PrimitiveTypeBinding)argType).getLength() != 0)) {
                argIsValid = true;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6741, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class VAGTextOrNumericChecker
    implements ISpecialSystemFunctionParameterChecker {
        static ISpecialSystemFunctionParameterChecker INSTANCE = new VAGTextOrNumericChecker();

        private VAGTextOrNumericChecker() {
        }

        @Override
        public boolean checkArgument(Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationAST, IFunctionBinding functionBinding, IProblemRequestor problemRequestor, int argNum) {
            Primitive prim;
            boolean argIsValid = false;
            if (3 == argType.getKind() && ((prim = ((PrimitiveTypeBinding)argType).getPrimitive()) == Primitive.CHAR || prim == Primitive.MBCHAR || prim == Primitive.DBCHAR || prim == Primitive.DBCHARLIT || prim == Primitive.STRING && ((PrimitiveTypeBinding)argType).getLength() != 0 || prim == Primitive.HEX || prim == Primitive.NUM || prim == Primitive.BIN || prim == Primitive.INT || prim == Primitive.SMALLINT || prim == Primitive.BIGINT || prim == Primitive.PACF || prim == Primitive.MONEY || prim == Primitive.DECIMAL)) {
                argIsValid = true;
            }
            if (!argIsValid) {
                problemRequestor.acceptProblem((Node)argExpr, 6742, new String[]{argExpr.getCanonicalString(), String.valueOf(functionBinding.getDeclarer().getCaseSensitiveName()) + "." + functionBinding.getCaseSensitiveName()});
                return false;
            }
            return true;
        }
    }

    private static class VGTDLIArgumentChecker
    extends IncompleteCheckArgChecker {
        private VGTDLIArgumentChecker() {
        }

        @Override
        public void checkArg(int argNum, Expression argExpr, ITypeBinding argType, IInvocationNode fInvocationNode, IPartBinding functionContainerBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IFunctionBinding functionBinding) {
            if (3 == argType.getKind() && ((PrimitiveTypeBinding)argType).getDecimals() != 0) {
                problemRequestor.acceptProblem((Node)argExpr, 7558, new String[]{Integer.toString(argNum), "VGTDLI"});
            }
        }
    }
}

