/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.CallStatementBinding;
import org.eclipse.edt.compiler.binding.ExitStatementBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionBindingCompletor;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.IsNotStateBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.binding.OpenUIStatementBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.ShowStatementBinding;
import org.eclipse.edt.compiler.binding.TransferStatementBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLIsSystemPartAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IDliIOStatement;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.InlineDLIStatement;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnEventBlock;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.PassingClause;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturningToInvocationTargetClause;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DataBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ILocalVariableScope;
import org.eclipse.edt.compiler.internal.core.lookup.LocalVariableAndIOObjectBinder;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.StatementBlockScope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.core.lookup.TypeBindingScope;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.compiler.internal.dli.DLIInfo;
import org.eclipse.edt.compiler.internal.dli.DLIModel;
import org.eclipse.edt.compiler.internal.dli.DLIParser;
import org.eclipse.edt.compiler.internal.dli.IBooleanExpression;
import org.eclipse.edt.compiler.internal.dli.IBooleanExpressionSSAConditions;
import org.eclipse.edt.compiler.internal.dli.IBooleanOperatorExpression;
import org.eclipse.edt.compiler.internal.dli.ICondition;
import org.eclipse.edt.compiler.internal.dli.IHostVariableValue;
import org.eclipse.edt.compiler.internal.dli.ISSAConditions;
import org.eclipse.edt.compiler.internal.dli.ISegmentSearchArgument;
import org.eclipse.edt.compiler.internal.dli.IStatement;
import org.eclipse.edt.compiler.internal.dli.IValue;
import org.eclipse.edt.compiler.internal.dli.IValueExpressionSSAConditions;
import org.eclipse.edt.compiler.internal.dli.stmtFactory.DLIDefaultStatementFactory;
import org.eclipse.edt.compiler.internal.sql.EGLSQLGenerationTokens;
import org.eclipse.edt.compiler.internal.sql.ItemNameToken;
import org.eclipse.edt.compiler.internal.sql.SQLInfo;
import org.eclipse.edt.compiler.internal.sql.Token;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLAddStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLDeclareStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLDeleteStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLGetByKeyForUpdateStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLGetByKeyStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLOpenForUpdateStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLOpenStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLReplaceStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLStatementFactory;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLParser;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FunctionBinder
extends DefaultBinder {
    private IFunctionBinding functionBinding;
    private IPartBinding partBinding;
    private IBinding statementBinding = null;
    private List functionDataDecls = new ArrayList();
    private String canonicalFunctionName;
    private Set functionIOObjects;
    private final Set PROBLEM_KINDS_IGNORED_FOR_DEFAULT_SQL_HOST_VARIABLES = new HashSet<Integer>(Arrays.asList(new Integer(6585)));

    public FunctionBinder(IPartBinding partBinding, IFunctionBinding functionBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, partBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.partBinding = partBinding;
        this.functionBinding = functionBinding;
    }

    @Override
    public boolean visit(NestedFunction function) {
        this.canonicalFunctionName = function.getName().getCanonicalName();
        FunctionScope functionScope = new FunctionScope((FunctionContainerScope)this.currentScope, this.functionBinding);
        this.currentScope = functionScope;
        Iterator iter = this.functionBinding.getParameters().iterator();
        while (iter.hasNext()) {
            ((ILocalVariableScope)((Object)this.currentScope)).addDeclaredDataName(((IDataBinding)iter.next()).getName());
        }
        LocalVariableAndIOObjectBinder localVariableAndIOObjectBinder = new LocalVariableAndIOObjectBinder(functionScope, this.problemRequestor, this, this.partBinding);
        function.accept(localVariableAndIOObjectBinder);
        this.functionIOObjects = localVariableAndIOObjectBinder.getIOObjects();
        this.addNonLocalVariableIOObjectsToScope();
        return true;
    }

    @Override
    public boolean visit(Constructor constructor) {
        this.canonicalFunctionName = "constructor";
        FunctionScope functionScope = new FunctionScope((FunctionContainerScope)this.currentScope, this.functionBinding);
        this.currentScope = functionScope;
        Iterator iter = this.functionBinding.getParameters().iterator();
        while (iter.hasNext()) {
            ((ILocalVariableScope)((Object)this.currentScope)).addDeclaredDataName(((IDataBinding)iter.next()).getName());
        }
        LocalVariableAndIOObjectBinder localVariableAndIOObjectBinder = new LocalVariableAndIOObjectBinder(functionScope, this.problemRequestor, this, this.partBinding);
        constructor.accept(localVariableAndIOObjectBinder);
        this.functionIOObjects = localVariableAndIOObjectBinder.getIOObjects();
        this.addNonLocalVariableIOObjectsToScope();
        return true;
    }

    @Override
    public boolean visit(TopLevelFunction function) {
        this.canonicalFunctionName = function.getName().getCanonicalName();
        function.accept(new FunctionBindingCompletor(this.partBinding, this.currentScope, (FunctionBinding)this.functionBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        FunctionScope functionScope = new FunctionScope(this.currentScope, this.functionBinding);
        this.currentScope = functionScope;
        Iterator iter = this.functionBinding.getParameters().iterator();
        while (iter.hasNext()) {
            ((ILocalVariableScope)((Object)this.currentScope)).addDeclaredDataName(((IDataBinding)iter.next()).getName());
        }
        LocalVariableAndIOObjectBinder localVariableAndIOObjectBinder = new LocalVariableAndIOObjectBinder(functionScope, this.problemRequestor, this, this.partBinding);
        function.accept(localVariableAndIOObjectBinder);
        this.functionIOObjects = localVariableAndIOObjectBinder.getIOObjects();
        this.addNonLocalVariableIOObjectsToScope();
        IAnnotationBinding annotation = this.functionBinding.getAnnotation(new String[]{"egl", "core"}, "ContainerContextDependent");
        if (annotation == null || annotation.getValue() == Boolean.NO) {
            this.currentScope.stopReturningFunctionContainerFunctions();
        }
        return true;
    }

    private void addNonLocalVariableIOObjectsToScope() {
        for (IDataBinding dBinding : this.functionIOObjects) {
            if (2 == dBinding.getKind()) continue;
            ((ILocalVariableScope)((Object)this.currentScope)).addIOObject(dBinding);
        }
    }

    @Override
    public boolean visit(FunctionParameter functionParameter) {
        this.processResolvableProperties(functionParameter.getName());
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration dataDecl) {
        this.functionDataDecls.add(dataDecl);
        this.processDataDeclaration(dataDecl.getNames(), dataDecl.getSettingsBlockOpt());
        this.processResolvableProperties(dataDecl);
        return true;
    }

    private void processDataDeclaration(List names, SettingsBlock settingsBlock) {
        Iterator i = names.iterator();
        boolean annotationFoundUsingScope = false;
        while (i.hasNext()) {
            Name name = (Name)i.next();
            String dataName = name.getIdentifier();
            IDataBinding dBinding = (IDataBinding)name.resolveBinding();
            if (dBinding == null || dBinding == IBinding.NOT_FOUND_BINDING) continue;
            LocalVariableBinding varBinding = (LocalVariableBinding)name.resolveBinding();
            if (((ILocalVariableScope)((Object)this.currentScope)).hasDeclaredDataName(dataName)) {
                this.problemRequestor.acceptProblem((Node)name, 3012, new String[]{name.getCanonicalName(), this.canonicalFunctionName});
            } else {
                ((ILocalVariableScope)((Object)this.currentScope)).addLocalVariable(varBinding);
                ((ILocalVariableScope)((Object)this.currentScope)).addDeclaredDataName(dataName);
            }
            if (settingsBlock != null) {
                DataBindingScope scope = new DataBindingScope(this.getSystemScope(this.currentScope), varBinding);
                AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(scope, varBinding, varBinding.getType(), varBinding, -1, this.functionBinding.getDeclarer());
                annotationScope.setAnnotationFoundUsingThisScope(annotationFoundUsingScope);
                settingsBlock.accept(new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.functionBinding.getDeclarer(), annotationScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
                annotationFoundUsingScope = annotationScope.isAnnotationFoundUsingThisScope();
            }
            if (!this.functionIOObjects.contains(varBinding)) continue;
            ((ILocalVariableScope)((Object)this.currentScope)).addIOObject(varBinding);
        }
    }

    private Scope getSystemScope(Scope scope) {
        while (!(scope instanceof SystemScope)) {
            scope = scope.getParentScope();
        }
        return scope;
    }

    @Override
    public void endVisit(TopLevelFunction topLevelFunction) {
        this.currentScope.startReturningFunctionContainerFunctions();
    }

    @Override
    public void endVisit(NestedFunction nestedFunction) {
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        setValuesExpression.getExpression().accept(this);
        ITypeBinding typeBinding = setValuesExpression.getExpression().resolveTypeBinding();
        if (typeBinding != null) {
            TypeBindingScope newScope = new TypeBindingScope(NullScope.INSTANCE, typeBinding, setValuesExpression.getExpression().resolveDataBinding());
            setValuesExpression.getSettingsBlock().accept(new DefaultBinder.SetValuesExpressionCompletor(this.currentScope, this.functionBinding.getDeclarer(), newScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        } else if (setValuesExpression.getExpression().resolveDataBinding() != IBinding.NOT_FOUND_BINDING) {
            setValuesExpression.getSettingsBlock().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OpenUIStatement openUIStatement) {
        OpenUIStatementBinding openUIStatementBinding = new OpenUIStatementBinding(InternUtil.internCaseSensitive((String)""));
        this.statementBinding = openUIStatementBinding;
        openUIStatement.setStatementBinding(openUIStatementBinding);
        if (openUIStatement.hasOpenAttributes()) {
            openUIStatement.getOpenAttributes().accept(this);
        }
        Iterator iter = openUIStatement.getOpenableElements().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        iter = openUIStatement.getBindClauseVariables().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        for (OnEventBlock nextBlock : openUIStatement.getEventBlocks()) {
            Iterator iter2;
            nextBlock.getEventTypeExpr().accept(this);
            if (nextBlock.hasStringList()) {
                iter2 = nextBlock.getStringList().iterator();
                while (iter2.hasNext()) {
                    ((Node)iter2.next()).accept(this);
                }
            }
            this.currentScope = new StatementBlockScope(this.currentScope);
            iter2 = nextBlock.getStatements().iterator();
            while (iter2.hasNext()) {
                ((Node)iter2.next()).accept(this);
            }
            this.currentScope = this.currentScope.getParentScope();
        }
        return false;
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        block13: {
            CallStatementBinding callStatementBinding = new CallStatementBinding(InternUtil.internCaseSensitive((String)""));
            this.statementBinding = callStatementBinding;
            callStatement.setStatementBinding(callStatementBinding);
            try {
                try {
                    this.bindingCallTarget = true;
                    this.bindInvocationTarget(callStatement.getInvocationTarget(), true);
                }
                catch (ResolutionException e) {
                    this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                    this.bindingCallTarget = false;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.bindingCallTarget = false;
                throw throwable;
            }
            this.bindingCallTarget = false;
        }
        if (callStatement.hasArguments()) {
            Iterator iter = callStatement.getArguments().iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).accept(this);
            }
        }
        if (callStatement.hasSettingsBlock()) {
            callStatement.getSettingsBlock().accept(this);
        }
        if (callStatement.getUsing() != null) {
            callStatement.getUsing().accept(this);
        }
        if (callStatement.getCallSynchronizationValues() != null) {
            if (callStatement.getCallSynchronizationValues().getReturns() != null) {
                callStatement.getCallSynchronizationValues().getReturns().accept(this);
            }
            if (callStatement.getCallSynchronizationValues().getReturnTo() != null) {
                callStatement.getCallSynchronizationValues().getReturnTo().accept(this);
            }
            if (callStatement.getCallSynchronizationValues().getOnException() != null) {
                callStatement.getCallSynchronizationValues().getOnException().accept(this);
            }
        }
        this.statementBinding = null;
        return false;
    }

    @Override
    public boolean visit(TransferStatement transferStatement) {
        TransferStatementBinding transferStatementBinding = new TransferStatementBinding(InternUtil.internCaseSensitive((String)""));
        this.statementBinding = transferStatementBinding;
        transferStatement.setStatementBinding(transferStatementBinding);
        try {
            this.bindInvocationTarget(transferStatement.getInvocationTarget(), false);
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
        }
        if (transferStatement.hasPassingRecord()) {
            transferStatement.getPassingRecord().accept(this);
        }
        if (transferStatement.hasSettingsBlock()) {
            transferStatement.getSettingsBlock().accept(this);
        }
        this.statementBinding = null;
        return false;
    }

    @Override
    public boolean visit(ShowStatement showStatement) {
        ShowStatementBinding showStatementBinding = new ShowStatementBinding(InternUtil.internCaseSensitive((String)""));
        this.statementBinding = showStatementBinding;
        showStatement.setStatementBinding(showStatementBinding);
        showStatement.getPageRecordOrForm().accept(this);
        final FunctionBinder thisBinder = this;
        Iterator iter = showStatement.getShowOptions().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(PassingClause passingClause) {
                    passingClause.accept(thisBinder);
                    return false;
                }

                @Override
                public boolean visit(ReturningToInvocationTargetClause returningToInvocationTargetClause) {
                    try {
                        FunctionBinder.this.bindInvocationTarget(returningToInvocationTargetClause.getExpression(), false);
                    }
                    catch (ResolutionException e) {
                        FunctionBinder.this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                    }
                    return false;
                }
            });
        }
        if (showStatement.hasSettingsBlock()) {
            showStatement.getSettingsBlock().accept(this);
        }
        this.statementBinding = null;
        return false;
    }

    @Override
    public boolean visit(ExitStatement exitStatement) {
        ExitStatementBinding exitStatementBinding = new ExitStatementBinding(InternUtil.internCaseSensitive((String)""));
        this.statementBinding = exitStatementBinding;
        exitStatement.setStatementBinding(exitStatementBinding);
        if (exitStatement.getExitModifierOpt() != null) {
            exitStatement.getExitModifierOpt().accept(this);
        }
        if (exitStatement.hasSettingsBlock()) {
            exitStatement.getSettingsBlock().accept(this);
        }
        this.statementBinding = null;
        return false;
    }

    @Override
    public void endVisit(OpenUIStatement openUIStatement) {
        this.statementBinding = null;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        if (this.statementBinding == null) {
            return super.visit(settingsBlock);
        }
        AnnotationLeftHandScope lhScope = new AnnotationLeftHandScope(this.currentScope, this.statementBinding, null, this.statementBinding, -1, this.functionBinding.getDeclarer());
        SettingsBlockAnnotationBindingsCompletor completor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.functionBinding.getDeclarer(), lhScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(completor);
        AbstractASTVisitor sveVisitor = new AbstractASTVisitor(){

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                setValuesExpression.setTypeBinding(setValuesExpression.getExpression().resolveTypeBinding());
                return true;
            }
        };
        settingsBlock.accept(sveVisitor);
        return false;
    }

    private void processDLIStatement(final IDliIOStatement statement) {
        final IDataBinding[] pcbBinding = new IDataBinding[1];
        statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(UsingPCBClause usingPCBClause) {
                pcbBinding[0] = usingPCBClause.getPCB().resolveDataBinding();
                return false;
            }

            @Override
            public boolean visit(InlineDLIStatement inlineDLIStatement) {
                try {
                    DLIInfo info = new DLIInfo();
                    info.setInlineValueStart(inlineDLIStatement.getValueOffset());
                    info.setHasDLICall(true);
                    statement.setDliInfo(info);
                    info.setModel(new DLIParser(FunctionBinder.this.compilerOptions).parse(inlineDLIStatement.getValue()));
                    FunctionBinder.this.reportParseErrorsForInlineDLI(info.getModel(), inlineDLIStatement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        ArrayList tBindings = new ArrayList();
        ArrayList dBindings = new ArrayList();
        this.collectDataAndTypeBindings(statement.getTargets(), tBindings, dBindings);
        boolean allDLISegments = this.allDliSegments(dBindings);
        if (allDLISegments || statement.getDliInfo() != null) {
            String callString;
            ITypeBinding[] types = tBindings.toArray(new ITypeBinding[tBindings.size()]);
            IDataBinding[] datas = dBindings.toArray(new IDataBinding[dBindings.size()]);
            DLIInfo info = statement.getDliInfo();
            if (info == null) {
                info = new DLIInfo();
                statement.setDliInfo(info);
                info.setDefaultStatement(true);
            }
            DLIDefaultStatementFactory factory = new DLIDefaultStatementFactory(this.getPSB(), datas, types, pcbBinding[0], this.getPCBParams(), NullProblemRequestor.getInstance());
            info.setStatementFactory(factory);
            if (info.isDefaultStatement() && (callString = factory.getDLICallForStatement(statement)) != null) {
                info.setHasDLICall(true);
                try {
                    info.setModel(new DLIParser(this.compilerOptions).parse(callString));
                    this.reportParseErrorsForDefaultDLI(info.getModel(), (Statement)((Object)statement));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (allDLISegments) {
                info.setTypeBindings(types);
            }
        }
        if (statement.getDliInfo() != null) {
            this.bindDLIHostVariables(statement);
        }
    }

    private void bindDLIHostVariables(IDliIOStatement dliStatement) {
        if (this.hasDLICall(dliStatement)) {
            for (IStatement stmt : dliStatement.getDliInfo().getModel().getStatements()) {
                this.bindDLIHostVariables(stmt, dliStatement);
            }
        }
    }

    private void bindDLIHostVariables(IStatement stmt, IDliIOStatement dliStatement) {
        Iterator i = stmt.getSegmentSearchArguments().iterator();
        while (i.hasNext()) {
            this.bindDLIHostVariables((ISegmentSearchArgument)i.next(), dliStatement);
        }
    }

    private void bindDLIHostVariables(ISegmentSearchArgument ssa, IDliIOStatement dliStatement) {
        ISSAConditions conditions = ssa.getSSAConditions();
        if (conditions == null) {
            return;
        }
        if (conditions.isBooleanExpressionSSAConditions()) {
            this.bindDLIHostVariables(((IBooleanExpressionSSAConditions)conditions).getBooleanExpression(), dliStatement);
        }
        if (conditions.isValueExpressionSSAConditions()) {
            this.bindDLIHostVariables(((IValueExpressionSSAConditions)conditions).getValue(), dliStatement);
        }
    }

    private void bindDLIHostVariables(IBooleanExpression booleanExpr, IDliIOStatement dliStatement) {
        if (booleanExpr == null) {
            return;
        }
        if (booleanExpr.isBooleanOperatorExpression()) {
            this.bindDLIHostVariables(((IBooleanOperatorExpression)booleanExpr).getLeftOperand(), dliStatement);
            this.bindDLIHostVariables(((IBooleanOperatorExpression)booleanExpr).getRightOperand(), dliStatement);
            return;
        }
        if (booleanExpr.isCondition()) {
            ICondition condition = (ICondition)booleanExpr;
            this.bindDLIHostVariables(condition.getValue(), dliStatement);
            return;
        }
    }

    private void bindDLIHostVariables(IValue value, IDliIOStatement dliStatement) {
        IHostVariableValue hostVar;
        if (value == null) {
            return;
        }
        if (value.isHostVariableValue() && (hostVar = (IHostVariableValue)value).getText() != null) {
            Expression expr = new ExpressionParser(this.compilerOptions).parseAsLvalue(hostVar.getText());
            if (expr == null) {
                return;
            }
            hostVar.setExpression(expr);
            IProblemRequestor oldProbReq = this.problemRequestor;
            AccumulatingProblemrRequestor newProbReq = new AccumulatingProblemrRequestor();
            this.problemRequestor = newProbReq;
            expr.accept(this);
            this.problemRequestor = oldProbReq;
            Iterator i = newProbReq.getProblems().iterator();
            boolean putErrorOnStatement = false;
            int startOffset = 0;
            if (dliStatement.getDliInfo().isDefaultStatement()) {
                putErrorOnStatement = true;
            } else {
                startOffset = dliStatement.getDliInfo().getInlineValueStart() + hostVar.getOffset() - expr.getOffset();
            }
            while (i.hasNext()) {
                Problem problem = (Problem)i.next();
                if (putErrorOnStatement) {
                    this.problemRequestor.acceptProblem((Statement)((Object)dliStatement), problem.getProblemKind(), problem.getSeverity(), problem.getInserts());
                    continue;
                }
                int probStart = startOffset + problem.getStartOffset() + 1;
                int probLen = problem.getEndOffset() - problem.getStartOffset();
                this.problemRequestor.acceptProblem(probStart, probStart + probLen, problem.getSeverity(), problem.getProblemKind(), problem.getInserts());
            }
        }
    }

    private boolean hasDLICall(IDliIOStatement dliStatement) {
        if (dliStatement.getDliInfo() == null) {
            return false;
        }
        if (dliStatement.getDliInfo().getModel() == null) {
            return false;
        }
        return dliStatement.getDliInfo().getModel().getStatements() != null;
    }

    private void collectDataAndTypeBindings(List exprList, List typeBindings, List dataBindings) {
        if (exprList == null) {
            return;
        }
        for (Expression expr : exprList) {
            dataBindings.add(expr.resolveDataBinding());
            typeBindings.add(expr.resolveTypeBinding());
        }
    }

    private boolean allDliSegments(List dataBindings) {
        if (dataBindings == null || dataBindings.size() == 0) {
            return false;
        }
        Iterator i = dataBindings.iterator();
        if (i.hasNext()) {
            IDataBinding binding = (IDataBinding)i.next();
            if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
                return false;
            }
            return binding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLISegment") != null;
        }
        return true;
    }

    @Override
    public void endVisit(OpenStatement statement) {
        super.endVisit(statement);
    }

    @Override
    public void endVisit(AddStatement statement) {
        this.processDLIStatement(statement);
        super.endVisit(statement);
    }

    @Override
    public void endVisit(DeleteStatement statement) {
        this.processDLIStatement(statement);
        super.endVisit(statement);
    }

    @Override
    public void endVisit(GetByKeyStatement statement) {
        this.processDLIStatement(statement);
        super.endVisit(statement);
    }

    @Override
    public void endVisit(GetByPositionStatement statement) {
        this.processDLIStatement(statement);
        super.endVisit(statement);
    }

    @Override
    public void endVisit(ReplaceStatement statement) {
        this.processDLIStatement(statement);
        super.endVisit(statement);
    }

    private boolean reportParseErrorsForInlineDLI(DLIModel model, InlineDLIStatement inlineDLIStatement) {
        if (model.getProblems() == null || model.getProblems().size() == 0) {
            if (model.getStatements().size() == 0) {
                this.problemRequestor.acceptProblem(inlineDLIStatement, 7898);
            }
            return false;
        }
        for (Problem problem : model.getProblems()) {
            int start = inlineDLIStatement.getValueOffset() + problem.getStartOffset();
            int end = inlineDLIStatement.getValueOffset() + problem.getEndOffset();
            int id = problem.getProblemKind();
            this.problemRequestor.acceptProblem(start, end, 2, id, problem.getInserts());
        }
        return true;
    }

    private boolean reportParseErrorsForDefaultDLI(DLIModel model, Statement statement) {
        if (model.getProblems() == null || model.getProblems().size() == 0) {
            return false;
        }
        for (Problem problem : model.getProblems()) {
            this.problemRequestor.acceptProblem((Node)statement, 7899, new String[]{problem.toString()});
        }
        return true;
    }

    private boolean reportErrorsForDefaultSQL(EGLSQLStatementFactory factory, Statement statement) {
        if (factory.getErrorMessages() == null || factory.getErrorMessages().size() == 0) {
            return false;
        }
        for (Problem problem : factory.getErrorMessages()) {
            this.problemRequestor.acceptProblem((Node)statement, problem.getProblemKind(), problem.getInserts());
        }
        return true;
    }

    private void processResolvableProperties(FunctionDataDeclaration functionDataDeclaration) {
        for (Name name : functionDataDeclaration.getNames()) {
            if (name.resolveBinding() == IBinding.NOT_FOUND_BINDING) break;
            if (functionDataDeclaration.hasSettingsBlock()) {
                this.processResolvableProperties(functionDataDeclaration.getSettingsBlockOpt(), name.resolveDataBinding(), null);
            }
            this.processResolvableProperties(name);
        }
    }

    @Override
    public void endVisit(ExecuteStatement statement) {
        super.endVisit(statement);
    }

    public void processSQLStatement(ExecuteStatement statement) {
    }

    private void bindSqlHostVariables(Statement statement, SQLInfo sqlInfo) {
        for (Token[] tokens : sqlInfo.getClauseMap().values()) {
            this.bindSqlHostVariables(statement, sqlInfo, tokens);
        }
    }

    private void bindSqlHostVariables(Statement statement, SQLInfo sqlInfo, Token[] tokens) {
        if (tokens == null) {
            return;
        }
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].isItemNameToken()) {
                this.bindSqlHostVariable(statement, sqlInfo, (ItemNameToken)tokens[i]);
            }
            ++i;
        }
    }

    private void bindSqlHostVariable(Statement statement, SQLInfo sqlInfo, ItemNameToken token) {
        String str = token.isInputHostVariableToken() || token.isOutputHostVariableToken() ? token.getString().substring(1) : token.getString();
        Expression expr = new ExpressionParser(this.compilerOptions).parseAsNameOrAccess(str);
        if (expr == null) {
            return;
        }
        token.setExpression(expr);
        IProblemRequestor oldProbReq = this.problemRequestor;
        AccumulatingProblemrRequestor newProbReq = new AccumulatingProblemrRequestor();
        this.problemRequestor = newProbReq;
        expr.accept(this);
        this.validateSqlHostVariable(expr);
        this.problemRequestor = oldProbReq;
        Iterator i = newProbReq.getProblems().iterator();
        boolean putErrorOnStatement = false;
        int startOffset = 0;
        if (sqlInfo.isDefaultStatement()) {
            putErrorOnStatement = true;
        } else {
            startOffset = sqlInfo.getInlineValueStart() + token.getStartOffset() - expr.getOffset();
        }
        while (i.hasNext()) {
            Problem problem = (Problem)i.next();
            if (sqlInfo.isDefaultStatement() && this.PROBLEM_KINDS_IGNORED_FOR_DEFAULT_SQL_HOST_VARIABLES.contains(new Integer(problem.getProblemKind()))) continue;
            if (putErrorOnStatement) {
                this.problemRequestor.acceptProblem(statement, problem.getProblemKind(), problem.getSeverity(), problem.getInserts());
                continue;
            }
            int probStart = startOffset + problem.getStartOffset() + 1;
            int probLen = problem.getEndOffset() - problem.getStartOffset();
            this.problemRequestor.acceptProblem(probStart, probStart + probLen, problem.getSeverity(), problem.getProblemKind(), problem.getInserts());
        }
    }

    private void validateSqlHostVariable(Expression expr) {
        IDataBinding dataBinding = expr.resolveDataBinding();
        if (dataBinding == null || dataBinding == IBinding.NOT_FOUND_BINDING) {
            return;
        }
        if (dataBinding.getDeclaringPart().getAnnotation(EGLIsSystemPartAnnotationTypeBinding.getInstance()) != null) {
            this.problemRequestor.acceptProblem((Node)expr, 5101, new String[]{expr.getCanonicalString()});
            return;
        }
        ITypeBinding typeBinding = expr.resolveTypeBinding();
        if (typeBinding == null || typeBinding == IBinding.NOT_FOUND_BINDING) {
            return;
        }
        if (26 == typeBinding.getKind()) {
            typeBinding = typeBinding.getBaseType();
        }
        if (typeBinding.getKind() != 3) {
            this.problemRequestor.acceptProblem((Node)expr, 6528, new String[]{expr.getCanonicalString()});
        }
    }

    private void getSQLRecordData(List exprList, IDataBinding[] data) {
        if (exprList == null || exprList.size() != 1) {
            return;
        }
        IDataBinding exprData = ((Expression)exprList.get(0)).resolveDataBinding();
        if (exprData == null || exprData == IBinding.NOT_FOUND_BINDING) {
            return;
        }
        if (exprData.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") == null) {
            return;
        }
        data[0] = exprData;
    }

    private void processSQLStatement(AddStatement statement) {
        IDataBinding sqlRecordData = null;
        IDataBinding[] dataArr = new IDataBinding[1];
        this.getSQLRecordData(statement.getIOObjects(), dataArr);
        if (dataArr[0] != null) {
            sqlRecordData = dataArr[0];
        }
        InlineSQLStatement inline = this.getInlineSQLStatement(statement);
        EGLSQLParser sqlParser = null;
        if (inline != null) {
            SQLInfo info = new SQLInfo();
            info.setInlineValueStart(inline.getValueOffset());
            sqlParser = new EGLSQLParser(inline.getValue(), "ANY", this.compilerOptions);
            info.setParser(sqlParser);
            statement.setSqlInfo(info);
        } else if (sqlRecordData != null) {
            EGLSQLAddStatementFactory sqlStatementFactory = new EGLSQLAddStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), this.compilerOptions);
            String sqlStatement = sqlStatementFactory.buildDefaultSQLStatement();
            this.reportErrorsForDefaultSQL(sqlStatementFactory, statement);
            if (sqlStatement != null) {
                SQLInfo info = new SQLInfo();
                info.setDefaultStatment(true);
                sqlParser = new EGLSQLParser(sqlStatement, "ANY", this.compilerOptions);
                info.setParser(sqlParser);
                statement.setSqlInfo(info);
            }
        }
        if (sqlParser != null && sqlParser.hasErrors()) {
            for (Problem msg : sqlParser.getErrors()) {
                this.problemRequestor.acceptProblem((Node)statement, msg.getProblemKind(), msg.getInserts());
            }
        }
        if (statement.getSqlInfo() != null) {
            if (sqlRecordData == null) {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser()));
            } else {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser(), sqlRecordData, true));
            }
            statement.getSqlInfo().getClauseMap().put("columns", statement.getSqlInfo().getGenTokens().getColumnsTokens());
            statement.getSqlInfo().getClauseMap().put("insert into", statement.getSqlInfo().getGenTokens().getInsertIntoTokens());
            statement.getSqlInfo().getClauseMap().put("values", statement.getSqlInfo().getGenTokens().getValuesTokens());
            this.bindSqlHostVariables(statement, statement.getSqlInfo());
        }
    }

    private void processSQLStatement(DeleteStatement statement) {
        IDataBinding sqlRecordData = null;
        IDataBinding[] dataArr = new IDataBinding[1];
        this.getSQLRecordData(statement.getIOObjects(), dataArr);
        if (dataArr[0] != null) {
            sqlRecordData = dataArr[0];
        }
        final ArrayList usingKeysList = new ArrayList();
        final boolean[] hasUsingKeys = new boolean[1];
        final boolean[] noCursor = new boolean[1];
        statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(NoCursorClause noCursorClause) {
                noCursor[0] = true;
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                noCursor[0] = true;
                hasUsingKeys[0] = true;
                for (Expression expr : usingKeysClause.getExpressions()) {
                    String colName = SQLUtility.getColumnName(expr);
                    if (colName == null) continue;
                    usingKeysList.add(new String[]{expr.getCanonicalString(), colName});
                }
                return false;
            }
        });
        InlineSQLStatement inline = this.getInlineSQLStatement(statement);
        EGLSQLParser sqlParser = null;
        if (inline != null) {
            SQLInfo info = new SQLInfo();
            info.setInlineValueStart(inline.getValueOffset());
            sqlParser = new EGLSQLParser(inline.getValue(), "ANY", this.compilerOptions);
            info.setParser(sqlParser);
            statement.setSqlInfo(info);
        } else if (sqlRecordData != null) {
            String[][] usingKeys = null;
            if (hasUsingKeys[0]) {
                usingKeys = (String[][])usingKeysList.toArray((T[])new String[usingKeysList.size()][]);
            }
            EGLSQLDeleteStatementFactory sqlStatementFactory = new EGLSQLDeleteStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), usingKeys, noCursor[0], this.compilerOptions);
            String sqlStatement = sqlStatementFactory.buildDefaultSQLStatement();
            this.reportErrorsForDefaultSQL(sqlStatementFactory, statement);
            if (sqlStatement != null) {
                SQLInfo info = new SQLInfo();
                info.setDefaultStatment(true);
                sqlParser = new EGLSQLParser(sqlStatement, "ANY", this.compilerOptions);
                info.setParser(sqlParser);
                statement.setSqlInfo(info);
            }
        }
        if (sqlParser != null && sqlParser.hasErrors()) {
            for (Problem msg : sqlParser.getErrors()) {
                this.problemRequestor.acceptProblem((Node)statement, msg.getProblemKind(), msg.getInserts());
            }
        }
        if (statement.getSqlInfo() != null) {
            if (sqlRecordData == null) {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser()));
            } else {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser(), sqlRecordData, true));
            }
            statement.getSqlInfo().getClauseMap().put("delete", statement.getSqlInfo().getGenTokens().getDeleteTokens());
            statement.getSqlInfo().getClauseMap().put("from", statement.getSqlInfo().getGenTokens().getFromTokens());
            statement.getSqlInfo().getClauseMap().put("where", statement.getSqlInfo().getGenTokens().getWhereTokens());
            statement.getSqlInfo().getClauseMap().put("where current of resultSetID", statement.getSqlInfo().getGenTokens().getWhereCurrentOfTokens());
            this.bindSqlHostVariables(statement, statement.getSqlInfo());
        }
    }

    private void processSQLStatement(ReplaceStatement statement) {
        IDataBinding sqlRecordData = null;
        IDataBinding[] dataArr = new IDataBinding[1];
        this.getSQLRecordData(statement.getIOObjects(), dataArr);
        if (dataArr[0] != null) {
            sqlRecordData = dataArr[0];
        }
        final ArrayList usingKeysList = new ArrayList();
        final boolean[] hasUsingKeys = new boolean[1];
        final boolean[] noCursor = new boolean[1];
        statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(NoCursorClause noCursorClause) {
                noCursor[0] = true;
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                noCursor[0] = true;
                hasUsingKeys[0] = true;
                for (Expression expr : usingKeysClause.getExpressions()) {
                    String colName = SQLUtility.getColumnName(expr);
                    if (colName == null) continue;
                    usingKeysList.add(new String[]{expr.getCanonicalString(), colName});
                }
                return false;
            }
        });
        InlineSQLStatement inline = this.getInlineSQLStatement(statement);
        EGLSQLParser sqlParser = null;
        if (inline != null) {
            SQLInfo info = new SQLInfo();
            info.setInlineValueStart(inline.getValueOffset());
            sqlParser = new EGLSQLParser(inline.getValue(), "ANY", this.compilerOptions);
            info.setParser(sqlParser);
            statement.setSqlInfo(info);
        } else if (sqlRecordData != null) {
            boolean isArray;
            ITypeBinding type = ((Expression)statement.getIOObjects().get(0)).resolveTypeBinding();
            boolean bl = isArray = type.getKind() == 2;
            if (!isArray) {
                String[][] usingKeys = null;
                if (hasUsingKeys[0]) {
                    usingKeys = (String[][])usingKeysList.toArray((T[])new String[usingKeysList.size()][]);
                }
                EGLSQLReplaceStatementFactory sqlStatementFactory = new EGLSQLReplaceStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), usingKeys, noCursor[0], this.compilerOptions);
                String sqlStatement = sqlStatementFactory.buildDefaultSQLStatement();
                this.reportErrorsForDefaultSQL(sqlStatementFactory, statement);
                if (sqlStatement != null) {
                    SQLInfo info = new SQLInfo();
                    info.setDefaultStatment(true);
                    sqlParser = new EGLSQLParser(sqlStatement, "ANY", this.compilerOptions);
                    info.setParser(sqlParser);
                    statement.setSqlInfo(info);
                }
            }
        }
        if (sqlParser != null && sqlParser.hasErrors()) {
            for (Problem msg : sqlParser.getErrors()) {
                this.problemRequestor.acceptProblem((Node)statement, msg.getProblemKind(), msg.getInserts());
            }
        }
        if (statement.getSqlInfo() != null) {
            if (sqlRecordData == null) {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser()));
            } else {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser(), sqlRecordData, true));
            }
            statement.getSqlInfo().getClauseMap().put("update", statement.getSqlInfo().getGenTokens().getUpdateTokens());
            statement.getSqlInfo().getClauseMap().put("set", statement.getSqlInfo().getGenTokens().getSetTokens());
            statement.getSqlInfo().getClauseMap().put("where", statement.getSqlInfo().getGenTokens().getWhereTokens());
            statement.getSqlInfo().getClauseMap().put("where current of resultSetID", statement.getSqlInfo().getGenTokens().getWhereCurrentOfTokens());
            this.bindSqlHostVariables(statement, statement.getSqlInfo());
        }
    }

    private void processSQLStatement(OpenStatement statement) {
        SQLInfo info;
        IDataBinding sqlRecordData = null;
        IDataBinding[] dataArr = new IDataBinding[1];
        this.getSQLRecordData(statement.getIOObjects(), dataArr);
        if (dataArr[0] != null) {
            sqlRecordData = dataArr[0];
        }
        final boolean[] hasPrepared = new boolean[1];
        final boolean[] isForUpdate = new boolean[1];
        final ArrayList intoNames = new ArrayList();
        final ArrayList usingKeysList = new ArrayList();
        final boolean[] hasUsingKeys = new boolean[1];
        statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(WithIDClause withIDClause) {
                hasPrepared[0] = true;
                return false;
            }

            @Override
            public boolean visit(ForUpdateClause forUpdateClause) {
                isForUpdate[0] = true;
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                Iterator i = intoClause.getExpressions().iterator();
                while (i.hasNext()) {
                    intoNames.add(((Expression)i.next()).getCanonicalString());
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                hasUsingKeys[0] = true;
                for (Expression expr : usingKeysClause.getExpressions()) {
                    String colName = SQLUtility.getColumnName(expr);
                    if (colName == null) continue;
                    usingKeysList.add(new String[]{expr.getCanonicalString(), colName});
                }
                return false;
            }
        });
        InlineSQLStatement inline = this.getInlineSQLStatement(statement);
        EGLSQLParser sqlParser = null;
        if (inline != null) {
            info = new SQLInfo();
            info.setInlineValueStart(inline.getValueOffset());
            sqlParser = new EGLSQLParser(inline.getValue(), "ANY", this.compilerOptions);
            info.setParser(sqlParser);
            statement.setSqlInfo(info);
        } else if (sqlRecordData != null && !hasPrepared[0]) {
            ArrayList into;
            String[][] usingKeys = null;
            if (hasUsingKeys[0]) {
                usingKeys = (String[][])usingKeysList.toArray((T[])new String[usingKeysList.size()][]);
            }
            if ((into = intoNames).size() == 0) {
                into = null;
            }
            EGLSQLDeclareStatementFactory sqlStatementFactory = isForUpdate[0] ? new EGLSQLOpenForUpdateStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), into, usingKeys, this.compilerOptions) : new EGLSQLOpenStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), into, usingKeys, this.compilerOptions);
            String sqlStatement = ((EGLSQLStatementFactory)sqlStatementFactory).buildDefaultSQLStatement();
            this.reportErrorsForDefaultSQL(sqlStatementFactory, statement);
            if (sqlStatement != null) {
                SQLInfo info2 = new SQLInfo();
                info2.setDefaultStatment(true);
                sqlParser = new EGLSQLParser(sqlStatement, "ANY", this.compilerOptions);
                info2.setParser(sqlParser);
                statement.setSqlInfo(info2);
            }
        }
        if (sqlParser != null && sqlParser.hasErrors()) {
            for (Problem msg : sqlParser.getErrors()) {
                this.problemRequestor.acceptProblem((Node)statement, msg.getProblemKind(), msg.getInserts());
            }
        }
        if (statement.getSqlInfo() != null) {
            if (sqlRecordData == null) {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser()));
            } else {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser(), sqlRecordData, true));
            }
            if (!hasPrepared[0]) {
                Token[] callTokens = statement.getSqlInfo().getGenTokens().getCallTokens();
                if (callTokens == null) {
                    statement.getSqlInfo().getClauseMap().put("select", statement.getSqlInfo().getGenTokens().getSelectTokens());
                    statement.getSqlInfo().getClauseMap().put("from", statement.getSqlInfo().getGenTokens().getFromTokens());
                    statement.getSqlInfo().getClauseMap().put("where", statement.getSqlInfo().getGenTokens().getWhereTokens());
                    statement.getSqlInfo().getClauseMap().put("group by", statement.getSqlInfo().getGenTokens().getGroupByTokens());
                    statement.getSqlInfo().getClauseMap().put("having", statement.getSqlInfo().getGenTokens().getHavingTokens());
                    if (isForUpdate[0]) {
                        Token[] updateTokens = statement.getSqlInfo().getGenTokens().getForUpdateOfTokens();
                        if (updateTokens != null) {
                            if (this.isForUpdateOf(updateTokens)) {
                                statement.getSqlInfo().getClauseMap().put("for update of", statement.getSqlInfo().getGenTokens().getForUpdateOfTokens());
                            } else {
                                statement.getSqlInfo().getClauseMap().put("for update", statement.getSqlInfo().getGenTokens().getForUpdateOfTokens());
                            }
                        }
                    } else {
                        statement.getSqlInfo().getClauseMap().put("order by", statement.getSqlInfo().getGenTokens().getOrderByTokens());
                    }
                    this.bindSqlHostVariables(statement, statement.getSqlInfo());
                } else {
                    statement.getSqlInfo().getClauseMap().put("call", callTokens);
                    this.bindSqlHostVariables(statement, statement.getSqlInfo());
                }
            }
        } else if (hasPrepared[0] && intoNames.size() > 0) {
            info = new SQLInfo();
            info.setDefaultStatment(true);
            statement.setSqlInfo(info);
        }
    }

    private boolean isForUpdateOf(Token[] tokens) {
        if (tokens == null || tokens.length == 0) {
            return false;
        }
        if (tokens[0].getString() == null) {
            return false;
        }
        return tokens[0].getString().toUpperCase().toLowerCase().startsWith("for update of");
    }

    private void processSQLStatement(GetByKeyStatement statement) {
        SQLInfo info;
        IDataBinding sqlRecordData = null;
        IDataBinding[] dataArr = new IDataBinding[1];
        this.getSQLRecordData(statement.getIOObjects(), dataArr);
        if (dataArr[0] != null) {
            sqlRecordData = dataArr[0];
        }
        final boolean[] hasPrepared = new boolean[1];
        final boolean[] isForUpdate = new boolean[1];
        final ArrayList intoNames = new ArrayList();
        final ArrayList usingKeysList = new ArrayList();
        final boolean[] hasUsingKeys = new boolean[1];
        statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(WithIDClause withIDClause) {
                hasPrepared[0] = true;
                return false;
            }

            @Override
            public boolean visit(ForUpdateClause forUpdateClause) {
                isForUpdate[0] = true;
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                Iterator i = intoClause.getExpressions().iterator();
                while (i.hasNext()) {
                    intoNames.add(((Expression)i.next()).getCanonicalString());
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                hasUsingKeys[0] = true;
                for (Expression expr : usingKeysClause.getExpressions()) {
                    String colName = SQLUtility.getColumnName(expr);
                    if (colName == null) continue;
                    usingKeysList.add(new String[]{expr.getCanonicalString(), colName});
                }
                return false;
            }
        });
        InlineSQLStatement inline = this.getInlineSQLStatement(statement);
        EGLSQLParser sqlParser = null;
        if (inline != null) {
            info = new SQLInfo();
            info.setInlineValueStart(inline.getValueOffset());
            sqlParser = new EGLSQLParser(inline.getValue(), "ANY", this.compilerOptions);
            info.setParser(sqlParser);
            statement.setSqlInfo(info);
        } else if (sqlRecordData != null && !hasPrepared[0]) {
            EGLSQLDeclareStatementFactory sqlStatementFactory;
            ArrayList into;
            String[][] usingKeys = null;
            if (hasUsingKeys[0]) {
                usingKeys = (String[][])usingKeysList.toArray((T[])new String[usingKeysList.size()][]);
            }
            if ((into = intoNames).size() == 0) {
                into = null;
            }
            if (isForUpdate[0]) {
                sqlStatementFactory = new EGLSQLGetByKeyForUpdateStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), into, usingKeys, false, this.compilerOptions);
            } else {
                ITypeBinding type = ((Expression)statement.getIOObjects().get(0)).resolveTypeBinding();
                boolean isArray = type.getKind() == 2;
                sqlStatementFactory = new EGLSQLGetByKeyStatementFactory(sqlRecordData, ((Expression)statement.getIOObjects().get(0)).getCanonicalString(), into, usingKeys, isArray, this.compilerOptions);
            }
            String sqlStatement = ((EGLSQLStatementFactory)sqlStatementFactory).buildDefaultSQLStatement();
            this.reportErrorsForDefaultSQL(sqlStatementFactory, statement);
            if (sqlStatement != null) {
                SQLInfo info2 = new SQLInfo();
                info2.setDefaultStatment(true);
                sqlParser = new EGLSQLParser(sqlStatement, "ANY", this.compilerOptions);
                info2.setParser(sqlParser);
                statement.setSqlInfo(info2);
            }
        }
        if (sqlParser != null && sqlParser.hasErrors()) {
            for (Problem msg : sqlParser.getErrors()) {
                this.problemRequestor.acceptProblem((Node)statement, msg.getProblemKind(), msg.getInserts());
            }
        }
        if (statement.getSqlInfo() != null) {
            if (sqlRecordData == null) {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser()));
            } else {
                statement.getSqlInfo().setGenTokens(new EGLSQLGenerationTokens(statement.getSqlInfo().getParser(), sqlRecordData, true));
            }
            if (!hasPrepared[0]) {
                Token[] callTokens = statement.getSqlInfo().getGenTokens().getCallTokens();
                if (callTokens == null) {
                    statement.getSqlInfo().getClauseMap().put("select", statement.getSqlInfo().getGenTokens().getSelectTokens());
                    statement.getSqlInfo().getClauseMap().put("from", statement.getSqlInfo().getGenTokens().getFromTokens());
                    statement.getSqlInfo().getClauseMap().put("where", statement.getSqlInfo().getGenTokens().getWhereTokens());
                    statement.getSqlInfo().getClauseMap().put("group by", statement.getSqlInfo().getGenTokens().getGroupByTokens());
                    statement.getSqlInfo().getClauseMap().put("having", statement.getSqlInfo().getGenTokens().getHavingTokens());
                    if (isForUpdate[0]) {
                        statement.getSqlInfo().getClauseMap().put("for update of", statement.getSqlInfo().getGenTokens().getForUpdateOfTokens());
                    } else {
                        statement.getSqlInfo().getClauseMap().put("order by", statement.getSqlInfo().getGenTokens().getOrderByTokens());
                    }
                    this.bindSqlHostVariables(statement, statement.getSqlInfo());
                } else {
                    statement.getSqlInfo().getClauseMap().put("call", callTokens);
                    this.bindSqlHostVariables(statement, statement.getSqlInfo());
                }
            }
        } else if (hasPrepared[0] && intoNames.size() > 0) {
            info = new SQLInfo();
            info.setDefaultStatment(true);
            statement.setSqlInfo(info);
        }
    }

    private InlineSQLStatement getInlineSQLStatement(Statement stmt) {
        final InlineSQLStatement[] inline = new InlineSQLStatement[1];
        stmt.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(InlineSQLStatement inlineSQLStatement) {
                inline[0] = inlineSQLStatement;
                return false;
            }
        });
        return inline[0];
    }

    private void visitStatementBlocks(Statement statement) {
        Iterator iter = statement.getStatementBlocks().iterator();
        while (iter.hasNext()) {
            this.currentScope = new StatementBlockScope(this.currentScope);
            Iterator stmtIter = ((List)iter.next()).iterator();
            while (stmtIter.hasNext()) {
                ((Node)stmtIter.next()).accept(this);
            }
            this.currentScope = this.currentScope.getParentScope();
        }
    }

    @Override
    public boolean visit(IfStatement ifStatement) {
        ifStatement.getCondition().accept(this);
        this.visitStatementBlocks(ifStatement);
        return false;
    }

    @Override
    public boolean visit(CaseStatement caseStatement) {
        boolean criterionIsSysType = false;
        boolean criterionIsEventKey = false;
        if (caseStatement.hasCriterion()) {
            Expression expr = caseStatement.getCriterion();
            expr.accept(this);
            IDataBinding dBinding = expr.resolveDataBinding();
            if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "core"}, "SysVar", "SYSTEMTYPE")) {
                criterionIsSysType = true;
            }
            if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "ui", "text"}, "ConverseVar", "EVENTKEY")) {
                criterionIsEventKey = true;
            }
        }
        for (WhenClause whenClause : caseStatement.getWhenClauses()) {
            for (Expression expr : whenClause.getExpr_plus()) {
                if (criterionIsSysType) {
                    expr.accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public void endVisit(SimpleName simpleName) {
                            IsNotStateBinding dBinding = IsNotStateBinding.toIsNotStateBinding(simpleName.getIdentifier());
                            if (dBinding == null || dBinding.getIsNotStateKind() != 1) {
                                this.endVisitExpression(simpleName);
                            } else {
                                simpleName.setBinding(dBinding);
                            }
                        }

                        @Override
                        public void endVisitExpression(Expression expression) {
                            FunctionBinder.this.problemRequestor.acceptProblem((Node)expression, 5165, new String[]{expression.getCanonicalString()});
                        }
                    });
                    continue;
                }
                if (criterionIsEventKey) {
                    expr.accept(new AbstractASTExpressionVisitor(){

                        @Override
                        public void endVisit(SimpleName simpleName) {
                            IsNotStateBinding dBinding = IsNotStateBinding.toIsNotStateBinding(simpleName.getIdentifier());
                            if (dBinding == null || dBinding.getIsNotStateKind() != 0) {
                                this.endVisitExpression(simpleName);
                            } else {
                                simpleName.setBinding(dBinding);
                            }
                        }

                        @Override
                        public void endVisitExpression(Expression expression) {
                            FunctionBinder.this.problemRequestor.acceptProblem((Node)expression, 5164, new String[]{expression.getCanonicalString()});
                        }
                    });
                    continue;
                }
                expr.accept(this);
            }
        }
        this.visitStatementBlocks(caseStatement);
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        if (forStatement.hasVariableDeclaration()) {
            this.processDataDeclaration(Arrays.asList(forStatement.getVariableDeclarationName()), null);
        } else {
            forStatement.getCounterVariable().accept(this);
        }
        if (forStatement.hasFromIndex()) {
            forStatement.getFromIndex().accept(this);
        }
        forStatement.getEndIndex().accept(this);
        if (forStatement.hasPositiveDelta() || forStatement.hasNegativeDelta()) {
            forStatement.getDeltaExpression().accept(this);
        }
        Iterator iter = forStatement.getStmts().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        for (Node n : forEachStatement.getTargets()) {
            n.accept(this);
        }
        forEachStatement.getResultSet().getExpression().accept(this);
        final FunctionBinder binder = this;
        forEachStatement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(UsingClause usingClause) {
                Iterator iter = usingClause.getExpressions().iterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).accept(binder);
                }
                return false;
            }

            @Override
            public boolean visit(IntoClause intoClause) {
                Iterator iter = intoClause.getExpressions().iterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).accept(binder);
                }
                return false;
            }

            @Override
            public boolean visit(WithExpressionClause withExpressionClause) {
                withExpressionClause.accept(binder);
                return false;
            }
        });
        this.visitStatementBlocks(forEachStatement);
        return false;
    }

    @Override
    public boolean visit(WhileStatement whileStatement) {
        whileStatement.getExpr().accept(this);
        this.visitStatementBlocks(whileStatement);
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        Iterator iter = tryStatement.getStmts().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        iter = tryStatement.getOnExceptionBlocks().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        this.currentScope = new StatementBlockScope(this.currentScope);
        if (onExceptionBlock.hasExceptionDeclaration()) {
            this.processDataDeclaration(Arrays.asList(onExceptionBlock.getExceptionName()), null);
        }
        Iterator iter = onExceptionBlock.getStmts().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        this.currentScope = this.currentScope.getParentScope();
        return false;
    }
}

