/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.LocalConstantBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTStatementVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ILocalVariableScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.StatementBlockScope;

public class LocalVariableAndIOObjectBinder
extends AbstractASTStatementVisitor {
    Scope functionScope;
    IProblemRequestor problemRequestor;
    private AbstractBinder binder;
    private List functionDataDecls = new ArrayList();
    private IPartBinding declaringPartBinding;
    private Set IOObjects = new HashSet();
    private boolean i4GLItemsNullableIsSet;

    public LocalVariableAndIOObjectBinder(Scope functionScope, IProblemRequestor problemRequestor, AbstractBinder binder, IPartBinding declaringPartBinding) {
        this.functionScope = new StatementBlockScope(functionScope);
        this.problemRequestor = problemRequestor;
        this.binder = binder;
        this.declaringPartBinding = declaringPartBinding;
        this.i4GLItemsNullableIsSet = functionScope.getParentScope().I4GLItemsNullableIsEnabled();
    }

    @Override
    public void visitStatement(Statement stmt) {
    }

    @Override
    public boolean internalVisitStatement(Statement statement) {
        for (Expression nextExpr : statement.getIOObjects()) {
            nextExpr.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(SimpleName simpleName) {
                    IDataBinding ioTargetDataBinding = LocalVariableAndIOObjectBinder.this.functionScope.findIOTargetData(simpleName.getIdentifier());
                    if (ioTargetDataBinding != IBinding.NOT_FOUND_BINDING) {
                        simpleName.setBinding(ioTargetDataBinding);
                        simpleName.setTypeBinding(ioTargetDataBinding.getType());
                        if (ioTargetDataBinding.getKind() == 12) {
                            LocalVariableAndIOObjectBinder.this.problemRequestor.acceptProblem(simpleName, 6620, 2, new String[]{simpleName.getIdentifier()});
                        } else {
                            LocalVariableAndIOObjectBinder.this.IOObjects.add(ioTargetDataBinding);
                        }
                    }
                    return false;
                }
            });
        }
        if (statement.canIncludeOtherStatements()) {
            Iterator iter = statement.getStatementBlocks().iterator();
            while (iter.hasNext()) {
                this.functionScope = new StatementBlockScope(this.functionScope);
                Iterator stmtIter = ((List)iter.next()).iterator();
                while (stmtIter.hasNext()) {
                    ((Node)stmtIter.next()).accept(this);
                }
                this.functionScope = this.functionScope.getParentScope();
            }
        }
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        this.functionDataDecls.add(functionDataDeclaration);
        this.processDataDeclaration(functionDataDeclaration.getNames(), functionDataDeclaration.getType(), functionDataDeclaration.getSettingsBlockOpt(), functionDataDeclaration.isConstant(), functionDataDeclaration.getInitializer());
        return true;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        this.functionScope = new StatementBlockScope(this.functionScope);
        if (forStatement.hasVariableDeclaration()) {
            this.processDataDeclaration(Arrays.asList(forStatement.getVariableDeclarationName()), forStatement.getVariableDeclarationType(), null, false, null);
        }
        Iterator stmtIter = forStatement.getStmts().iterator();
        while (stmtIter.hasNext()) {
            ((Node)stmtIter.next()).accept(this);
        }
        this.functionScope = this.functionScope.getParentScope();
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.functionScope = new StatementBlockScope(this.functionScope);
        Iterator stmtIter = tryStatement.getStmts().iterator();
        while (stmtIter.hasNext()) {
            ((Node)stmtIter.next()).accept(this);
        }
        this.functionScope = this.functionScope.getParentScope();
        Iterator iter = tryStatement.getOnExceptionBlocks().iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        this.functionScope = new StatementBlockScope(this.functionScope);
        if (onExceptionBlock.hasExceptionDeclaration()) {
            this.processDataDeclaration(Arrays.asList(onExceptionBlock.getExceptionName()), onExceptionBlock.getExceptionType(), null, false, null);
        }
        Iterator stmtIter = onExceptionBlock.getStmts().iterator();
        while (stmtIter.hasNext()) {
            ((Node)stmtIter.next()).accept(this);
        }
        this.functionScope = this.functionScope.getParentScope();
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void processDataDeclaration(List names, Type type, SettingsBlock settingsBlock, boolean isConstantDeclaration, Expression initializer) {
        block8: {
            typeBinding = null;
            try {
                typeBinding = this.binder.bindType(type);
                if (this.i4GLItemsNullableIsSet && 3 == typeBinding.getBaseType().getKind()) {
                    typeBinding = typeBinding.getNullableInstance();
                }
                break block8;
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                if (settingsBlock != null) {
                    AbstractBinder.bindNamesToNotFound(settingsBlock);
                }
                iter = names.iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                ((Name)iter.next()).setBinding(IBinding.NOT_FOUND_BINDING);
                continue;
            }
lbl15:
            // 1 sources

            return;
        }
        constantValue = null;
        if (isConstantDeclaration) {
            constantValue = AbstractBinder.getConstantValue(initializer, typeBinding, ((Name)names.get(0)).getCanonicalName(), this.problemRequestor);
        }
        for (Name name : names) {
            dataName = name.getIdentifier();
            v0 /* !! */  = varBinding /* !! */  = isConstantDeclaration != false ? new LocalConstantBinding(name.getCaseSensitiveIdentifier(), this.declaringPartBinding, typeBinding, constantValue) : new LocalVariableBinding(name.getCaseSensitiveIdentifier(), this.declaringPartBinding, typeBinding);
            if (!((ILocalVariableScope)this.functionScope).hasDeclaredDataName(dataName)) {
                ((ILocalVariableScope)this.functionScope).addLocalVariable(varBinding /* !! */ );
                ((ILocalVariableScope)this.functionScope).addDeclaredDataName(dataName);
            }
            name.setBinding(varBinding /* !! */ );
        }
    }

    public Set getIOObjects() {
        return this.IOObjects;
    }
}

