/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;

public class SoftLRUCache {
    private static final boolean DEBUG = false;
    private Map softReferences;
    private ReferenceQueue referenceQueue;

    public SoftLRUCache() {
        this.softReferences = new LinkedHashMap(16, 0.75f, true);
        this.referenceQueue = new ReferenceQueue();
    }

    public SoftLRUCache(final int maxSize) {
        this.softReferences = new LinkedHashMap((int)((float)maxSize * 0.75f), 0.75f, true){
            private static final long serialVersionUID = 1503311551124552810L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxSize;
            }
        };
        this.referenceQueue = new ReferenceQueue();
    }

    public void put(Object key, Object value) {
        this.removeClearedReferences();
        this.softReferences.put(key, new SoftReferenceWithKey(key, value, this.referenceQueue));
    }

    public Object get(Object key) {
        this.removeClearedReferences();
        SoftReferenceWithKey ref = (SoftReferenceWithKey)this.softReferences.get(key);
        if (ref == null) {
            return null;
        }
        Object result = ref.get();
        return result;
    }

    public void remove(Object key) {
        this.removeClearedReferences();
        this.softReferences.remove(key);
    }

    private void removeClearedReferences() {
        SoftReferenceWithKey ref;
        while ((ref = (SoftReferenceWithKey)this.referenceQueue.poll()) != null) {
            this.softReferences.remove(ref.key);
        }
    }

    public static void main(String[] args) {
        SoftLRUCache cache = new SoftLRUCache(5);
        int i = 0;
        while (i < 1000) {
            Integer key = new Integer((int)Math.floor(Math.random() * 100.0));
            if (Math.round(Math.random()) == 0L) {
                int sizeInKilobytes = (int)Math.floor(Math.random() * 100.0);
                int[] value = new int[sizeInKilobytes * 1024];
                cache.put(key, value);
            } else if (cache.get(key) != null) {
                System.out.println("Get: " + key);
            } else {
                System.out.println("Key Not found: " + key);
            }
            ++i;
        }
    }

    private static class SoftReferenceWithKey
    extends SoftReference {
        Object key;

        SoftReferenceWithKey(Object key, Object referent, ReferenceQueue q) {
            super(referent, q);
            this.key = key;
        }
    }
}

