/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAS400ParameterAnnotaionValidator;

public abstract class AS400DecimalValidator
extends AbstractAS400ParameterAnnotaionValidator {
    @Override
    public void validate(IAnnotationBinding annotation, Node errorNode, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor) {
        super.validate(annotation, errorNode, targetTypeBinding, problemRequestor);
        if (Binding.isValidBinding(targetTypeBinding) && this.isValidType(targetTypeBinding)) {
            if (((PrimitiveTypeBinding)targetTypeBinding).getLength() > 0) {
                this.validateLengthAndDecimalsNotSpecified(annotation, errorNode, problemRequestor);
            } else {
                this.validateLengthAndDecimalsSpecified(annotation, errorNode, problemRequestor);
                this.validateLength(annotation, errorNode, problemRequestor);
                this.validateDecimals(annotation, errorNode, problemRequestor);
            }
        }
    }

    private void validateLength(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        Integer length = this.getLength(ann);
        if (length != null && (length < 1 || length > 32)) {
            problemRequestor.acceptProblem(errorNode, 5707, new String[]{length.toString(), this.getName(), "32"});
        }
    }

    protected void validateDecimals(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        Integer decimals = this.getDecimals(ann);
        if (decimals != null) {
            Integer length;
            if (decimals < 0) {
                problemRequestor.acceptProblem(errorNode, 5708, new String[]{decimals.toString(), this.getName()});
            }
            if ((length = this.getLength(ann)) != null && decimals > length) {
                problemRequestor.acceptProblem(errorNode, 5709, new String[]{decimals.toString(), this.getName(), length.toString()});
            }
        }
    }

    protected void validateLengthAndDecimalsNotSpecified(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        if (this.getLength(ann) != null) {
            problemRequestor.acceptProblem(errorNode, 5711, new String[]{"length", this.getName()});
        }
        if (this.getDecimals(ann) != null) {
            problemRequestor.acceptProblem(errorNode, 5711, new String[]{"decimals", this.getName()});
        }
    }

    protected void validateLengthAndDecimalsSpecified(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        if (this.getLength(ann) == null) {
            problemRequestor.acceptProblem(errorNode, 5710, new String[]{"length", this.getName()});
        }
        if (this.getDecimals(ann) == null) {
            problemRequestor.acceptProblem(errorNode, 5710, new String[]{"decimals", this.getName()});
        }
    }

    protected Integer getDecimals(IAnnotationBinding annotation) {
        return (Integer)this.getValue(annotation, "decimals");
    }

    protected Integer getLength(IAnnotationBinding annotation) {
        return (Integer)this.getValue(annotation, "length");
    }

    @Override
    protected List<Primitive> getSupportedTypes() {
        ArrayList<Primitive> list = new ArrayList<Primitive>();
        list.add(Primitive.DECIMAL);
        return list;
    }
}

