/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.AS400TextAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAS400ParameterAnnotaionValidator;

public class AS400TextValidator
extends AbstractAS400ParameterAnnotaionValidator {
    @Override
    public void validate(IAnnotationBinding annotation, Node errorNode, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor) {
        super.validate(annotation, errorNode, targetTypeBinding, problemRequestor);
        if (Binding.isValidBinding(targetTypeBinding) && this.isValidType(targetTypeBinding)) {
            if (((PrimitiveTypeBinding)targetTypeBinding).getLength() > 0) {
                this.validateLengthNotSpecified(annotation, errorNode, problemRequestor);
            } else {
                this.validateLengthSpecified(annotation, errorNode, problemRequestor);
                this.validateLength(annotation, errorNode, problemRequestor);
            }
        }
    }

    private void validateLength(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        Integer length = this.getLength(ann);
        if (length != null && (length < 1 || length > Integer.MAX_VALUE)) {
            problemRequestor.acceptProblem(errorNode, 5707, new String[]{length.toString(), this.getName(), Integer.toString(Integer.MAX_VALUE)});
        }
    }

    protected void validateLengthNotSpecified(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        if (this.getLength(ann) != null) {
            problemRequestor.acceptProblem(errorNode, 5711, new String[]{"length", this.getName()});
        }
    }

    protected void validateLengthSpecified(IAnnotationBinding ann, Node errorNode, IProblemRequestor problemRequestor) {
        if (this.getLength(ann) == null) {
            problemRequestor.acceptProblem(errorNode, 5710, new String[]{"length", this.getName()});
        }
    }

    protected Integer getLength(IAnnotationBinding annotation) {
        return (Integer)this.getValue(annotation, "length");
    }

    @Override
    protected List<Primitive> getSupportedTypes() {
        ArrayList<Primitive> list = new ArrayList<Primitive>();
        list.add(Primitive.STRING);
        return list;
    }

    @Override
    protected String getName() {
        return AS400TextAnnotationTypeBinding.caseSensitiveName;
    }

    @Override
    protected String getInternedName() {
        return AS400TextAnnotationTypeBinding.name;
    }
}

