/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;

public abstract class AbstractAS400ParameterAnnotaionValidator
implements IAnnotationValidationRule {
    protected abstract List<Primitive> getSupportedTypes();

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotation = (IAnnotationBinding)allAnnotations.get(this.getInternedName());
        this.validate(annotation, errorNode, targetTypeBinding, problemRequestor);
    }

    public void validate(IAnnotationBinding annotation, Node errorNode, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor) {
        this.validateTypeIsSupported(errorNode, targetTypeBinding, problemRequestor);
    }

    protected void validateTypeIsSupported(Node errorNode, ITypeBinding targetTypeBinding, IProblemRequestor problemRequestor) {
        if (Binding.isValidBinding(targetTypeBinding) && targetTypeBinding.isNullable()) {
            problemRequestor.acceptProblem(errorNode, 5716, new String[]{this.getName(), String.valueOf(targetTypeBinding.getCaseSensitiveName()) + "?"});
        }
        if (!this.isValidType(targetTypeBinding)) {
            problemRequestor.acceptProblem(errorNode, 5700, new String[]{this.getName(), targetTypeBinding.getCaseSensitiveName()});
        }
    }

    protected abstract String getName();

    protected abstract String getInternedName();

    protected boolean isValidType(ITypeBinding typeBinding) {
        if (Binding.isValidBinding(typeBinding)) {
            if (3 == typeBinding.getKind()) {
                Primitive prim = ((PrimitiveTypeBinding)typeBinding).getPrimitive();
                List<Primitive> supportedPrims = this.getSupportedTypes();
                return supportedPrims.contains(prim);
            }
            return false;
        }
        return true;
    }

    protected Object getValue(IAnnotationBinding ann, String fieldName) {
        if (!Binding.isValidBinding(ann)) {
            return null;
        }
        IDataBinding db = ann.findData(fieldName);
        if (!Binding.isValidBinding(db)) {
            return null;
        }
        return ((AnnotationFieldBinding)db).getValue();
    }
}

