/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DateAndTimeFormatForJSFHandlerValidator
extends DefaultFieldContentAnnotationValidationRule {
    private static final int MIN_LENGTH_FOR_TEXT_ITEM_WITH_DATEFORMAT = 10;
    private static final int MIN_LENGTH_FOR_NUMERIC_ITEM_WITH_DDD_YYYY_DATEFORMAT = 7;
    private static final int MIN_LENGTH_FOR_NUMERIC_ITEM_WITH_DDD_YY_DATEFORMAT = 5;
    private static final int MIN_LENGTH_FOR_NUMERIC_ITEM_WITH_YYYY_DATEFORMAT = 8;
    private static final int MIN_LENGTH_FOR_NUMERIC_ITEM_WITH_YY_DATEFORMAT = 6;
    private static final int MIN_LENGTH_FOR_NUMERIC_ITEM_WITH_OTHER_DATEFORMAT = 8;
    private static final int MIN_LENGTH_FOR_TEXT_ITEM_WITH_TIMEFORMAT = 8;
    private static final int MIN_LENGTH_FOR_NUMERIC_ITEM_WITH_TIMEFORMAT = 6;

    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        PrimitiveTypeBinding primTypeBinding;
        ITypeBinding targetType = containerBinding.getType();
        if (targetType != null && IBinding.NOT_FOUND_BINDING != targetType && 3 == targetType.getKind() && (primTypeBinding = (PrimitiveTypeBinding)targetType).getDecimals() == 0) {
            Primitive prim = primTypeBinding.getPrimitive();
            if (prim == Primitive.STRING) {
                return;
            }
            int length = primTypeBinding.getLength();
            IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"dateFormat"));
            if (annotationBinding != null && annotationBinding.getValue() != null) {
                if (Primitive.isStringType(prim)) {
                    if (length < 10) {
                        problemRequestor.acceptProblem(errorNode, 5417, new String[]{containerBinding.getCaseSensitiveName(), Integer.toString(10), "dateFormat"});
                    }
                } else if (Primitive.isNumericType(prim)) {
                    String value = (String)annotationBinding.getValue();
                    int minLength = 0;
                    if (value.indexOf("DDD") != -1) {
                        if (value.indexOf("yyyy") != -1) {
                            minLength = 7;
                        } else if (value.indexOf("yy") != -1) {
                            minLength = 5;
                        }
                    } else if (value.indexOf("yyyy") != -1) {
                        minLength = 8;
                    } else if (value.indexOf("yy") != -1) {
                        minLength = 6;
                    }
                    if (minLength == 0) {
                        minLength = 8;
                    }
                    if (length < minLength) {
                        problemRequestor.acceptProblem(errorNode, 5416, new String[]{containerBinding.getCaseSensitiveName(), Integer.toString(minLength), value});
                    }
                }
            } else {
                annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"timeFormat"));
                if (annotationBinding != null && annotationBinding.getValue() != null) {
                    if (Primitive.isStringType(prim)) {
                        if (length < 8) {
                            problemRequestor.acceptProblem(errorNode, 5417, new String[]{containerBinding.getCaseSensitiveName(), Integer.toString(8), "timeFormat"});
                        }
                    } else if (Primitive.isNumericType(prim) && length < 6) {
                        problemRequestor.acceptProblem(errorNode, 5418, new String[]{containerBinding.getCaseSensitiveName(), Integer.toString(6), "timeFormat"});
                    }
                }
            }
        }
    }
}

