/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DateFormatForFormFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"dateFormat"));
        if (annotationBinding != null && annotationBinding.getValue() != null) {
            try {
                int fieldLength = Integer.parseInt(((IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"fieldLen"))).getValue().toString());
                int[] allowedLengths = null;
                Object value = annotationBinding.getValue();
                if (value instanceof IDataBinding) {
                    IDataBinding dBinding = (IDataBinding)value;
                    if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "vg"}, "VGVar", "SYSTEMJULIANDATEFORMAT")) {
                        allowedLengths = new int[]{6, 8};
                    } else if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "vg"}, "VGVar", "SYSTEMGREGORIANDATEFORMAT")) {
                        allowedLengths = new int[]{8, 10};
                    }
                }
                if (allowedLengths != null && fieldLength != allowedLengths[0] && fieldLength != allowedLengths[1]) {
                    problemRequestor.acceptProblem(errorNode, 3177, new String[]{"dateFormat", ((IDataBinding)value).getCaseSensitiveName(), canonicalContainerName, Integer.toString(allowedLengths[0]), Integer.toString(allowedLengths[1]), StatementValidator.getShortTypeString(containerBinding.getType())});
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

