/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.AS400ParmeterAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractAS400ParameterAnnotaionValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IBMiProgramValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;

public class IBMiProgramParameterAnnotationsValidator
implements IValueValidationRule {
    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IFunctionBinding functionBinding = this.getFunctionBinding(target);
        if (!Binding.isValidBinding(functionBinding)) {
            return;
        }
        Object[] values = (Object[])annotationBinding.getValue();
        if (values == null) {
            return;
        }
        if (values.length != functionBinding.getParameters().size()) {
            problemRequestor.acceptProblem(errorNode, 5701, new String[]{functionBinding.getCaseSensitiveName()});
            return;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i] == null) {
                if (IBMiProgramValidator.requiresAS400TypeAnnotation(((FunctionParameterBinding)functionBinding.getParameters().get(i)).getType())) {
                    problemRequestor.acceptProblem(this.getNodeForArrayEntry(errorNode, i), 5715, new String[]{((FunctionParameterBinding)functionBinding.getParameters().get(i)).getCaseSensitiveName()});
                }
            } else {
                AbstractAS400ParameterAnnotaionValidator validator = IBMiProgramParameterAnnotationsValidator.getValidator(values[i]);
                if (validator == null) {
                    problemRequestor.acceptProblem(this.getNodeForArrayEntry(errorNode, i), 5702, new String[]{Integer.toString(i)});
                } else {
                    validator.validate((IAnnotationBinding)values[i], this.getNodeForArrayEntry(errorNode, i), ((FunctionParameterBinding)functionBinding.getParameters().get(i)).getType(), problemRequestor);
                }
            }
            ++i;
        }
    }

    public static AbstractAS400ParameterAnnotaionValidator getValidator(Object obj) {
        if (!(obj instanceof IAnnotationBinding)) {
            return null;
        }
        if (!Binding.isValidBinding(((IAnnotationBinding)obj).getAnnotationType())) {
            return null;
        }
        IAnnotationTypeBinding proxy = ((IAnnotationBinding)obj).getAnnotationType().getValidationProxy();
        if (proxy instanceof AS400ParmeterAnnotationTypeBinding) {
            return ((AS400ParmeterAnnotationTypeBinding)proxy).getValidator();
        }
        return null;
    }

    private Node getNodeForArrayEntry(Node node, final int index) {
        final Node[] result = new Node[]{node};
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(ArrayLiteral arrayLiteral) {
                if (index < arrayLiteral.getExpressions().size()) {
                    result[0] = (Node)arrayLiteral.getExpressions().get(index);
                }
                return false;
            }
        };
        node.accept(visitor);
        return result[0];
    }

    private IFunctionBinding getFunctionBinding(Node node) {
        NestedFunction function;
        IBinding binding;
        if (node == null) {
            return null;
        }
        if (node instanceof NestedFunction && Binding.isValidBinding(binding = (function = (NestedFunction)node).getName().resolveBinding()) && binding.isDataBinding() && ((IDataBinding)binding).getKind() == 20) {
            return (IFunctionBinding)((NestedFunctionBinding)binding).getType();
        }
        return this.getFunctionBinding(node.getParent());
    }
}

