/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MinimumInputForStructureItemValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (allAnnotations.containsKey(InternUtil.intern((String)"minimumInput"))) {
            int minimumInputLength = (Integer)((IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"minimumInput"))).getValue();
            int definedLength = this.getFieldLength(container);
            if (definedLength < 0) {
                return;
            }
            int maxLengthAllowed = definedLength;
            if (this.hasDecimals(container)) {
                ++maxLengthAllowed;
            }
            if (allAnnotations.containsKey(InternUtil.intern((String)"sign"))) {
                ++maxLengthAllowed;
            }
            if (allAnnotations.containsKey(InternUtil.intern((String)"currency"))) {
                ++maxLengthAllowed;
            }
            if (allAnnotations.containsKey(InternUtil.intern((String)"numericSeparator"))) {
                ++maxLengthAllowed;
            }
            if (minimumInputLength > maxLengthAllowed) {
                problemRequestor.acceptProblem(errorNode, 3103, new String[]{String.valueOf(minimumInputLength), String.valueOf(maxLengthAllowed), ""});
            }
        }
    }

    private boolean hasDecimals(Node expression) {
        final Boolean[] value = new Boolean[1];
        expression.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                Type type = structureItem.getType();
                type.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(NameType nameType) {
                        ITypeBinding binding = nameType.resolveTypeBinding();
                        value[0] = new Boolean(((DataItemBinding)binding).getPrimitiveTypeBinding().getDecimals() > 0);
                        return false;
                    }

                    @Override
                    public boolean visit(PrimitiveType primitiveType) {
                        value[0] = new Boolean(primitiveType.hasPrimDecimals());
                        return false;
                    }
                });
                return false;
            }
        });
        return value[0];
    }

    private int getPrimLengthForMinInput(ITypeBinding type) {
        if (Binding.isValidBinding(type)) {
            return -1;
        }
        if (type.getKind() == 17) {
            return this.getPrimLengthForMinInput(((DataItemBinding)type).getPrimitiveTypeBinding());
        }
        if (type.getKind() == 3) {
            PrimitiveTypeBinding prim = (PrimitiveTypeBinding)type;
            if (prim.getPrimitive() != null && prim.getPrimitive() == Primitive.STRING) {
                return -1;
            }
            if (prim.getPrimitive() != null && prim.getPrimitive() == Primitive.ANY) {
                return -1;
            }
            return prim.getLength();
        }
        return -1;
    }

    private int getFieldLength(Node expression) {
        final Integer[] length = new Integer[1];
        expression.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                Type type = structureItem.getType();
                type.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ArrayType arrayType) {
                        return true;
                    }

                    @Override
                    public boolean visit(NameType nameType) {
                        ITypeBinding binding = nameType.resolveTypeBinding();
                        length[0] = new Integer(MinimumInputForStructureItemValidator.this.getPrimLengthForMinInput(binding));
                        return false;
                    }

                    @Override
                    public boolean visit(PrimitiveType primitiveType) {
                        if (primitiveType.hasPrimLength()) {
                            length[0] = new Integer(primitiveType.getPrimLength());
                        } else if (Binding.isValidBinding(primitiveType.resolveTypeBinding())) {
                            length[0] = new Integer(MinimumInputForStructureItemValidator.this.getPrimLengthForMinInput((PrimitiveTypeBinding)primitiveType.resolveTypeBinding()));
                        }
                        return false;
                    }
                });
                return false;
            }
        });
        return length[0];
    }
}

