/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.FieldContentValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MsgKeyPropertyForFormFieldValidator
extends FieldContentValidationAnnotationTypeBinding {
    IAnnotationTypeBinding annotationType;
    String canonicalAnnotationName;

    public MsgKeyPropertyForFormFieldValidator(IAnnotationTypeBinding annotationType, String canonicalAnnotationName) {
        super(InternUtil.internCaseSensitive((String)"XXXMsgKey for form field rule"));
        this.annotationType = annotationType;
        this.canonicalAnnotationName = canonicalAnnotationName;
    }

    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(this.annotationType.getName());
        if (annotationBinding != null && annotationBinding.getValue() != null && containerBinding != null && 7 == containerBinding.getKind()) {
            boolean valueValid;
            try {
                int valueAsInt = Integer.parseInt(annotationBinding.getValue().toString());
                valueValid = valueAsInt >= -9999 && valueAsInt <= 9999;
            }
            catch (NumberFormatException numberFormatException) {
                valueValid = false;
            }
            if (!valueValid) {
                problemRequestor.acceptProblem(errorNode, 5396, new String[]{this.canonicalAnnotationName, canonicalContainerName, containerBinding.getDeclaringPart().getCaseSensitiveName()});
            }
        }
    }
}

