/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;

public class RetrieveViewHelperValidator
implements IValueValidationRule {
    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        FunctionBinding function;
        if (annotationBinding.getValue() instanceof FunctionBinding && !this.isValidRetrieveViewHelperFunction(function = (FunctionBinding)annotationBinding.getValue())) {
            problemRequestor.acceptProblem(errorNode, 3321, new String[]{function.getName()});
        }
    }

    public boolean isValidRetrieveViewHelperFunction(FunctionBinding function) {
        if (function.getParameters().size() != 0) {
            return false;
        }
        if (function.getReturnType() == null) {
            return false;
        }
        return function.getReturnType() == this.getStringType();
    }

    private PrimitiveTypeBinding getStringType() {
        return PrimitiveTypeBinding.getInstance(Primitive.STRING);
    }
}

