/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.AnnotationValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SQLDataCodeAnnotationValidator
extends AnnotationValidationAnnotationTypeBinding {
    public static AnnotationValidationAnnotationTypeBinding INSTANCE = new SQLDataCodeAnnotationValidator();
    protected IAnnotationTypeBinding annotationType;
    protected String canonicalAnnotationName;

    private SQLDataCodeAnnotationValidator() {
        super(InternUtil.internCaseSensitive((String)"SQLDataCodeAnnotationValidator"));
    }

    @Override
    public void validate(Node errorNode, Node target, ITypeBinding targetTypeBinding, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"sqlDataCode"));
        if (annotationBinding.getValue() != null && annotationBinding.getValue() != IBinding.NOT_FOUND_BINDING && targetTypeBinding != null && IBinding.NOT_FOUND_BINDING != targetTypeBinding) {
            targetTypeBinding.getName();
            if (3 == targetTypeBinding.getKind()) {
                Primitive prim = ((PrimitiveTypeBinding)targetTypeBinding).getPrimitive();
                int primType = prim.getType();
                prim.getName();
                boolean primTypeIsValid = true;
                try {
                    int value = Integer.parseInt(annotationBinding.getValue().toString());
                    switch (primType) {
                        case 4: {
                            primTypeIsValid = value == 448 || value == 449 || value == 452 || value == 453 || value == 456 || value == 457 || value == 384 || value == 385 || value == 388 || value == 389 || value == 392 || value == 393;
                            break;
                        }
                        case 5: {
                            primTypeIsValid = value == 464 || value == 465 || value == 468 || value == 469 || value == 472 || value == 473;
                            break;
                        }
                        case 20: {
                            primTypeIsValid = value == 464 || value == 465 || value == 468 || value == 469 || value == 472 || value == 473 || value == 385 || value == 389 || value == 393 || value == 384 || value == 388 || value == 392;
                            break;
                        }
                        case 9: {
                            break;
                        }
                        case 19: {
                            primTypeIsValid = value == 468 || value == 469 || value == 385 || value == 389 || value == 393 || value == 384 || value == 388 || value == 392;
                            break;
                        }
                        default: {
                            problemRequestor.acceptProblem(errorNode, 3100, new String[]{StatementValidator.getShortTypeString(targetTypeBinding)});
                            break;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    primTypeIsValid = false;
                }
                if (!primTypeIsValid) {
                    problemRequestor.acceptProblem(errorNode, 3099, new String[]{annotationBinding.getValue().toString(), StatementValidator.getShortTypeString(targetTypeBinding)});
                }
            } else {
                problemRequestor.acceptProblem(errorNode, 3100, new String[]{StatementValidator.getShortTypeString(targetTypeBinding)});
            }
        }
    }
}

