/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AbstractSelectedItemAnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.SelectTypeForPageItemFieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SelectedValueItemAnnotationValidator
extends AbstractSelectedItemAnnotationValidator {
    public SelectedValueItemAnnotationValidator() {
        super("selectedValueItem");
    }

    private boolean isCompatible(ITypeBinding selectedItemType, ITypeBinding selectionRecieverType, ICompilerOptions compilerOptions) {
        if (2 == selectedItemType.getKind()) {
            selectedItemType = ((ArrayTypeBinding)selectedItemType).getElementType();
        }
        if (2 == selectionRecieverType.getKind()) {
            selectionRecieverType = ((ArrayTypeBinding)selectionRecieverType).getElementType();
        }
        return this.typesMatch(selectionRecieverType, selectedItemType, compilerOptions);
    }

    @Override
    protected void targetIsDataTableOrRecordArray(Node errorNode, IBinding targetBinding, ITypeBinding targetTypeBinding, ITypeBinding selectedItemType, IDataBinding value, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding valueType;
        IDataBinding valueItem = this.getValueItem(targetBinding, targetTypeBinding);
        if (valueItem != null && (valueType = valueItem.getType()) != null && IBinding.NOT_FOUND_BINDING != valueType && !this.isCompatible(selectedItemType, valueType, compilerOptions)) {
            problemRequestor.acceptProblem(errorNode, 7682, new String[]{StatementValidator.getTypeString(selectedItemType), value.getCaseSensitiveName(), StatementValidator.getTypeString(valueType), valueItem.getCaseSensitiveName()});
        }
    }

    private boolean typesMatch(ITypeBinding type1, ITypeBinding type2, ICompilerOptions compilerOptions) {
        return SelectTypeForPageItemFieldValidator.typesIdenticalOrAreCharAndString(type1, type2, compilerOptions);
    }

    @Override
    protected void targetIsPrimitiveArray(Node errorNode, IBinding targetBinding, ITypeBinding targetTypeBinding, ITypeBinding selectedItemType, IDataBinding value, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!this.isCompatible(selectedItemType, targetTypeBinding, compilerOptions)) {
            problemRequestor.acceptProblem(errorNode, 7683, new String[]{StatementValidator.getTypeString(selectedItemType), value.getCaseSensitiveName(), StatementValidator.getTypeString(targetTypeBinding), targetBinding.getCaseSensitiveName()});
        }
    }

    private IDataBinding getValueItem(IBinding targetBinding, ITypeBinding targetTypeBinding) {
        IAnnotationBinding selectionListAnnotation = targetBinding.getAnnotation(new String[]{"egl", "ui"}, "selectionList");
        if (selectionListAnnotation != null) {
            IAnnotationBinding valueItemAnnotation = (IAnnotationBinding)selectionListAnnotation.findData(InternUtil.intern((String)"valueItem"));
            if (IBinding.NOT_FOUND_BINDING != valueItemAnnotation) {
                Object value = valueItemAnnotation.getValue();
                return value instanceof Name ? ((Name)value).resolveDataBinding() : null;
            }
            return this.getDefaultValueItem(targetTypeBinding);
        }
        return this.getDefaultValueItem(targetTypeBinding);
    }

    private IDataBinding getDefaultValueItem(ITypeBinding targetTypeBinding) {
        List fields = null;
        ITypeBinding baseType = targetTypeBinding.getBaseType();
        switch (baseType.getKind()) {
            case 5: 
            case 6: {
                fields = ((FixedStructureBinding)baseType).getStructureItems();
                break;
            }
            case 7: {
                fields = ((FlexibleRecordBinding)baseType).getDeclaredFields();
            }
        }
        if (fields == null || fields.size() == 0) {
            return null;
        }
        if (fields.size() == 1) {
            return (IDataBinding)fields.get(0);
        }
        return (IDataBinding)fields.get(1);
    }
}

