/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IInvocationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ThrowsInvocationValidator
implements IInvocationValidationRule {
    private static final String JAVAOBJECTECXPTION = InternUtil.intern((String)"JavaObjectException");
    private static final String[] EGLXJAVA = InternUtil.intern((String[])new String[]{"eglx", "java"});
    private List<IPartBinding> validExceptions = new ArrayList<IPartBinding>();

    @Override
    public void validate(Node node, IBinding binding, IPartBinding declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!Binding.isValidBinding(binding) || !Binding.isValidBinding(declaringPart)) {
            return;
        }
        IPartBinding joe = declaringPart.getEnvironment().getPartBinding(EGLXJAVA, JAVAOBJECTECXPTION);
        this.buildAllValidExceptions(this.validExceptions, joe);
        if (!this.isInTryCatchException(node)) {
            problemRequestor.acceptProblem(node, 3428, new String[0]);
        }
    }

    private boolean isInTryCatchException(Node node) {
        TryStatement tryStmt = this.getTryStatement(node);
        if (tryStmt == null) {
            return false;
        }
        if (this.hasCatchException(tryStmt)) {
            return true;
        }
        return this.isInTryCatchException(tryStmt.getParent());
    }

    private boolean hasCatchException(TryStatement tryStmt) {
        for (OnExceptionBlock exBlock : tryStmt.getOnExceptionBlocks()) {
            Type type = exBlock.getExceptionType();
            if (type == null || !this.validExceptions.contains(type.resolveTypeBinding())) continue;
            return true;
        }
        return false;
    }

    private TryStatement getTryStatement(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof TryStatement) {
            return (TryStatement)node;
        }
        if (node instanceof OnExceptionBlock) {
            if (node.getParent() != null) {
                return this.getTryStatement(node.getParent().getParent());
            }
            return null;
        }
        return this.getTryStatement(node.getParent());
    }

    private void buildAllValidExceptions(List<IPartBinding> list, IPartBinding baseException) {
        if (!Binding.isValidBinding(baseException) || list.contains(baseException)) {
            return;
        }
        list.add(baseException);
        if (baseException.getKind() == 28) {
            ExternalTypeBinding et = (ExternalTypeBinding)baseException;
            list.addAll(et.getExtendedTypes());
        }
        this.buildAllValidExceptions(list, ((PartBinding)baseException).getDefaultSuperType());
    }
}

