/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.StructureItem;

public class TypeNameUtility {
    public static String getName(Node node) {
        final String[] name = new String[1];
        AbstractASTPartVisitor visitor = new AbstractASTPartVisitor(){

            @Override
            public void visitPart(Part part) {
                name[0] = part.getName().getCanonicalName();
            }

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                name[0] = classDataDeclaration.getType().getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                name[0] = functionDataDeclaration.getType().getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                if (structureItem.hasType()) {
                    name[0] = structureItem.getType().getCanonicalName();
                }
                return false;
            }

            @Override
            public boolean visit(NameType nameType) {
                name[0] = nameType.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(PrimitiveType primitiveType) {
                name[0] = primitiveType.toString();
                return false;
            }
        };
        if (node != null) {
            node.accept(visitor);
        }
        if (name[0] == null) {
            Part part = TypeNameUtility.getEnclosingPart(node);
            if (part != null) {
                return part.getName().getCanonicalName();
            }
            return "";
        }
        return name[0];
    }

    public static ITypeBinding getType(Node node) {
        final ITypeBinding[] type = new ITypeBinding[1];
        AbstractASTPartVisitor visitor = new AbstractASTPartVisitor(){

            @Override
            public void visitPart(Part part) {
                type[0] = (ITypeBinding)part.getName().resolveBinding();
            }

            @Override
            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                type[0] = classDataDeclaration.getType().resolveTypeBinding();
                return false;
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                type[0] = functionDataDeclaration.getType().resolveTypeBinding();
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                if (structureItem.hasType()) {
                    type[0] = structureItem.getType().resolveTypeBinding();
                }
                return false;
            }

            @Override
            public boolean visit(NameType nameType) {
                type[0] = nameType.resolveTypeBinding();
                return false;
            }

            @Override
            public boolean visit(PrimitiveType primitiveType) {
                type[0] = primitiveType.resolveTypeBinding();
                return false;
            }
        };
        node.accept(visitor);
        return type[0];
    }

    private static Part getEnclosingPart(Node node) {
        if (node == null || node instanceof Part) {
            return (Part)node;
        }
        return TypeNameUtility.getEnclosingPart(node.getParent());
    }
}

