/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.name;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.compiler.core.EGLSQLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameParser;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameToken;

public class EGLNameValidator {
    public static String[] keywords = EGLKeywordHandler.getKeywordNames();
    public static Set windowsReservedFileNames = new HashSet();
    public static final int DEFAULT = 0;
    public static final int PART = 1;
    public static final int PROGRAM = 2;
    public static final int PROGRAM_EXTERNAL_NAME = 3;
    public static final int FUNCTION = 4;
    public static final int RECORD_FILE_NAME = 5;
    public static final int RECORD = 6;
    public static final int STRUCTURE = 7;
    public static final int DATATABLE = 8;
    public static final int TABLE_EXTERNAL_NAME = 9;
    public static final int DATAITEM = 10;
    public static final int BUILD_DESCRIPTOR = 11;
    public static final int LINKAGE_OPTIONS = 12;
    public static final int RESOURCE_ASSOCIATIONS = 13;
    public static final int BIND_CONTROL = 14;
    public static final int LINK_EDIT = 15;
    public static final int TYPEDEF = 16;
    public static final int TABLE_GENERATION = 17;
    public static final int SYMBOLIC_PARAMETER = 18;
    public static final int RESULT_SET_ID = 19;
    public static final int FORMGROUP = 20;
    public static final int FORM = 21;
    public static final int LIBRARY = 22;
    public static final int PAGEHANDLER = 23;
    public static final int RECORD_REFERENCE = 24;
    public static final int FUNCTION_REFERENCE = 25;
    public static final int DATAITEM_REFERENCE = 26;
    public static final int PROGRAM_REFERENCE = 27;
    public static final int PROPERTY_ALIAS = 28;
    public static final int PROPERTY_MSGTABLEPREFIX = 29;
    public static final int PACKAGE = 30;
    public static final int FILENAME = 31;
    public static final int PART_REFERENCE = 32;
    public static final int IDENTIFIER = 33;
    public static final int KEYITEM = 34;
    public static final int TABLENAME = 35;
    public static final int TABLENAMEVARIABLES = 36;
    public static final int LENGTHITEM = 37;
    public static final int HANDLER = 38;
    public static final int INTO_CLAUSE_DATAITEM_REFERENCE = 39;
    public static final int DELEGATE = 40;
    public static final int INTERNALFIELD = 41;
    public static final int substring = 0;
    public static final int subscript = 1;
    public static final int PART_LENGTH = 128;
    public static final int PROGRAM_LENGTH = 128;
    public static final int DELEGATE_LENGTH = 128;
    public static final int PROGRAM_EXTERNAL_NAME_LENGTH = 128;
    public static final int RECORD_FILE_NAME_LENGTH = 8;
    public static final int FUNCTION_LENGTH = 128;
    public static final int RECORD_LENGTH = 128;
    public static final int STRUCTURE_LENGTH = 128;
    public static final int DATATABLE_LENGTH = 128;
    public static final int TABLE_EXTERNAL_NAME_LENGTH = 128;
    public static final int ITEM_LENGTH = 128;
    public static final int BUILD_DESCRIPTOR_LENGTH = 128;
    public static final int LINKAGE_OPTIONS_LENGTH = 128;
    public static final int RESOURCE_ASSOCIATIONS_LENGTH = 128;
    public static final int BIND_CONTROL_LENGTH = 128;
    public static final int LINK_EDIT_LENGTH = 128;
    public static final int TYPEDEF_LENGTH = 128;
    public static final int PARAMETER_LENGTH = 128;
    public static final int DECLARATION_LENGTH = 128;
    public static final int TABLE_GENERATION_LENGTH = 128;
    public static final int GLOBAL_IO_OBJECT_LENGTH = 128;
    public static final int SYMBOLIC_PARAMETER_LENGTH = 30;
    public static final int RESULT_SET_ID_LENGTH = 128;
    public static final int PROJECT_ID_LENGTH = 44;
    public static final int KEYITEM_LENGTH = 128;
    public static final int TABLENAME_LENGTH = 128;
    public static final int TABLENAMEVARIABLES_LENGTH = 128;
    public static final int LENGTHITEM_LENGTH = 128;
    public static final int FORMGROUP_LENGTH = 128;
    public static final int FORM_LENGTH = 128;
    public static final int LIBRARY_LENGTH = 128;
    public static final int PAGEHANDLER_LENGTH = 128;
    public static final int RECORD_REFERENCE_LENGTH = 128;
    public static final int FUNCTION_REFERENCE_LENGTH = 128;
    public static final int DATAITEM_REFERENCE_LENGTH = 128;
    public static final int PROGRAM_REFERENCE_LENGTH = 128;
    public static final int PROPERTY_ALIAS_LENGTH = 128;
    public static final int PROPERTY_MSGTABLEPREFIX_LENGTH = 125;
    public static final int PACKAGE_LENGTH = 128;
    public static final int FILENAME_LENGTH = 128;
    public static final int PART_REFERENCE_LENGTH = 128;
    public static final int IDENTIFIER_LENGTH = 128;
    public static final int HANDLER_LENGTH = 128;
    public static final int INTO_CLAUSE_ITEM_LENGTH = 128;
    public static final int INTERNALFIELD_LENGTH = 128;
    private static Hashtable partNameLengths;

    static {
        windowsReservedFileNames.add("aux");
        windowsReservedFileNames.add("clock$");
        windowsReservedFileNames.add("com1");
        windowsReservedFileNames.add("com2");
        windowsReservedFileNames.add("com3");
        windowsReservedFileNames.add("com4");
        windowsReservedFileNames.add("com5");
        windowsReservedFileNames.add("com6");
        windowsReservedFileNames.add("com7");
        windowsReservedFileNames.add("com8");
        windowsReservedFileNames.add("com9");
        windowsReservedFileNames.add("com9");
        windowsReservedFileNames.add("com9");
        windowsReservedFileNames.add("con");
        windowsReservedFileNames.add("lpt1");
        windowsReservedFileNames.add("lpt2");
        windowsReservedFileNames.add("lpt3");
        windowsReservedFileNames.add("lpt4");
        windowsReservedFileNames.add("lpt5");
        windowsReservedFileNames.add("lpt6");
        windowsReservedFileNames.add("lpt7");
        windowsReservedFileNames.add("lpt8");
        windowsReservedFileNames.add("lpt9");
        windowsReservedFileNames.add("nul");
        windowsReservedFileNames.add("prn");
        partNameLengths = new Hashtable();
        partNameLengths.put(new Integer(1), new Integer(128));
        partNameLengths.put(new Integer(2), new Integer(128));
        partNameLengths.put(new Integer(40), new Integer(128));
        partNameLengths.put(new Integer(3), new Integer(128));
        partNameLengths.put(new Integer(4), new Integer(128));
        partNameLengths.put(new Integer(6), new Integer(128));
        partNameLengths.put(new Integer(5), new Integer(8));
        partNameLengths.put(new Integer(7), new Integer(128));
        partNameLengths.put(new Integer(8), new Integer(128));
        partNameLengths.put(new Integer(9), new Integer(128));
        partNameLengths.put(new Integer(10), new Integer(128));
        partNameLengths.put(new Integer(11), new Integer(128));
        partNameLengths.put(new Integer(12), new Integer(128));
        partNameLengths.put(new Integer(13), new Integer(128));
        partNameLengths.put(new Integer(14), new Integer(128));
        partNameLengths.put(new Integer(15), new Integer(128));
        partNameLengths.put(new Integer(16), new Integer(128));
        partNameLengths.put(new Integer(17), new Integer(128));
        partNameLengths.put(new Integer(18), new Integer(30));
        partNameLengths.put(new Integer(19), new Integer(128));
        partNameLengths.put(new Integer(20), new Integer(128));
        partNameLengths.put(new Integer(21), new Integer(128));
        partNameLengths.put(new Integer(22), new Integer(128));
        partNameLengths.put(new Integer(23), new Integer(128));
        partNameLengths.put(new Integer(24), new Integer(128));
        partNameLengths.put(new Integer(25), new Integer(128));
        partNameLengths.put(new Integer(26), new Integer(128));
        partNameLengths.put(new Integer(27), new Integer(128));
        partNameLengths.put(new Integer(28), new Integer(128));
        partNameLengths.put(new Integer(29), new Integer(125));
        partNameLengths.put(new Integer(30), new Integer(128));
        partNameLengths.put(new Integer(31), new Integer(128));
        partNameLengths.put(new Integer(32), new Integer(128));
        partNameLengths.put(new Integer(33), new Integer(128));
        partNameLengths.put(new Integer(34), new Integer(128));
        partNameLengths.put(new Integer(35), new Integer(128));
        partNameLengths.put(new Integer(36), new Integer(128));
        partNameLengths.put(new Integer(37), new Integer(128));
        partNameLengths.put(new Integer(38), new Integer(128));
        partNameLengths.put(new Integer(39), new Integer(128));
        partNameLengths.put(new Integer(41), new Integer(128));
    }

    public static void validate(Name eglName, int nameType, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        EGLNameValidator.validate(eglName.getCanonicalName(), nameType, (IProblemRequestor)new OffsetProblemRequestor(eglName.getOffset(), problemRequestor), compilerOptions);
    }

    public static void validate(String input, int nameType, IProblemRequestor problemRequestor, Node nodeForErrors, ICompilerOptions compilerOptions) {
        EGLNameValidator.validate(input, nameType, (IProblemRequestor)new NodeProblemRequestor(nodeForErrors, problemRequestor), compilerOptions);
    }

    public static void validate(String input, int nameType, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        String type = null;
        EGLNameParser nameParser = new EGLNameParser(input, true, nameType == 5, problemRequestor, compilerOptions);
        Iterator simpleNames = null;
        EGLNameToken nextName2 = null;
        int start = 0;
        if (nameType == 0) {
            nameType = 1;
        }
        switch (nameType) {
            case 25: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                int ii = start = 0;
                while (ii < nameParser.getNames().size()) {
                    nextName2 = (EGLNameToken)nameParser.getNames().get(ii);
                    if (nextName2.getType() == 6) {
                        EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                        EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                        EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    }
                    ++ii;
                }
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 24: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                int ii = start = 0;
                while (ii < nameParser.getNames().size()) {
                    nextName2 = (EGLNameToken)nameParser.getNames().get(ii);
                    if (nextName2.getType() == 6) {
                        EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                        EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                        EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    }
                    ++ii;
                }
                EGLNameValidator.validateSubscripts(input, nameParser.getSubscripts(), nameType, problemRequestor, false);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 39: {
                break;
            }
            case 26: {
                break;
            }
            case 32: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                int ii = start = 0;
                while (ii < nameParser.getNames().size()) {
                    nextName2 = (EGLNameToken)nameParser.getNames().get(ii);
                    if (nextName2.getType() == 6) {
                        EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                        EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                        EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    }
                    ++ii;
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3356, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 16: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3352, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 34: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3360, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 37: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3361, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 35: {
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    EGLNameValidator.callIsSQLClauseKeyword(nextName2, input, problemRequestor);
                }
                EGLNameValidator.validateSubscripts(input, nameParser.getSubscripts(), nameType, problemRequestor, true);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 36: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                int ii = start = 0;
                while (ii < nameParser.getNames().size()) {
                    nextName2 = (EGLNameToken)nameParser.getNames().get(ii);
                    if (nextName2.getType() == 6) {
                        EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                        EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                        EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                        EGLNameValidator.callIsSQLClauseKeyword(nextName2, input, problemRequestor);
                    }
                    ++ii;
                }
                EGLNameValidator.validateSubscripts(input, nameParser.getSubscripts(), nameType, problemRequestor, true);
                EGLNameValidator.validateSubstring(input, nameParser.getSubstrings(), nameType, problemRequestor, true);
                break;
            }
            case 28: {
                if (input.indexOf(32) != -1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3066, new String[]{input});
                } else {
                    EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                    if (nameParser.getNames().size() > 1) {
                        problemRequestor.acceptProblem(0, input.length(), 2, 3365, new String[]{input});
                    } else {
                        for (EGLNameToken nextName2 : nameParser.getNames()) {
                            if (nextName2.getType() != 6) continue;
                            EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                            EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                        }
                    }
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3353, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 29: {
                if (input.indexOf(32) != -1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3066, new String[]{input});
                } else {
                    EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                    for (EGLNameToken nextName2 : nameParser.getNames()) {
                        if (nextName2.getType() != 6) continue;
                        EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                        EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                    }
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3354, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 41: {
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                if (nameType == 4) {
                    type = "function";
                } else if (nameType == 6) {
                    type = "record";
                } else if (nameType == 10) {
                    type = "dataItem";
                }
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                if (nameParser.getNames().size() > 1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3042, new String[]{type, input});
                }
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callIsWindowsReservedFileName(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                if (nameParser.getSubscripts().size() > 0) {
                    problemRequestor.acceptProblem(((EGLNameToken)nameParser.getFirstSubscript().get(0)).getOffset(), input.length(), 2, 3037, new String[]{type, input});
                }
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 5: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                if (nameParser.getNames().size() > 1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3359, new String[]{input});
                } else {
                    for (EGLNameToken nextName2 : nameParser.getNames()) {
                        if (nextName2.getType() != 6) continue;
                        EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateFileNameCharacters(nextName2, input, problemRequestor);
                        EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                    }
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3357, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 30: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.validatePackageName(nextName2.getText(), input, problemRequestor);
                    EGLNameValidator.callValidatePkgNameCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callIsWindowsReservedFileName(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callMildValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.validatePackageName(input, input, problemRequestor);
                EGLNameValidator.restrictSubscripts(nameParser, input, 3357, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 33: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                if (nameParser.getNames().size() > 1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3366, new String[]{input});
                }
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3355, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 31: {
                if (input.indexOf(32) != -1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3066, new String[]{input});
                }
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callIsWindowsReservedFileName(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3358, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            case 2: 
            case 8: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 38: 
            case 40: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                if (nameParser.getNames().size() > 1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3359, new String[]{input});
                }
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callIsWindowsReservedFileName(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3358, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                if (input.indexOf(45) <= 0) break;
                problemRequestor.acceptProblem(input.indexOf(45), input.length(), 2, 3344);
                break;
            }
            case 1: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                if (nameParser.getNames().size() > 1) {
                    problemRequestor.acceptProblem(0, input.length(), 2, 3359, new String[]{input});
                }
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.restrictSubscripts(nameParser, input, 3358, problemRequestor);
                EGLNameValidator.restrictSubstrings(nameParser, input, problemRequestor);
                break;
            }
            default: {
                EGLNameValidator.validateNameTokenSequence(nameParser.getNames(), input, problemRequestor);
                for (EGLNameToken nextName2 : nameParser.getNames()) {
                    if (nextName2.getType() != 6) continue;
                    EGLNameValidator.callIsKeyword(nextName2, input, problemRequestor);
                    EGLNameValidator.callStartsWithEZE(nextName2, input, problemRequestor);
                    EGLNameValidator.callValidateCharacters(nextName2, input, problemRequestor, compilerOptions);
                    EGLNameValidator.callValidateLength(nextName2, input, nameType, problemRequestor);
                }
                EGLNameValidator.validateSubscripts(input, nameParser.getSubscripts(), nameType, problemRequestor, false);
                EGLNameValidator.validateSubstring(input, nameParser.getSubstrings(), nameType, problemRequestor, false);
            }
        }
    }

    private static void validateNameTokenSequence(ArrayList names, String input, IProblemRequestor problemRequestor) {
        EGLNameToken currentToken = null;
        boolean notDot = false;
        boolean dot = true;
        boolean prevTokenType = notDot;
        int ii = 0;
        while (ii < names.size()) {
            currentToken = (EGLNameToken)names.get(ii);
            switch (currentToken.getType()) {
                case 3: {
                    if (ii == 0 || prevTokenType == dot || ii == names.size() - 1) {
                        problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3349, new String[]{currentToken.getText(), input});
                    }
                    prevTokenType = dot;
                    break;
                }
                case 6: {
                    if (ii > 0 && prevTokenType != dot) {
                        problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3349, new String[]{currentToken.getText(), input});
                    }
                    prevTokenType = notDot;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3349, new String[]{currentToken.getText(), input});
                    prevTokenType = notDot;
                }
            }
            ++ii;
        }
    }

    private static void validateSubNameTokenSequence(ArrayList names, String input, IProblemRequestor problemRequestor) {
        EGLNameToken currentToken = null;
        boolean notDot = false;
        boolean dot = true;
        boolean prevTokenType = notDot;
        int ii = 0;
        while (ii < names.size()) {
            currentToken = (EGLNameToken)names.get(ii);
            switch (currentToken.getType()) {
                case 3: {
                    if (ii == 0 || prevTokenType == dot || ii == names.size() - 1) {
                        problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3349, new String[]{currentToken.getText(), input});
                    }
                    prevTokenType = dot;
                    break;
                }
                case 6: {
                    if (ii > 0 && prevTokenType != dot) {
                        problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3349, new String[]{currentToken.getText(), input});
                    }
                    prevTokenType = notDot;
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3346, new String[]{currentToken.getText(), input});
                    prevTokenType = notDot;
                    break;
                }
                default: {
                    problemRequestor.acceptProblem(currentToken.getOffset(), currentToken.getOffset() + currentToken.getText().length(), 2, 3345, new String[]{currentToken.getText(), input});
                    prevTokenType = notDot;
                }
            }
            ++ii;
        }
    }

    private static void validatePackageName(String name, String input, IProblemRequestor problemRequestor) {
    }

    private static void validateSubscripts(String input, ArrayList subscripts, int nameType, IProblemRequestor problemRequestor, boolean isSQL) {
        ArrayList currentSubscript = null;
        int ii = 0;
        while (ii < subscripts.size()) {
            currentSubscript = (ArrayList)subscripts.get(ii);
            if (currentSubscript.size() != 1 || ((EGLNameToken)currentSubscript.get(0)).getType() != 8 && ((EGLNameToken)currentSubscript.get(0)).getType() != 10) {
                EGLNameValidator.validateSubNameTokenSequence(currentSubscript, input, problemRequestor);
            }
            ++ii;
        }
    }

    private static void validateSubstring(String input, ArrayList substrings, int nameType, IProblemRequestor problemRequestor, boolean isSQL) {
        ArrayList currentSubstring = null;
        int ii = 0;
        while (ii < substrings.size()) {
            currentSubstring = (ArrayList)substrings.get(ii);
            if (currentSubstring.size() != 1 || ((EGLNameToken)currentSubstring.get(0)).getType() != 8) {
                EGLNameValidator.validateSubNameTokenSequence(currentSubstring, input, problemRequestor);
            }
            ++ii;
        }
    }

    private static void callValidateCharacters(EGLNameToken name, String input, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!EGLNameValidator.validateCharacters(name.getText(), compilerOptions)) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3002, new String[]{name.getText()});
        }
    }

    private static void callValidatePkgNameCharacters(EGLNameToken name, String input, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!EGLNameValidator.validatePkgNameCharacters(name.getText(), compilerOptions)) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3002, new String[]{name.getText()});
        }
    }

    private static void callMildValidateCharacters(EGLNameToken name, String input, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (!EGLNameValidator.mildValidateCharacters(name.getText(), compilerOptions)) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3002, new String[]{name.getText()});
        }
    }

    private static void callValidateFileNameCharacters(EGLNameToken name, String input, IProblemRequestor problemRequestor) {
        if (!EGLNameValidator.fileNameValidateCharacters(name.getText())) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3002, new String[]{name.getText()});
        }
    }

    private static void callIsKeyword(EGLNameToken name, String input, IProblemRequestor problemRequestor) {
        if (EGLNameValidator.isKeyword(name.getText())) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3019, new String[]{name.getText()});
        }
    }

    private static void callIsWindowsReservedFileName(EGLNameToken name, String input, IProblemRequestor problemRequestor) {
        if (EGLNameValidator.isWindowsReservedFileName(name.getText())) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3019, new String[]{name.getText()});
        }
    }

    private static void callIsSQLClauseKeyword(EGLNameToken name, String input, IProblemRequestor problemRequestor) {
        if (EGLSQLKeywordHandler.getSQLKeywordNamesToLowerCaseAsSet().contains(name.getText().toLowerCase(Locale.ENGLISH))) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 6597, new String[]{name.getText(), EGLSQLKeywordHandler.getSQLClauseKeywordNamesCommaSeparatedString()});
        }
    }

    private static void callValidateLength(EGLNameToken name, String input, int nameType, IProblemRequestor problemRequestor) {
        if (name.getText().length() > (Integer)partNameLengths.get(new Integer(nameType))) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3001, new String[]{name.getText(), String.valueOf(name.getText().length()), String.valueOf(partNameLengths.get(new Integer(nameType)))});
        }
    }

    private static void callStartsWithEZE(EGLNameToken name, String input, IProblemRequestor problemRequestor) {
        if (EGLNameValidator.startsWithEZE(name.getText())) {
            problemRequestor.acceptProblem(name.getOffset(), name.getOffset() + name.getText().length(), 2, 3003, new String[]{name.getText()});
        }
    }

    public static boolean validateCharacters(String name, ICompilerOptions compilerOptions) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean validatePkgNameCharacters(String name, ICompilerOptions compilerOptions) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        return name.charAt(0) != '@' && name.charAt(0) != '#';
    }

    public static boolean mildValidateCharacters(String name, ICompilerOptions compilerOptions) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean strictValidateCharacters(String name) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isLetterOrDigit(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean fileNameValidateCharacters(String name) {
        if (name == null) {
            return false;
        }
        if (name == "") {
            return true;
        }
        if (!(Character.isLetter(name.charAt(0)) || Character.toString(name.charAt(0)).equalsIgnoreCase("#") || Character.toString(name.charAt(0)).equalsIgnoreCase("$") || Character.toString(name.charAt(0)).equalsIgnoreCase("@"))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!(Character.isLetterOrDigit(name.charAt(i)) || Character.toString(name.charAt(i)).equalsIgnoreCase("#") || Character.toString(name.charAt(i)).equalsIgnoreCase("$") || Character.toString(name.charAt(i)).equalsIgnoreCase("@"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isKeyword(String name) {
        return EGLKeywordHandler.getKeywordHashSet().contains(name.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isWindowsReservedFileName(String name) {
        return windowsReservedFileNames.contains(name.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithEZE(String name) {
        if (name.length() < 3) {
            return false;
        }
        return name.toUpperCase().startsWith("EZE");
    }

    private static void restrictSubscripts(EGLNameParser nameParser, String input, int problemKind, IProblemRequestor problemRequestor) {
        ArrayList firstSubscript;
        if (nameParser.getSubscripts().size() > 0 && !(firstSubscript = nameParser.getFirstSubscript()).isEmpty()) {
            problemRequestor.acceptProblem(((EGLNameToken)firstSubscript.get(0)).getOffset(), input.length(), 2, problemKind, new String[]{input});
        }
    }

    private static void restrictSubstrings(EGLNameParser nameParser, String input, IProblemRequestor problemRequestor) {
        if (nameParser.getSubstrings().size() > 0) {
            problemRequestor.acceptProblem(((EGLNameToken)nameParser.getFirstSubscript().get(0)).getOffset(), input.length(), 2, 3348, new String[]{input});
        }
    }

    private static class NodeProblemRequestor
    extends DefaultProblemRequestor {
        private Node node;
        private IProblemRequestor problemRequestor;

        public NodeProblemRequestor(Node node, IProblemRequestor problemRequestor) {
            this.node = node;
            this.problemRequestor = problemRequestor;
        }

        @Override
        public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
            if (severity == 2) {
                this.setHasError(true);
            }
            this.problemRequestor.acceptProblem(this.node, problemKind, severity, inserts);
        }

        @Override
        public boolean shouldReportProblem(int problemKind) {
            return this.problemRequestor.shouldReportProblem(problemKind);
        }
    }

    private static class OffsetProblemRequestor
    extends DefaultProblemRequestor {
        int offset;
        private IProblemRequestor problemRequestor;

        public OffsetProblemRequestor(int offset, IProblemRequestor problemRequestor) {
            this.offset = offset;
            this.problemRequestor = problemRequestor;
        }

        @Override
        public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
            if (severity == 2) {
                this.setHasError(true);
            }
            this.problemRequestor.acceptProblem(startOffset + this.offset, endOffset + this.offset, severity, problemKind, inserts);
        }

        @Override
        public boolean shouldReportProblem(int problemKind) {
            return this.problemRequestor.shouldReportProblem(problemKind);
        }
    }
}

