/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.AmbiguousDataBinding;
import org.eclipse.edt.compiler.binding.AnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.EGLSQLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FixedStructureValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FixedRecordValidator
extends FixedStructureValidator {
    private static final Set PRIMITIVES_NOT_ALLOWED_IN_SQL_RECORDS = new HashSet<Primitive>(Arrays.asList(Primitive.MBCHAR));
    private static final Set PRIMITIVES_NOT_ALLOWED_IN_VGUI_RECORDS = new HashSet<Primitive>(Arrays.asList(Primitive.DATE, Primitive.TIME, Primitive.TIMESTAMP, Primitive.MONTHSPAN_INTERVAL, Primitive.FLOAT, Primitive.MONEY, Primitive.SECONDSPAN_INTERVAL));
    private List validationOrderValues = new ArrayList();
    private Record recordNode;
    private java.lang.Boolean recordIsSQLJoinRecord;

    public FixedRecordValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(problemRequestor, compilerOptions);
    }

    @Override
    public boolean visit(Record record) {
        this.recordNode = record;
        this.canonicalStructureName = record.getName().getCanonicalName();
        this.structureBinding = (FixedStructureBinding)record.getName().resolveBinding();
        this.getRecordNameValidator().validate(record.getName());
        this.sItemValidatorFactory = this.getItemValidatorFactory();
        EGLNameValidator.validate(record.getName(), 6, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(record);
        return true;
    }

    @Override
    public void endVisit(Record record) {
        this.checkValidationOrderValues();
        if (this.structureBinding != null) {
            this.getItemValidatorFactory().createStructureItemValidator().validatePart(this.structureBinding);
        }
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        super.visit(settingsBlock);
        return false;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        super.visit(structureItem);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(structureItem);
        return false;
    }

    private RecordNameValidator getRecordNameValidator() {
        if (this.structureBinding != null) {
            if (AbstractBinder.annotationIs(this.structureBinding.getSubType(), new String[]{"egl", "io", "sql"}, "SQLRecord")) {
                return new SQLRecordNameValidator();
            }
            if (AbstractBinder.annotationIs(this.structureBinding.getSubType(), new String[]{"egl", "io", "dli"}, "DLISegment")) {
                return new DLISegmentRecordNameValidator();
            }
        }
        return new DefaultRecordNameValidator(null, null);
    }

    private FixedStructureValidator.StructureItemValidatorFactory getItemValidatorFactory() {
        if (this.structureBinding != null) {
            if (AbstractBinder.annotationIs(this.structureBinding.getSubType(), new String[]{"egl", "io", "sql"}, "SQLRecord")) {
                return new SQLStructureItemValidatorFactory();
            }
            if (AbstractBinder.annotationIs(this.structureBinding.getSubType(), new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord")) {
                return new VGUIStructureItemValidatorFactory();
            }
        }
        return new DefaultFixedRecordItemValidatorFactory();
    }

    private void checkValidationOrderValues() {
        if (!this.validationOrderValues.isEmpty()) {
            Collections.sort(this.validationOrderValues);
            Iterator iter = this.validationOrderValues.iterator();
            int valOrder = (Integer)iter.next();
            if (valOrder < 1) {
                this.problemRequestor.acceptProblem((Node)this.recordNode.getName(), 7796, new String[0]);
            }
            while (iter.hasNext()) {
                int nextOrder = (Integer)iter.next();
                if (nextOrder <= valOrder) {
                    this.problemRequestor.acceptProblem(this.recordNode.getName(), 7796);
                    break;
                }
                valOrder = nextOrder;
            }
        }
    }

    private boolean getRecordIsSQLJoinRecord() {
        if (this.recordIsSQLJoinRecord == null) {
            IAnnotationBinding aBinding;
            this.recordIsSQLJoinRecord = java.lang.Boolean.FALSE;
            if (this.structureBinding != null && AbstractBinder.annotationIs(this.structureBinding.getSubType(), new String[]{"egl", "io", "sql"}, "SQLRecord") && (aBinding = this.getField(this.structureBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord"), "tableNames")) != null && aBinding.getValue() != null && ((Object[])aBinding.getValue()).length > 1) {
                this.recordIsSQLJoinRecord = java.lang.Boolean.TRUE;
            }
        }
        return this.recordIsSQLJoinRecord;
    }

    private static boolean isValidDLIName(String name) {
        if (name.length() > 8) {
            return false;
        }
        if (name.length() != 0) {
            char ch = name.charAt(0);
            if (!Character.isLetter(ch) && ch != '@' && ch != '$' && ch != '#') {
                return false;
            }
            if (name.length() != 1) {
                int i = 1;
                while (i < name.length()) {
                    ch = name.charAt(i);
                    if (!Character.isLetter(ch) && !Character.isDigit(ch) && ch != '@' && ch != '$' && ch != '#') {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    private class DLISegmentRecordNameValidator
    extends DefaultRecordNameValidator {
        private DLISegmentRecordNameValidator() {
        }

        @Override
        void validate(Name recordName) {
            super.validate(recordName);
            if (FixedRecordValidator.this.structureBinding.getAnnotation(FixedRecordValidator.this.structureBinding.getSubType()).findData(InternUtil.intern((String)"segmentName")) == IBinding.NOT_FOUND_BINDING && !FixedRecordValidator.isValidDLIName(recordName.getCanonicalName())) {
                FixedRecordValidator.this.problemRequestor.acceptProblem((Node)FixedRecordValidator.this.recordNode.getName(), 7867, new String[]{recordName.getCanonicalName()});
            }
        }
    }

    private class DefaultFixedRecordItemValidator
    extends FixedStructureValidator.DefaultStructureItemValidator {
        public DefaultFixedRecordItemValidator() {
            super(FixedRecordValidator.this);
        }

        @Override
        public void validate(FixedStructureValidator.StructureItemInfo sItemInfo) {
            IAnnotationBinding aBinding;
            super.validate(sItemInfo);
            boolean itemIsLeaf = sItemInfo.binding.getChildren().isEmpty();
            boolean hasInitialzer = sItemInfo.structureItemNode.hasInitializer();
            if (itemIsLeaf) {
                Expression initializer;
                if (hasInitialzer && this.checkInitializerIsLiteral(initializer = sItemInfo.structureItemNode.getInitializer())) {
                    ArrayList occursDimensions = new ArrayList();
                    occursDimensions.addAll(sItemInfo.binding.getOccursDimensions());
                    this.checkInitializer(sItemInfo, occursDimensions, initializer);
                }
            } else if (sItemInfo.structureItemNode.hasInitializer()) {
                FixedRecordValidator.this.problemRequestor.acceptProblem(sItemInfo.structureItemNode.getInitializer(), 7753);
            }
            if (!this.isNullableIsAllowed() && (aBinding = sItemInfo.binding.getAnnotation(new String[]{"egl", "io", "sql"}, "IsSqlNullable")) != null && Boolean.YES == aBinding.getValue()) {
                FixedRecordValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 5076, new String[]{sItemInfo.canonicalName, FixedRecordValidator.this.canonicalStructureName});
            }
        }

        private boolean checkInitializerIsLiteral(final Expression initializerExpr) {
            final boolean[] result = new boolean[]{true};
            initializerExpr.accept(new AbstractASTExpressionVisitor(){

                @Override
                public boolean visit(UnaryExpression unaryExpression) {
                    return true;
                }

                @Override
                public void endVisitLiteral(LiteralExpression literal) {
                }

                @Override
                public void endVisit(BinaryExpression binaryExpression) {
                    if (!new AnnotationTypeBinding.IsStringLiteralChecker().isStringLiteral(binaryExpression)) {
                        this.endVisitExpression(binaryExpression);
                    }
                }

                @Override
                public void endVisit(UnaryExpression unaryExpression) {
                }

                @Override
                public void endVisitExpression(Expression expression) {
                    ((DefaultFixedRecordItemValidator)DefaultFixedRecordItemValidator.this).FixedRecordValidator.this.problemRequestor.acceptProblem(initializerExpr, 7780);
                    result[0] = false;
                }
            });
            return result[0];
        }

        private boolean checkInitializer(FixedStructureValidator.StructureItemInfo sItemInfo, List occursDimensions, Expression initialzerExpression) {
            return this.checkInitializer(sItemInfo, occursDimensions, initialzerExpression, sItemInfo.canonicalName);
        }

        private boolean checkInitializer(final FixedStructureValidator.StructureItemInfo sItemInfo, final List occursDimensions, Expression initialzerExpression, final String canonicalItemName) {
            final boolean[] result = new boolean[]{true};
            if (occursDimensions.isEmpty()) {
                initialzerExpression.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public void endVisit(ArrayLiteral arrayLiteral) {
                        ((DefaultFixedRecordItemValidator)DefaultFixedRecordItemValidator.this).FixedRecordValidator.this.problemRequestor.acceptProblem((Node)arrayLiteral, 7756, new String[]{canonicalItemName});
                        result[0] = false;
                    }

                    @Override
                    public void endVisitExpression(Expression expression) {
                        ITypeBinding expressionTBinding = expression.resolveTypeBinding();
                        if (expressionTBinding != null && !TypeCompatibilityUtil.isMoveCompatible(sItemInfo.binding.getType(), expressionTBinding, expression, ((DefaultFixedRecordItemValidator)DefaultFixedRecordItemValidator.this).FixedRecordValidator.this.compilerOptions)) {
                            ((DefaultFixedRecordItemValidator)DefaultFixedRecordItemValidator.this).FixedRecordValidator.this.problemRequestor.acceptProblem((Node)expression, 6653, new String[]{DefaultFixedRecordItemValidator.this.getShortName(sItemInfo.binding.getType()), DefaultFixedRecordItemValidator.this.getShortName(expressionTBinding), String.valueOf(canonicalItemName) + "=" + expression.getCanonicalString()});
                            result[0] = false;
                        }
                    }
                });
            } else {
                final int currentOccurs = (Integer)occursDimensions.remove(0);
                initialzerExpression.accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public void endVisit(ArrayLiteral arrayLiteral) {
                        List expressions = arrayLiteral.getExpressions();
                        if (expressions.size() > currentOccurs) {
                            ((DefaultFixedRecordItemValidator)DefaultFixedRecordItemValidator.this).FixedRecordValidator.this.problemRequestor.acceptProblem((Node)arrayLiteral, 7757, new String[]{canonicalItemName, Integer.toString(expressions.size()), Integer.toString(currentOccurs)});
                            result[0] = false;
                        }
                        int itemIndex = 1;
                        for (Expression nextExpr : expressions) {
                            ArrayList dimensionsLeft = new ArrayList();
                            dimensionsLeft.addAll(occursDimensions);
                            result[0] = result[0] & DefaultFixedRecordItemValidator.this.checkInitializer(sItemInfo, dimensionsLeft, nextExpr, String.valueOf(canonicalItemName) + "[" + itemIndex++ + "]");
                        }
                    }

                    @Override
                    public void endVisitExpression(Expression expression) {
                        ((DefaultFixedRecordItemValidator)DefaultFixedRecordItemValidator.this).FixedRecordValidator.this.problemRequestor.acceptProblem((Node)expression, 7758, new String[]{canonicalItemName, Integer.toString(currentOccurs)});
                        result[0] = false;
                    }
                });
            }
            return result[0];
        }

        protected boolean isNullableIsAllowed() {
            return false;
        }

        private String getShortName(ITypeBinding tBinding) {
            if (3 == tBinding.getKind()) {
                return ((PrimitiveTypeBinding)tBinding).getPrimitive().getName();
            }
            return tBinding.getName();
        }
    }

    private class DefaultFixedRecordItemValidatorFactory
    extends FixedStructureValidator.StructureItemValidatorFactory {
        private DefaultFixedRecordItemValidatorFactory() {
            super(FixedRecordValidator.this);
        }

        @Override
        FixedStructureValidator.StructureItemValidator createStructureItemValidator() {
            return new DefaultFixedRecordItemValidator();
        }
    }

    private class DefaultRecordNameValidator
    extends RecordNameValidator {
        private DefaultRecordNameValidator() {
        }

        @Override
        void validate(Name recordName) {
        }

        /* synthetic */ DefaultRecordNameValidator(DefaultRecordNameValidator defaultRecordNameValidator, DefaultRecordNameValidator defaultRecordNameValidator2) {
            this();
        }
    }

    private abstract class RecordNameValidator {
        private RecordNameValidator() {
        }

        abstract void validate(Name var1);
    }

    private class SQLRecordItemValidator
    extends DefaultFixedRecordItemValidator {
        @Override
        public void validate(FixedStructureValidator.StructureItemInfo sItemInfo) {
            IAnnotationBinding aBinding;
            super.validate(sItemInfo);
            if (sItemInfo.binding.hasOccurs()) {
                FixedRecordValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 4139, new String[]{sItemInfo.canonicalName, FixedRecordValidator.this.canonicalStructureName});
            }
            if (sItemInfo.structureItemNode.isFiller()) {
                FixedRecordValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 4012, new String[]{FixedRecordValidator.this.canonicalStructureName});
            }
            if (!sItemInfo.binding.getChildren().isEmpty()) {
                FixedRecordValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 5068, new String[]{FixedRecordValidator.this.canonicalStructureName, sItemInfo.canonicalName});
            }
            if (3 == sItemInfo.binding.getType().getKind()) {
                PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)sItemInfo.binding.getType();
                Primitive prim = primTypeBinding.getPrimitive();
                if (PRIMITIVES_NOT_ALLOWED_IN_SQL_RECORDS.contains(prim)) {
                    FixedRecordValidator.this.problemRequestor.acceptProblem((Node)sItemInfo.structureItemNode.getType(), 4123, new String[]{sItemInfo.canonicalName, FixedRecordValidator.this.canonicalStructureName, prim.getName()});
                }
                if (prim == Primitive.BIN && primTypeBinding.getDecimals() != 0) {
                    FixedRecordValidator.this.problemRequestor.acceptProblem((Node)sItemInfo.structureItemNode.getType(), 4138, new String[]{Primitive.BIN.getName(), sItemInfo.canonicalName, FixedRecordValidator.this.canonicalStructureName});
                }
            }
            if ((aBinding = sItemInfo.binding.getAnnotation(new String[]{"egl", "io", "sql"}, "IsReadOnly")) != null && Boolean.NO == aBinding.getValue()) {
                boolean mustBeReadOnly;
                boolean bl = mustBeReadOnly = FixedRecordValidator.this.getRecordIsSQLJoinRecord() || this.hasExpressionForColumn(sItemInfo);
                if (mustBeReadOnly) {
                    FixedRecordValidator.this.problemRequestor.acceptProblem(sItemInfo.nodeForErrors, 4014, new String[]{sItemInfo.canonicalName});
                }
            }
        }

        @Override
        public void validateEmbeddedItem(StructureItem embeddedItem) {
            ITypeBinding binding = embeddedItem.getType().resolveTypeBinding();
            if (binding != null && binding != IBinding.NOT_FOUND_BINDING && 6 == binding.getKind() && binding.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord") == null) {
                FixedRecordValidator.this.problemRequestor.acceptProblem((Node)embeddedItem.getType(), 5058, new String[]{embeddedItem.getType().getCanonicalName()});
            }
        }

        private boolean hasExpressionForColumn(FixedStructureValidator.StructureItemInfo sItemInfo) {
            IAnnotationBinding aBinding = sItemInfo.binding.getAnnotation(new String[]{"egl", "io", "sql"}, "column");
            if (aBinding != null && aBinding.getValue() != null) {
                return new StringTokenizer((String)aBinding.getValue(), "+-/*\t\n\r\f").countTokens() > 1;
            }
            return false;
        }

        @Override
        protected boolean isNullableIsAllowed() {
            return true;
        }
    }

    private class SQLRecordNameValidator
    extends DefaultRecordNameValidator {
        private SQLRecordNameValidator() {
        }

        @Override
        void validate(Name recordName) {
            super.validate(recordName);
            if (FixedRecordValidator.this.getField(FixedRecordValidator.this.structureBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord"), "tableNames") == null && EGLSQLKeywordHandler.getSQLKeywordNamesToLowerCaseAsSet().contains(recordName.getCanonicalName().toLowerCase())) {
                FixedRecordValidator.this.problemRequestor.acceptProblem((Node)FixedRecordValidator.this.recordNode.getName(), 6598, new String[]{recordName.getCanonicalName(), EGLSQLKeywordHandler.getSQLClauseKeywordNamesCommaSeparatedString()});
            }
        }
    }

    private class SQLStructureItemValidatorFactory
    extends FixedStructureValidator.StructureItemValidatorFactory {
        private SQLStructureItemValidatorFactory() {
            super(FixedRecordValidator.this);
        }

        @Override
        FixedStructureValidator.StructureItemValidator createStructureItemValidator() {
            return new SQLRecordItemValidator();
        }
    }

    protected class VGUIRecordItemValidator
    extends DefaultFixedRecordItemValidator {
        @Override
        public void validate(FixedStructureValidator.StructureItemInfo sItemInfo) {
            IAnnotationBinding uiTypeABinding;
            super.validate(sItemInfo);
            IAnnotationBinding aBinding = sItemInfo.binding.getAnnotation(new String[]{"egl", "ui"}, "ValidationOrder");
            if (aBinding != null && (uiTypeABinding = sItemInfo.binding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "UIType")) != null) {
                EnumerationDataBinding uiType = (EnumerationDataBinding)uiTypeABinding.getValue();
                if (InternUtil.intern((String)"INPUT") == uiType.getName() || InternUtil.intern((String)"INPUTOUTPUT") == uiType.getName()) {
                    FixedRecordValidator.this.validationOrderValues.add(aBinding.getValue());
                }
            }
            if (3 == sItemInfo.binding.getType().getKind()) {
                PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)sItemInfo.binding.getType();
                Primitive prim = primTypeBinding.getPrimitive();
                if (PRIMITIVES_NOT_ALLOWED_IN_VGUI_RECORDS.contains(prim)) {
                    FixedRecordValidator.this.problemRequestor.acceptProblem((Node)sItemInfo.structureItemNode.getType(), 7770, new String[]{prim.getName()});
                }
            }
        }

        @Override
        public void validatePart(FixedStructureBinding fixedStructureBinding) {
            Map simpleNamesToDBindings = fixedStructureBinding.getSimpleNamesToDataBindingsMap();
            for (String nextName : simpleNamesToDBindings.keySet()) {
                IDataBinding nextDBinding = (IDataBinding)simpleNamesToDBindings.get(nextName);
                if (nextDBinding == AmbiguousDataBinding.getInstance()) {
                    if (nextName.equals("*")) continue;
                    FixedRecordValidator.this.problemRequestor.acceptProblem((Node)FixedRecordValidator.this.recordNode.getName(), 7782, new String[]{nextName});
                    continue;
                }
                if (((StructureItemBinding)nextDBinding).numOccursDimensions() <= 1) continue;
                FixedRecordValidator.this.problemRequestor.acceptProblem((Node)FixedRecordValidator.this.recordNode.getName(), 7781, new String[]{((StructureItemBinding)nextDBinding).getParentQualifiedName()});
            }
        }
    }

    private class VGUIStructureItemValidatorFactory
    extends FixedStructureValidator.StructureItemValidatorFactory {
        private VGUIStructureItemValidatorFactory() {
            super(FixedRecordValidator.this);
        }

        @Override
        FixedStructureValidator.StructureItemValidator createStructureItemValidator() {
            return new VGUIRecordItemValidator();
        }
    }
}

