/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SystemEnumerationDataBinding;
import org.eclipse.edt.compiler.core.EGLSQLKeywordHandler;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.PCBKind;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FlexibleRecordValidator
extends AbstractASTVisitor {
    private static Map namesToRequiredPCBTypes = new HashMap();
    private SystemEnumerationDataBinding lastPCBKindDeclared;
    private boolean pcbsDeclaredOutOfOrder = false;
    Map consoleFieldNamesToNodes = new HashMap();
    protected IProblemRequestor problemRequestor;
    private FlexibleRecordBinding recordBinding;
    private Name recordNameNode;
    private String canonicalRecordName;
    private ICompilerOptions compilerOptions;

    static {
        namesToRequiredPCBTypes.put(InternUtil.intern((String)"ELAEXP"), PCBKind.TP);
        namesToRequiredPCBTypes.put(InternUtil.intern((String)"ELAALT"), PCBKind.TP);
        namesToRequiredPCBTypes.put(InternUtil.intern((String)"IOPCB"), PCBKind.TP);
        namesToRequiredPCBTypes.put(InternUtil.intern((String)"ELAMSG"), PCBKind.DB);
        namesToRequiredPCBTypes.put(InternUtil.intern((String)"ELAWORK"), PCBKind.DB);
    }

    public FlexibleRecordValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(Record record) {
        this.recordNameNode = record.getName();
        this.canonicalRecordName = record.getName().getCanonicalName();
        this.recordBinding = (FlexibleRecordBinding)record.getName().resolveBinding();
        this.getRecordNameValidator().validate(record.getName());
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(record);
        return true;
    }

    @Override
    public void endVisit(Record record) {
        for (String nextName : this.consoleFieldNamesToNodes.keySet()) {
            List nodesWithName = (List)this.consoleFieldNamesToNodes.get(nextName);
            if (nodesWithName.size() <= 1) continue;
            Iterator iter2 = nodesWithName.iterator();
            while (iter2.hasNext()) {
                this.problemRequestor.acceptProblem((Node)iter2.next(), 3039, new String[]{nextName});
            }
        }
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        ItemInfo itemInfo;
        if (!structureItem.isEmbedded() && (itemInfo = this.createItemInfo(structureItem)) != null) {
            itemInfo.getValidator().validate();
        }
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(structureItem);
        structureItem.accept(new FieldValidator(this.problemRequestor, this.compilerOptions));
        if (structureItem.hasType()) {
            StatementValidator.validateDataDeclarationType(structureItem.getType(), this.problemRequestor, this.recordBinding);
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    private RecordNameValidator getRecordNameValidator() {
        if (this.recordBinding != null && AbstractBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "io", "sql"}, "SQLRecord")) {
            return new SQLRecordNameValidator();
        }
        return new DefaultRecordNameValidator(null, null);
    }

    private ItemInfo createItemInfo(StructureItem sItem) {
        ItemInfo result = null;
        IBinding binding = sItem.resolveBinding();
        if (binding == null || binding == IBinding.NOT_FOUND_BINDING) {
            return null;
        }
        FlexibleRecordFieldBinding itemBinding = (FlexibleRecordFieldBinding)binding;
        result = AbstractBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "io", "dli"}, "PSBRecord") ? this.createPSBRecordItemInfo(itemBinding) : (AbstractBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "ui", "console"}, "ConsoleForm") ? new ConsoleFormItemInfo() : (AbstractBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "io", "sql"}, "SQLRecord") ? new SQLRecordItemInfo() : (AbstractBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "io", "file"}, "CSVRecord") ? new CSVRecordItemInfo() : new DefaultItemInfo())));
        if (sItem.isFiller()) {
            result.nodeForErrors = sItem;
            result.canonicalName = "*";
        } else {
            result.nodeForErrors = sItem.getName();
            result.canonicalName = sItem.getName().getCanonicalName();
        }
        result.structureItemNode = sItem;
        result.binding = itemBinding;
        return result;
    }

    private ItemInfo createPSBRecordItemInfo(IBinding itemBinding) {
        PSBRecordItemInfo result = null;
        IAnnotationBinding pcbBinding = itemBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "PCB");
        if (pcbBinding == null) {
            result = new NoPCBAnnotationPSBRecordItemInfo();
        } else {
            IAnnotationBinding aBinding = this.getField(pcbBinding, "pcbType");
            if (aBinding == null) {
                result = new DefaultPSBRecordItemInfo(pcbBinding);
            } else {
                EnumerationDataBinding value = (EnumerationDataBinding)aBinding.getValue();
                if (AbstractBinder.enumerationIs(value, new String[]{"egl", "io", "dli"}, "PCBKind", "TP")) {
                    result = new TP_PSBRecordItemInfo(pcbBinding);
                } else if (AbstractBinder.enumerationIs(value, new String[]{"egl", "io", "dli"}, "PCBKind", "DB")) {
                    result = itemBinding.getName() == InternUtil.intern((String)"ELAWORK") ? new ELAWORK_DB_PSBRecordItemInfo(pcbBinding) : (itemBinding.getName() == InternUtil.intern((String)"ELAMSG") ? new ELAMSG_DB_PSBRecordItemInfo(pcbBinding) : new DB_PSBRecordItemInfo(pcbBinding));
                } else if (AbstractBinder.enumerationIs(value, new String[]{"egl", "io", "dli"}, "PCBKind", "GSAM")) {
                    result = new GSAM_PSBRecordItemInfo(pcbBinding);
                }
            }
        }
        return result;
    }

    private static Node getAnnotationNode(StructureItem sItemNode, final String fieldName) {
        final Node[] result = new Node[1];
        sItemNode.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                return true;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                IDataBinding binding = assignment.getLeftHandSide().resolveDataBinding();
                if (binding != null && binding != IBinding.NOT_FOUND_BINDING && binding.isAnnotationBinding() && fieldName == binding.getName()) {
                    result[0] = assignment;
                }
                return false;
            }
        });
        return result[0];
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    private class CSVRecordItemInfo
    extends ItemInfo {
        private CSVRecordItemInfo() {
        }

        @Override
        public ItemValidator getValidator() {
            return new CSVRecordItemValidator(this);
        }
    }

    private class CSVRecordItemValidator
    extends DefaultItemValidator {
        public CSVRecordItemValidator(ItemInfo itemInfo) {
            super(itemInfo);
            this.itemInfo = itemInfo;
        }

        @Override
        public void validate() {
            IBinding itemBinding = this.itemInfo.structureItemNode.resolveBinding();
            if (itemBinding != null && IBinding.NOT_FOUND_BINDING != itemBinding && itemBinding.isDataBinding()) {
                ITypeBinding typeBinding = ((IDataBinding)itemBinding).getType();
                if (2 == typeBinding.getKind()) {
                    FlexibleRecordValidator.this.problemRequestor.acceptProblem(this.itemInfo.structureItemNode.getType(), 4141);
                } else if (3 == typeBinding.getKind()) {
                    PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)typeBinding;
                    Primitive prim = primTypeBinding.getPrimitive();
                    switch (prim.getType()) {
                        case 0: 
                        case 21: 
                        case 22: {
                            FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)this.itemInfo.structureItemNode.getType(), 4140, new String[]{prim.getName()});
                        }
                    }
                } else if (typeBinding.getKind() != 3) {
                    FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)this.itemInfo.structureItemNode.getType(), 4140, new String[]{typeBinding.getCaseSensitiveName()});
                }
            }
            super.validate();
        }
    }

    private class ConsoleFormItemInfo
    extends ItemInfo {
        private ConsoleFormItemInfo() {
        }

        @Override
        public ItemValidator getValidator() {
            return new ConsoleFormItemValidator(this);
        }
    }

    private class ConsoleFormItemValidator
    extends DefaultItemValidator {
        public ConsoleFormItemValidator(ItemInfo itemInfo) {
            super(itemInfo);
            this.itemInfo = itemInfo;
        }

        @Override
        public void validate() {
            super.validate();
            if (AbstractBinder.typeIs(this.itemInfo.binding.getType(), new String[]{"egl", "ui", "console"}, "ConsoleField") && this.itemInfo.structureItemNode.hasSettingsBlock()) {
                this.itemInfo.structureItemNode.getSettingsBlock().accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        return true;
                    }

                    @Override
                    public boolean visit(final Assignment assignment) {
                        assignment.getLeftHandSide().accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(SimpleName simpleName) {
                                if (InternUtil.intern((String)"name") == simpleName.getIdentifier()) {
                                    assignment.getRightHandSide().accept(new DefaultASTVisitor(){

                                        @Override
                                        public boolean visit(StringLiteral stringLiteral) {
                                            String name = InternUtil.intern((String)stringLiteral.getCanonicalString());
                                            ArrayList<StringLiteral> nodesWithName = (ArrayList<StringLiteral>)((ConsoleFormItemValidator)((this).this).ConsoleFormItemValidator.this).FlexibleRecordValidator.this.consoleFieldNamesToNodes.get(name);
                                            if (nodesWithName == null) {
                                                nodesWithName = new ArrayList<StringLiteral>();
                                                ((ConsoleFormItemValidator)((this).this).ConsoleFormItemValidator.this).FlexibleRecordValidator.this.consoleFieldNamesToNodes.put(name, nodesWithName);
                                            }
                                            nodesWithName.add(stringLiteral);
                                            return false;
                                        }
                                    });
                                }
                                return false;
                            }
                        });
                        return false;
                    }
                });
            }
        }
    }

    private class DB_PSBRecordItemInfo
    extends PSBRecordItemInfo {
        public DB_PSBRecordItemInfo(IAnnotationBinding pcbAnnotation) {
            this(pcbAnnotation, Collections.EMPTY_SET, -1);
        }

        public DB_PSBRecordItemInfo(IAnnotationBinding pcbAnnotation, Set disallowedAnnotations, int errorKindForInvalidAnnotation) {
            super(pcbAnnotation, PCBKind.DB, disallowedAnnotations, errorKindForInvalidAnnotation);
        }
    }

    private class DefaultItemInfo
    extends ItemInfo {
        private DefaultItemInfo() {
        }

        @Override
        public ItemValidator getValidator() {
            return new DefaultItemValidator(this);
        }
    }

    private class DefaultItemValidator
    extends ItemValidator {
        public DefaultItemValidator(ItemInfo itemInfo) {
            super(itemInfo);
        }

        @Override
        public void validate() {
            IBinding itemBinding;
            Type type;
            Expression expression;
            ITypeBinding expressionTBinding;
            if (this.itemInfo.structureItemNode.hasInitializer() && (expressionTBinding = (expression = this.itemInfo.structureItemNode.getInitializer()).resolveTypeBinding()) != null && expressionTBinding != IBinding.NOT_FOUND_BINDING && !TypeCompatibilityUtil.isMoveCompatible(this.itemInfo.binding.getType(), expressionTBinding, expression, FlexibleRecordValidator.this.compilerOptions) && !expressionTBinding.isDynamic() && !TypeCompatibilityUtil.areCompatibleExceptions(expressionTBinding, this.itemInfo.binding.getType(), FlexibleRecordValidator.this.compilerOptions)) {
                FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)expression, 6653, new String[]{StatementValidator.getShortTypeString(this.itemInfo.binding.getType()), StatementValidator.getShortTypeString(expressionTBinding), String.valueOf(this.itemInfo.canonicalName) + "=" + expression.getCanonicalString()});
            }
            if ((type = this.itemInfo.structureItemNode.getType()) != null) {
                StatementValidator.validateRequiredFieldsInCUIDeclaration(type, this.itemInfo.structureItemNode.getSettingsBlock(), this.itemInfo.canonicalName.equals("*"), FlexibleRecordValidator.this.problemRequestor);
            }
            if ((itemBinding = this.itemInfo.structureItemNode.resolveBinding()) != null && IBinding.NOT_FOUND_BINDING != itemBinding && itemBinding.isDataBinding()) {
                StatementValidator.validateDeclarationForStereotypeContext((IDataBinding)itemBinding, FlexibleRecordValidator.this.problemRequestor, this.itemInfo.nodeForErrors);
            }
        }
    }

    private class DefaultPSBRecordItemInfo
    extends PSBRecordItemInfo {
        public DefaultPSBRecordItemInfo(IAnnotationBinding pcbAnnotation) {
            super(pcbAnnotation, null, Collections.EMPTY_SET, -1);
        }
    }

    private class DefaultRecordNameValidator
    extends RecordNameValidator {
        private DefaultRecordNameValidator() {
        }

        @Override
        void validate(Name recordName) {
            EGLNameValidator.validate(recordName, 6, FlexibleRecordValidator.this.problemRequestor, FlexibleRecordValidator.this.compilerOptions);
        }

        /* synthetic */ DefaultRecordNameValidator(DefaultRecordNameValidator defaultRecordNameValidator, DefaultRecordNameValidator defaultRecordNameValidator2) {
            this();
        }
    }

    private class ELAMSG_DB_PSBRecordItemInfo
    extends DB_PSBRecordItemInfo {
        public ELAMSG_DB_PSBRecordItemInfo(IAnnotationBinding pcbAnnotation) {
            super(pcbAnnotation, new HashSet<String>(Arrays.asList(InternUtil.intern((String)"secondaryIndex"), InternUtil.intern((String)"secondaryIndexItem"), InternUtil.intern((String)"hierarchy"))), 7856);
        }
    }

    private class ELAWORK_DB_PSBRecordItemInfo
    extends DB_PSBRecordItemInfo {
        public ELAWORK_DB_PSBRecordItemInfo(IAnnotationBinding pcbAnnotation) {
            super(pcbAnnotation, new HashSet<String>(Arrays.asList(InternUtil.intern((String)"secondaryIndex"), InternUtil.intern((String)"secondaryIndexItem"), InternUtil.intern((String)"hierarchy"))), 7856);
        }
    }

    private class GSAM_PSBRecordItemInfo
    extends PSBRecordItemInfo {
        public GSAM_PSBRecordItemInfo(IAnnotationBinding pcbAnnotation) {
            super(pcbAnnotation, PCBKind.GSAM, new HashSet<String>(Arrays.asList(InternUtil.intern((String)"secondaryIndex"), InternUtil.intern((String)"secondaryIndexItem"), InternUtil.intern((String)"hierarchy"))), 7855);
        }
    }

    private abstract class ItemInfo {
        Node nodeForErrors;
        String canonicalName;
        StructureItem structureItemNode;
        FlexibleRecordFieldBinding binding;

        private ItemInfo() {
        }

        public abstract ItemValidator getValidator();
    }

    private abstract class ItemValidator {
        protected ItemInfo itemInfo;

        public ItemValidator(ItemInfo itemInfo) {
            this.itemInfo = itemInfo;
        }

        public abstract void validate();
    }

    private class NoPCBAnnotationPSBRecordItemInfo
    extends PSBRecordItemInfo {
        public NoPCBAnnotationPSBRecordItemInfo() {
            super(null, null, Collections.EMPTY_SET, -1);
        }

        @Override
        boolean hasPCBAnnotation() {
            return false;
        }
    }

    private abstract class PSBRecordItemInfo
    extends ItemInfo {
        private SystemEnumerationDataBinding pcbKind;
        private Set disallowedAnnotations;
        private int errorKindForInvalidAnnotation;
        private IAnnotationBinding pcbAnnotation;

        PSBRecordItemInfo(IAnnotationBinding pcbAnnotation, SystemEnumerationDataBinding pcbKind, Set disallowedAnnotations, int errorKindForInvalidAnnotation) {
            this.pcbKind = pcbKind;
            this.disallowedAnnotations = disallowedAnnotations;
            this.errorKindForInvalidAnnotation = errorKindForInvalidAnnotation;
            this.pcbAnnotation = pcbAnnotation;
        }

        @Override
        public ItemValidator getValidator() {
            return new PSBRecordItemValidator(this);
        }

        IAnnotationBinding getPCBAnnotation() {
            return this.pcbAnnotation;
        }

        boolean hasPCBAnnotation() {
            return true;
        }

        boolean allowsAnnotation(String fieldName) {
            return !this.disallowedAnnotations.contains(InternUtil.intern((String)fieldName));
        }

        void reportErrorForInvalidAnnotation(String fieldName) {
            FlexibleRecordValidator.this.problemRequestor.acceptProblem(FlexibleRecordValidator.getAnnotationNode(this.structureItemNode, fieldName), this.errorKindForInvalidAnnotation, new String[]{fieldName, this.pcbKind.getCaseSensitiveName()});
        }

        public SystemEnumerationDataBinding getPCBKind() {
            return this.pcbKind;
        }
    }

    private class PSBRecordItemValidator
    extends DefaultItemValidator {
        PSBRecordItemInfo itemInfo;

        public PSBRecordItemValidator(PSBRecordItemInfo itemInfo) {
            super(itemInfo);
            this.itemInfo = itemInfo;
        }

        @Override
        public void validate() {
            SystemEnumerationDataBinding pcbKind;
            Object requiredPCBType;
            super.validate();
            if (!this.itemInfo.hasPCBAnnotation() && this.itemInfo.binding.getAnnotation(new String[]{"egl", "core"}, "Redefines") == null) {
                FlexibleRecordValidator.this.problemRequestor.acceptProblem(this.itemInfo.nodeForErrors, 7874);
            }
            if (2 == this.itemInfo.binding.getType().getKind()) {
                FlexibleRecordValidator.this.problemRequestor.acceptProblem(this.itemInfo.nodeForErrors, 7876);
            }
            if (6 != this.itemInfo.binding.getType().getBaseType().getKind()) {
                FlexibleRecordValidator.this.problemRequestor.acceptProblem(this.itemInfo.nodeForErrors, 7926);
            }
            if (this.itemInfo.hasPCBAnnotation()) {
                IAnnotationBinding pcbAnnotation = this.itemInfo.getPCBAnnotation();
                this.checkAnnotation(pcbAnnotation, InternUtil.intern((String)"secondaryIndex"));
                this.checkAnnotation(pcbAnnotation, InternUtil.intern((String)"secondaryIndexItem"));
                this.checkAnnotation(pcbAnnotation, InternUtil.intern((String)"hierarchy"));
                this.itemInfo.structureItemNode.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(StructureItem structureItem) {
                        return true;
                    }

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        return true;
                    }

                    @Override
                    public boolean visit(SetValuesExpression setValuesExpression) {
                        ITypeBinding tBinding = setValuesExpression.resolveTypeBinding();
                        return AbstractBinder.annotationIs(tBinding, new String[]{"egl", "io", "dli"}, "PCB");
                    }

                    @Override
                    public boolean visit(Assignment assignment) {
                        ArrayLiteral annotationValueNode;
                        IAnnotationBinding hierarchyAnnotation;
                        IDataBinding dBinding = assignment.getLeftHandSide().resolveDataBinding();
                        if (dBinding != null && IBinding.NOT_FOUND_BINDING != dBinding && 13 == dBinding.getKind() && InternUtil.intern((String)"hierarchy") == dBinding.getName() && (hierarchyAnnotation = (IAnnotationBinding)dBinding).getValue() != null && (annotationValueNode = this.getArrayLiteral(assignment.getRightHandSide())) != null) {
                            PSBRecordItemValidator.this.validateHierarchy(hierarchyAnnotation, annotationValueNode);
                        }
                        return false;
                    }

                    private ArrayLiteral getArrayLiteral(Expression expr) {
                        final ArrayLiteral[] result = new ArrayLiteral[1];
                        expr.accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                                return true;
                            }

                            @Override
                            public boolean visit(ArrayLiteral arrayLiteral) {
                                result[0] = arrayLiteral;
                                return false;
                            }
                        });
                        return result[0];
                    }
                });
            }
            if ((requiredPCBType = namesToRequiredPCBTypes.get(this.itemInfo.binding.getName())) != null && this.itemInfo.getPCBKind() != null && requiredPCBType != this.itemInfo.getPCBKind()) {
                FlexibleRecordValidator.this.problemRequestor.acceptProblem(this.itemInfo.nodeForErrors, 7927, new String[]{this.itemInfo.canonicalName, ((IDataBinding)requiredPCBType).getCaseSensitiveName()});
            }
            if (!FlexibleRecordValidator.this.pcbsDeclaredOutOfOrder && (pcbKind = this.itemInfo.getPCBKind()) != null) {
                if (FlexibleRecordValidator.this.lastPCBKindDeclared != null && FlexibleRecordValidator.this.lastPCBKindDeclared != pcbKind) {
                    if (FlexibleRecordValidator.this.lastPCBKindDeclared == PCBKind.GSAM) {
                        FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)FlexibleRecordValidator.this.recordNameNode, 7854, new String[]{pcbKind.getCaseSensitiveName(), PCBKind.GSAM.getCaseSensitiveName()});
                        FlexibleRecordValidator.this.pcbsDeclaredOutOfOrder = true;
                    } else if (FlexibleRecordValidator.this.lastPCBKindDeclared == PCBKind.DB && pcbKind != PCBKind.GSAM) {
                        FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)FlexibleRecordValidator.this.recordNameNode, 7854, new String[]{pcbKind.getCaseSensitiveName(), PCBKind.DB.getCaseSensitiveName()});
                        FlexibleRecordValidator.this.pcbsDeclaredOutOfOrder = true;
                    }
                }
                FlexibleRecordValidator.this.lastPCBKindDeclared = pcbKind;
            }
        }

        private boolean checkAnnotation(IAnnotationBinding pcbAnnotation, String fieldName) {
            if (pcbAnnotation.findData(fieldName) != IBinding.NOT_FOUND_BINDING && !this.itemInfo.allowsAnnotation(fieldName)) {
                this.itemInfo.reportErrorForInvalidAnnotation(fieldName);
                return false;
            }
            return true;
        }

        private boolean containsSegment(List list, RelationshipNode relNode) {
            return this.getRelationshipNode(list, relNode.segmentRecord) != null;
        }

        private RelationshipNode getRelationshipNode(List nodes, ITypeBinding segmentRecord) {
            for (RelationshipNode next : nodes) {
                if (next.segmentRecord != segmentRecord) continue;
                return next;
            }
            return null;
        }

        private boolean isLoop(RelationshipNode node, List list) {
            RelationshipNode curNode = this.getRelationshipNode(list, node.parentRecord);
            while (curNode != null) {
                if (curNode == node) {
                    return true;
                }
                curNode = this.getRelationshipNode(list, curNode.parentRecord);
            }
            return false;
        }

        private void validateHierarchy(IAnnotationBinding hierarchyAnnotation, ArrayLiteral hierarchyValueExpression) {
            Object[] hierarchyAnnotationValue = (Object[])hierarchyAnnotation.getValue();
            IAnnotationBinding[] relationships = null;
            if (hierarchyAnnotationValue.length != 0 && hierarchyAnnotationValue instanceof IAnnotationBinding[]) {
                relationships = (IAnnotationBinding[])hierarchyAnnotationValue;
            }
            boolean relationshipsAreValid = true;
            ArrayList<RelationshipNode> unparentedNodes = new ArrayList<RelationshipNode>();
            ArrayList<RelationshipNode> parentedNodes = new ArrayList<RelationshipNode>();
            if (relationships != null) {
                Iterator exprIterator = hierarchyValueExpression.getExpressions().iterator();
                int i = 0;
                while (i < relationships.length) {
                    IAnnotationBinding currentRelationship = relationships[i];
                    SetValuesExpression currentRelationshipAnnotation = (SetValuesExpression)exprIterator.next();
                    IAnnotationBinding aBinding = FlexibleRecordValidator.this.getField(currentRelationship, "segmentRecord");
                    ITypeBinding segmentRecord = null;
                    if (aBinding != null && aBinding.getValue() != null && IBinding.NOT_FOUND_BINDING != aBinding.getValue()) {
                        segmentRecord = (ITypeBinding)aBinding.getValue();
                    }
                    if (segmentRecord == null) {
                        relationshipsAreValid = false;
                    }
                    aBinding = FlexibleRecordValidator.this.getField(currentRelationship, "parentRecord");
                    ITypeBinding parentRecord = null;
                    if (aBinding != null && aBinding.getValue() != null && IBinding.NOT_FOUND_BINDING != aBinding.getValue()) {
                        parentRecord = (ITypeBinding)aBinding.getValue();
                    }
                    if (i == 0) {
                        if (parentRecord != null) {
                            relationshipsAreValid = false;
                        } else {
                            parentedNodes.add(new RelationshipNode(segmentRecord, null, currentRelationshipAnnotation));
                        }
                    } else if (parentRecord == null) {
                        relationshipsAreValid = false;
                        if (currentRelationshipAnnotation.getSettingsBlock().getSetting(InternUtil.intern((String)"parentRecord")) == null) {
                            FlexibleRecordValidator.this.problemRequestor.acceptProblem(currentRelationshipAnnotation.getExpression(), 7859);
                        }
                    } else if (segmentRecord == parentRecord) {
                        relationshipsAreValid = false;
                        FlexibleRecordValidator.this.problemRequestor.acceptProblem(currentRelationshipAnnotation.getExpression(), 7860);
                    } else {
                        RelationshipNode relNode = new RelationshipNode(segmentRecord, parentRecord, currentRelationshipAnnotation);
                        if (this.containsSegment(parentedNodes, relNode) || this.containsSegment(unparentedNodes, relNode)) {
                            FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)currentRelationshipAnnotation.getSettingsBlock().getSetting(InternUtil.intern((String)"segmentRecord")), 7883, new String[]{segmentRecord.getCaseSensitiveName()});
                        }
                        unparentedNodes.add(relNode);
                    }
                    ++i;
                }
            } else {
                relationshipsAreValid = false;
            }
            if (relationshipsAreValid) {
                boolean removedSomethingFromUnparentedList = true;
                while (!unparentedNodes.isEmpty() && removedSomethingFromUnparentedList) {
                    ArrayList<RelationshipNode> nodesToRemove = new ArrayList<RelationshipNode>();
                    for (RelationshipNode nextUnparented : unparentedNodes) {
                        RelationshipNode parented = this.getRelationshipNode(parentedNodes, nextUnparented.parentRecord);
                        if (parented == null) continue;
                        nodesToRemove.add(nextUnparented);
                        if (parented.hasParent(nextUnparented)) {
                            FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)nextUnparented.ast.getSettingsBlock().getSetting(InternUtil.intern((String)"parentRecord")).getLeftHandSide(), 7861, new String[]{nextUnparented.segmentRecord.getCaseSensitiveName()});
                            continue;
                        }
                        nextUnparented.parent = parented;
                        parentedNodes.add(nextUnparented);
                    }
                    removedSomethingFromUnparentedList = !nodesToRemove.isEmpty();
                    unparentedNodes.removeAll(nodesToRemove);
                }
                if (!unparentedNodes.isEmpty()) {
                    ArrayList<RelationshipNode> nodesToRemove = new ArrayList<RelationshipNode>();
                    for (RelationshipNode next : unparentedNodes) {
                        if (this.getRelationshipNode(unparentedNodes, next.parentRecord) != null) continue;
                        nodesToRemove.add(next);
                        FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)next.ast.getSettingsBlock().getSetting(InternUtil.intern((String)"parentRecord")), 7863, new String[]{next.parentRecord.getCaseSensitiveName()});
                    }
                    unparentedNodes.removeAll(nodesToRemove);
                    for (RelationshipNode next : unparentedNodes) {
                        if (!this.isLoop(next, unparentedNodes)) continue;
                        FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)next.ast.getSettingsBlock().getSetting(InternUtil.intern((String)"segmentRecord")), 7861, new String[]{next.segmentRecord.getCaseSensitiveName()});
                    }
                }
                for (RelationshipNode next : parentedNodes) {
                    int depth = next.depth();
                    if (depth <= 15) continue;
                    FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)next.ast.getExpression(), 7862, new String[]{Integer.toString(depth)});
                }
            }
        }

        private class RelationshipNode {
            ITypeBinding segmentRecord;
            ITypeBinding parentRecord;
            RelationshipNode parent;
            SetValuesExpression ast;

            RelationshipNode(ITypeBinding segmentRecord, ITypeBinding parentRecord, SetValuesExpression ast) {
                this.segmentRecord = segmentRecord;
                this.parentRecord = parentRecord;
                this.ast = ast;
            }

            boolean hasParent(RelationshipNode parentRelationship) {
                if (this.parent == null) {
                    return false;
                }
                if (this.parentRecord == parentRelationship.segmentRecord) {
                    return true;
                }
                return this.parent.hasParent(parentRelationship);
            }

            int depth() {
                return this.parent == null ? 1 : this.parent.depth() + 1;
            }
        }
    }

    private abstract class RecordNameValidator {
        private RecordNameValidator() {
        }

        abstract void validate(Name var1);
    }

    private class SQLRecordItemInfo
    extends ItemInfo {
        private SQLRecordItemInfo() {
        }

        @Override
        public ItemValidator getValidator() {
            return new SQLRecordItemValidator(this);
        }
    }

    private class SQLRecordItemValidator
    extends DefaultItemValidator {
        public SQLRecordItemValidator(ItemInfo itemInfo) {
            super(itemInfo);
            this.itemInfo = itemInfo;
        }

        @Override
        public void validate() {
            super.validate();
        }
    }

    private class SQLRecordNameValidator
    extends DefaultRecordNameValidator {
        private SQLRecordNameValidator() {
        }

        @Override
        void validate(Name recordName) {
            super.validate(recordName);
            if (FlexibleRecordValidator.this.getField(FlexibleRecordValidator.this.recordBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "SQLRecord"), "tableNames") == null && EGLSQLKeywordHandler.getSQLKeywordNamesToLowerCaseAsSet().contains(recordName.getCanonicalName().toLowerCase())) {
                FlexibleRecordValidator.this.problemRequestor.acceptProblem((Node)FlexibleRecordValidator.this.recordNameNode, 6598, new String[]{recordName.getCanonicalName(), EGLSQLKeywordHandler.getSQLClauseKeywordNamesCommaSeparatedString()});
            }
        }
    }

    private class TP_PSBRecordItemInfo
    extends PSBRecordItemInfo {
        public TP_PSBRecordItemInfo(IAnnotationBinding pcbAnnotation) {
            super(pcbAnnotation, PCBKind.TP, new HashSet<String>(Arrays.asList(InternUtil.intern((String)"secondaryIndex"), InternUtil.intern((String)"secondaryIndexItem"), InternUtil.intern((String)"hierarchy"))), 7855);
        }
    }
}

