/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FormValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FormGroupValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    private FormGroupBinding formGroupBinding;
    private String formGroupCanonicalName;
    private Map exprNodesForSize = new HashMap();
    private Map nodesForAliases = new HashMap();
    private Map nodesForFormNames = new HashMap();
    private ICompilerOptions compilerOptions;

    public FormGroupValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(FormGroup formGroup) {
        this.formGroupCanonicalName = formGroup.getName().getCanonicalName();
        this.formGroupBinding = (FormGroupBinding)formGroup.getName().resolveBinding();
        EGLNameValidator.validate(formGroup.getName(), 20, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(formGroup);
        return true;
    }

    @Override
    public boolean visit(NestedForm nestedForm) {
        nestedForm.accept(new FormValidator(this.problemRequestor, this.formGroupBinding, this.compilerOptions));
        this.gatherInfoFromForm(nestedForm.getName().resolveBinding(), new NodeAndName(nestedForm, nestedForm.getName().getCanonicalName()));
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        for (Name nextName : useStatement.getNames()) {
            this.gatherInfoFromForm(nextName.resolveBinding(), new NodeAndName(nextName, nextName.getCanonicalName()));
            EGLNameValidator.validate(nextName, 33, this.problemRequestor, this.compilerOptions);
        }
        useStatement.accept(new FormValidator(this.problemRequestor, this.formGroupBinding, this.compilerOptions));
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        this.gatherFloatingAreaSizes(settingsBlock);
        return false;
    }

    @Override
    public void endVisit(FormGroup formGroup) {
        this.checkNoFloatingAreasWithSameSize();
        this.checkNoDuplicateAliases();
        this.checkNoAliasMatchesFormName();
    }

    private void gatherInfoFromForm(IBinding binding, NodeAndName formNodeAndName) {
        ITypeBinding formBinding;
        if (binding != IBinding.NOT_FOUND_BINDING && binding.isTypeBinding() && 8 == (formBinding = (ITypeBinding)binding).getKind()) {
            ArrayList<NodeAndName> nodesWithName;
            IAnnotationBinding aliasABinding = formBinding.getAnnotation(new String[]{"egl", "core"}, "Alias");
            if (aliasABinding != null) {
                String alias = InternUtil.intern((String)((String)aliasABinding.getValue()));
                ArrayList<NodeAndName> nodesWithAlias = (ArrayList<NodeAndName>)this.nodesForAliases.get(alias);
                if (nodesWithAlias == null) {
                    nodesWithAlias = new ArrayList<NodeAndName>();
                    this.nodesForAliases.put(alias, nodesWithAlias);
                }
                nodesWithAlias.add(formNodeAndName);
            }
            if ((nodesWithName = (ArrayList<NodeAndName>)this.nodesForFormNames.get(formBinding.getName())) == null) {
                nodesWithName = new ArrayList<NodeAndName>();
                this.nodesForFormNames.put(formBinding.getName(), nodesWithName);
            }
            nodesWithName.add(formNodeAndName);
        }
    }

    private void gatherFloatingAreaSizes(SettingsBlock settingsBlock) {
        settingsBlock.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                assignment.getRightHandSide().accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ArrayLiteral arrayLiteral) {
                        return true;
                    }

                    @Override
                    public boolean visit(SetValuesExpression setValuesExpression) {
                        Expression expr = setValuesExpression.getExpression();
                        ITypeBinding tBinding = expr.resolveTypeBinding();
                        Size newSize = null;
                        IAnnotationBinding floatingAreaABinding = null;
                        if (AbstractBinder.annotationIs(tBinding, new String[]{"egl", "ui", "text"}, "ScreenFloatingArea")) {
                            floatingAreaABinding = (IAnnotationBinding)expr.resolveDataBinding();
                            IAnnotationBinding screenSizeABinding = FormGroupValidator.this.getField(floatingAreaABinding, "screenSize");
                            Object[] screenSizeValue = (Object[])screenSizeABinding.getValue();
                            if (screenSizeValue.length == 2) {
                                newSize = new ScreenSize((Integer)screenSizeValue[1], (Integer)screenSizeValue[0]);
                            }
                        } else if (AbstractBinder.annotationIs(tBinding, new String[]{"egl", "ui", "text"}, "PrintFloatingArea")) {
                            floatingAreaABinding = (IAnnotationBinding)expr.resolveDataBinding();
                            IAnnotationBinding pageSizeABinding = FormGroupValidator.this.getField(floatingAreaABinding, "pageSize");
                            if (pageSizeABinding != null) {
                                Object[] pageSizeValue = (Object[])pageSizeABinding.getValue();
                                if (pageSizeValue.length == 2) {
                                    newSize = new PageSize((Integer)pageSizeValue[1], (Integer)pageSizeValue[0]);
                                }
                            } else {
                                (this).FormGroupValidator.this.problemRequestor.acceptProblem((Node)expr, 5389, new String[]{"printFloatingArea", FormGroupValidator.this.formGroupCanonicalName});
                            }
                        }
                        if (newSize != null) {
                            ArrayList<Expression> exprList = (ArrayList<Expression>)FormGroupValidator.this.exprNodesForSize.get(newSize);
                            if (exprList == null) {
                                exprList = new ArrayList<Expression>();
                                FormGroupValidator.this.exprNodesForSize.put(newSize, exprList);
                            }
                            exprList.add(expr);
                            FormGroupValidator.this.checkFloatingAreaMargins(expr, floatingAreaABinding, newSize);
                        }
                        return false;
                    }
                });
                return false;
            }
        });
    }

    private void checkFloatingAreaMargins(Node floatingAreaNode, IAnnotationBinding floatingAreaABinding, Size floatingAreaSize) {
        int rightMargin;
        int leftMargin;
        int bottomMargin;
        int topMargin;
        IAnnotationBinding topMarginABinding = this.getField(floatingAreaABinding, "topMargin");
        IAnnotationBinding bottomMarginABinding = this.getField(floatingAreaABinding, "bottomMargin");
        IAnnotationBinding leftMarginABinding = this.getField(floatingAreaABinding, "leftMargin");
        IAnnotationBinding rightMarginABinding = this.getField(floatingAreaABinding, "rightMargin");
        try {
            topMargin = (Integer)topMarginABinding.getValue();
            bottomMargin = (Integer)bottomMarginABinding.getValue();
            leftMargin = (Integer)leftMarginABinding.getValue();
            rightMargin = (Integer)rightMarginABinding.getValue();
        }
        catch (ClassCastException classCastException) {
            topMargin = 0;
            bottomMargin = 0;
            leftMargin = 0;
            rightMargin = 0;
        }
        if (floatingAreaSize.height > 0 && topMargin + bottomMargin >= floatingAreaSize.height) {
            this.problemRequestor.acceptProblem(floatingAreaNode, 5398, new String[]{"topMargin", "bottomMargin"});
        }
        if (floatingAreaSize.width > 0 && leftMargin + rightMargin >= floatingAreaSize.width) {
            this.problemRequestor.acceptProblem(floatingAreaNode, 5399, new String[]{"leftMargin", "rightMargin"});
        }
    }

    private IAnnotationBinding getField(IAnnotationBinding aBinding, String fieldName) {
        IDataBinding fieldBinding = aBinding.findData(fieldName);
        return IBinding.NOT_FOUND_BINDING == fieldBinding ? null : (IAnnotationBinding)fieldBinding;
    }

    private void checkNoFloatingAreasWithSameSize() {
        for (Size nextSize : this.exprNodesForSize.keySet()) {
            List exprList = (List)this.exprNodesForSize.get(nextSize);
            if (exprList.size() == 1) continue;
            for (Expression nextExpr : exprList) {
                this.problemRequestor.acceptProblem((Node)nextExpr, 5329, new String[]{this.formGroupCanonicalName});
            }
        }
    }

    private void checkNoDuplicateAliases() {
        for (String nextAlias : this.nodesForAliases.keySet()) {
            List nodeAndNameList = (List)this.nodesForAliases.get(nextAlias);
            if (nodeAndNameList.size() == 1) continue;
            for (NodeAndName nextNodeAndName : nodeAndNameList) {
                this.problemRequestor.acceptProblem(this.getAliasAnnotationNode(nextNodeAndName.node), 5325, new String[]{"alias", "\"" + nextAlias + "\"", nextNodeAndName.name, this.formGroupCanonicalName});
            }
        }
    }

    private void checkNoAliasMatchesFormName() {
        for (String nextAlias : this.nodesForAliases.keySet()) {
            List nodeAndNameList = (List)this.nodesForAliases.get(nextAlias);
            if (!this.nodesForFormNames.containsKey(nextAlias)) continue;
            for (NodeAndName nextNodeAndName : nodeAndNameList) {
                this.problemRequestor.acceptProblem(this.getAliasAnnotationNode(nextNodeAndName.node), 5326, new String[]{"alias", "\"" + nextAlias + "\"", nextNodeAndName.name, this.formGroupCanonicalName});
            }
        }
    }

    private Node getAliasAnnotationNode(Node parentNode) {
        final Node[] result = new Node[]{parentNode};
        parentNode.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedForm nestedForm) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                Expression lhs = assignment.getLeftHandSide();
                if (AbstractBinder.annotationIs(lhs.resolveTypeBinding(), new String[]{"egl", "core"}, "Alias")) {
                    result[0] = lhs;
                }
                return false;
            }
        });
        return result[0];
    }

    private static class NodeAndName {
        Node node;
        String name;

        NodeAndName(Node node, String canonicalName) {
            this.node = node;
            this.name = canonicalName;
        }
    }

    private static class PageSize
    extends Size {
        PageSize(int width, int height) {
            super(width, height);
        }

        @Override
        boolean isPageSize() {
            return true;
        }
    }

    private static class ScreenSize
    extends Size {
        ScreenSize(int width, int height) {
            super(width, height);
        }

        @Override
        boolean isScreenSize() {
            return true;
        }
    }

    private static abstract class Size {
        int width;
        int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        boolean isPageSize() {
            return false;
        }

        boolean isScreenSize() {
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.width;
            result = 37 * result + this.height;
            result = 37 * result + (this.isPageSize() ? 1 : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Size) {
                Size otherSize = (Size)obj;
                return otherSize.width == this.width && otherSize.height == this.height && otherSize.isPageSize() == this.isPageSize();
            }
            return false;
        }
    }
}

