/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.StatementValidator;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.ContinueStatement;
import org.eclipse.edt.compiler.core.ast.ConverseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.DisplayStatement;
import org.eclipse.edt.compiler.core.ast.EmptyStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FreeSQLStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnEventBlock;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrintStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.SetStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesStatement;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.ThrowStatement;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.IStatementValidInContainerInfo;
import org.eclipse.edt.compiler.internal.core.validation.part.StatementValidInContainerInfoFactory;
import org.eclipse.edt.compiler.internal.core.validation.statement.AssignmentStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.CaseStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ContinueStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ConverseStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.DisplayStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ExitStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ForStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ForwardStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FreeSQLStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FunctionDataDeclarationValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.GotoStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IfStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.LabelStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.MoveStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.OpenUIStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.PrintStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ReturnStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.SetStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ShowStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.ThrowStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.TransferStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.TryStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.WhileStatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FunctionValidator
extends AbstractASTVisitor {
    IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;
    private String functionName;
    private HashMap labelMap = new HashMap();
    private ArrayList gotoList = new ArrayList();
    ICompilerOptions compilerOptions;
    private boolean nextStatementIsUnreachable;
    private IStatementValidInContainerInfo statementValidInContainerInfo;
    private LabelStatement labelPrecedingStatement;
    private Map labeledLoops = new HashMap();

    public FunctionValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
        if (enclosingPart != null) {
            this.statementValidInContainerInfo = StatementValidInContainerInfoFactory.INSTANCE.create(enclosingPart);
        }
        this.compilerOptions = compilerOptions;
    }

    public FunctionValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this(problemRequestor, null, compilerOptions);
    }

    @Override
    public boolean visit(TopLevelFunction topLevelFunction) {
        this.functionName = topLevelFunction.getName().getCanonicalName();
        if (topLevelFunction.getIdentifier() == InternUtil.intern((String)"main")) {
            this.problemRequestor.acceptProblem((Node)topLevelFunction.getName(), 4944, new String[]{"main"});
        }
        this.checkFunctionName(topLevelFunction.getName(), false);
        this.checkNumberOfParms(topLevelFunction.getFunctionParameters(), topLevelFunction.getName(), this.functionName);
        this.checkForConstructorCalls(topLevelFunction);
        return true;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        this.functionName = nestedFunction.getName().getCanonicalName();
        this.checkFunctionName(nestedFunction.getName(), true);
        this.checkNumberOfParms(nestedFunction.getFunctionParameters(), nestedFunction.getName(), this.functionName);
        this.checkForConstructorCalls(nestedFunction);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(nestedFunction);
        return true;
    }

    @Override
    public boolean visit(Constructor constructor) {
        this.functionName = "constructor";
        this.checkNumberOfParms(constructor.getParameters(), constructor, this.functionName);
        this.checkForConstructorCalls(constructor);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(constructor);
        return true;
    }

    private void checkForConstructorCalls(Node node) {
        node.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionInvocation functionInvocation) {
                if (Binding.isValidBinding(functionInvocation.getTarget().resolveDataBinding()) && functionInvocation.getTarget().resolveDataBinding().getKind() == 22) {
                    Constructor constructor;
                    if (functionInvocation.getParent() instanceof FunctionInvocationStatement && functionInvocation.getParent().getParent() instanceof Constructor && (constructor = (Constructor)functionInvocation.getParent().getParent()).getStmts().get(0) == functionInvocation.getParent()) {
                        return true;
                    }
                    FunctionValidator.this.problemRequestor.acceptProblem((Node)functionInvocation.getTarget(), 6756, new String[0]);
                }
                return true;
            }
        });
    }

    void checkNumberOfParms(List parms, Node name, String nameString) {
        if (parms.size() > 255) {
            this.problemRequestor.acceptProblem(name, 3028, new String[]{nameString, Integer.toString(parms.size())});
        }
    }

    @Override
    public boolean visit(FunctionParameter functionParameter) {
        this.checkConstParmNotField(functionParameter);
        Type parmType = functionParameter.getType();
        FunctionParameterBinding fParameterBinding = (FunctionParameterBinding)functionParameter.getName().resolveBinding();
        if (fParameterBinding != null) {
            this.checkParmTypeNotStaticArray(functionParameter, parmType);
            ITypeBinding typeBinding = parmType.resolveTypeBinding();
            if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING) {
                this.checkParmNotEmptyRecord(functionParameter, typeBinding);
                this.checkRecordParmNotFieldOrNullable(functionParameter, typeBinding);
                this.checkParmNotPSBRecord(functionParameter, typeBinding);
                this.checkTypeNotServiceOrInterfaceArray(functionParameter, typeBinding);
                if (fParameterBinding.isInput()) {
                    this.checkInputParm(functionParameter, typeBinding);
                } else if (fParameterBinding.isOutput()) {
                    this.checkOutputParm(functionParameter, typeBinding);
                } else if (functionParameter.getUseType() != null) {
                    this.checkExplicitInputOutputParm(functionParameter, typeBinding);
                } else {
                    this.checkImplicitInputOutputParm(functionParameter, typeBinding);
                }
                if (this.enclosingPart != null) {
                    this.checkPartSpecificConditions(functionParameter, fParameterBinding, this.enclosingPart);
                }
                if ((this.enclosingPart == null || 14 != this.enclosingPart.getKind() && 15 != this.enclosingPart.getKind()) && fParameterBinding.isSQLNullable()) {
                    this.checkNullableParm(functionParameter, typeBinding);
                }
                org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator.validateDeclarationForStereotypeContext(fParameterBinding, this.problemRequestor, functionParameter.getType().getBaseType());
            }
            if (fParameterBinding.isInput()) {
                this.checkInputParm(functionParameter);
            } else if (fParameterBinding.isOutput()) {
                this.checkOutputParm(functionParameter);
            }
            EGLNameValidator.validate(functionParameter.getName(), 1, this.problemRequestor, this.compilerOptions);
        }
        return true;
    }

    private void checkFunctionName(Name name, boolean nested) {
        if (nested) {
            EGLNameValidator.validate(name, 41, this.problemRequestor, this.compilerOptions);
        } else {
            EGLNameValidator.validate(name, 4, this.problemRequestor, this.compilerOptions);
        }
    }

    private void checkParmTypeNotStaticArray(FunctionParameter functionParameter, Type parmType) {
        if (parmType.isNullableType()) {
            this.checkParmTypeNotStaticArray(functionParameter, parmType.getBaseType());
        }
        if (parmType.isArrayType()) {
            if (((ArrayType)parmType).hasInitialSize()) {
                this.problemRequestor.acceptProblem((Node)parmType, 3067, new String[]{functionParameter.getName().getCanonicalName(), this.functionName});
            } else {
                this.checkParmTypeNotStaticArray(functionParameter, ((ArrayType)parmType).getElementType());
            }
        }
    }

    private void checkParmNotEmptyRecord(FunctionParameter functionParameter, ITypeBinding parmType) {
        boolean isEmptyRecord = false;
        if (6 == parmType.getKind()) {
            FixedRecordBinding rec = (FixedRecordBinding)parmType;
            isEmptyRecord = rec.getStructureItems().isEmpty() && rec.getDefaultSuperType() == null;
        } else if (7 == parmType.getKind()) {
            FlexibleRecordBinding rec = (FlexibleRecordBinding)parmType;
            boolean bl = isEmptyRecord = rec.getDeclaredFields().isEmpty() && rec.getDefaultSuperType() == null;
        }
        if (isEmptyRecord) {
            this.problemRequestor.acceptProblem((Node)functionParameter.getType(), 3118, new String[]{functionParameter.getName().getCanonicalName(), functionParameter.getType().getCanonicalName()});
        }
    }

    private void checkConstParmNotField(FunctionParameter functionParameter) {
        if (FunctionParameter.AttrType.FIELD == functionParameter.getAttrType() && functionParameter.isParmConst()) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 4960, new String[]{functionParameter.getName().getCanonicalName(), this.functionName});
        }
    }

    private void checkRecordParmNotFieldOrNullable(FunctionParameter functionParameter, ITypeBinding parmType) {
        if (!(FunctionParameter.AttrType.FIELD != functionParameter.getAttrType() && FunctionParameter.AttrType.SQLNULLABLE != functionParameter.getAttrType() || 6 != parmType.getKind() && 7 != parmType.getKind())) {
            this.problemRequestor.acceptProblem((Node)functionParameter, functionParameter.getAttrType() == FunctionParameter.AttrType.FIELD ? 4946 : 4942, new String[]{functionParameter.getName().getCanonicalName(), "record", this.functionName});
        }
    }

    private void checkParmNotPSBRecord(FunctionParameter functionParameter, ITypeBinding parmType) {
        if (parmType.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
            this.problemRequestor.acceptProblem(functionParameter.getType(), 7931);
        }
    }

    private void checkTypeNotServiceOrInterfaceArray(FunctionParameter functionParameter, ITypeBinding parmType) {
        ITypeBinding elementType;
        if (2 == parmType.getKind() && (14 == (elementType = ((ArrayTypeBinding)parmType).getBaseType()).getKind() || 15 == elementType.getKind() && SystemPartManager.findType(elementType.getName()) != elementType)) {
            this.problemRequestor.acceptProblem(functionParameter.getType(), 7820);
        }
    }

    private void checkNullableParm(FunctionParameter functionParameter, ITypeBinding parmType) {
        if (3 == parmType.getKind()) {
            PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)parmType;
            Primitive prim = primTypeBinding.getPrimitive();
            if (Primitive.BIGINT == prim || Primitive.MBCHAR == prim || Primitive.NUM == prim || Primitive.NUMC == prim || Primitive.PACF == prim) {
                this.problemRequestor.acceptProblem((Node)functionParameter, 4942, new String[]{functionParameter.getName().getCanonicalName(), prim.getName(), this.functionName});
            } else if (Primitive.BIN == prim && (primTypeBinding.getLength() == 18 || primTypeBinding.getDecimals() != 0)) {
                this.problemRequestor.acceptProblem((Node)functionParameter, 4943, new String[]{functionParameter.getName().getCanonicalName(), prim.getName(), this.functionName});
            }
        }
    }

    private void checkInputOrOutputOrInputOutputParm(FunctionParameter functionParameter, ITypeBinding parmType) {
    }

    private void checkInputOrOutputParm(FunctionParameter functionParameter, ITypeBinding parmType) {
        this.checkInputOrOutputOrInputOutputParm(functionParameter, parmType);
    }

    private void checkInputParm(FunctionParameter functionParameter, ITypeBinding parmType) {
        this.checkInputOrOutputParm(functionParameter, parmType);
        if (BindingUtilities.isLooseType(parmType)) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 4949, new String[]{"in".toUpperCase()});
        }
        if (functionParameter.isParmConst()) {
            this.validatePrimitiveConst(functionParameter.getType());
        }
    }

    private void checkOutputParm(FunctionParameter functionParameter, ITypeBinding parmType) {
        this.checkInputOrOutputParm(functionParameter, parmType);
        if (3 == parmType.getKind()) {
            switch (((PrimitiveTypeBinding)parmType).getPrimitive().getType()) {
                case 26: {
                    if (((PrimitiveTypeBinding)parmType).getTimeStampOrIntervalPattern() != null) break;
                    this.problemRequestor.acceptProblem((Node)functionParameter, 4956, new String[]{"out".toUpperCase(), "interval".toUpperCase()});
                }
            }
        }
        if (functionParameter.isParmConst()) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 4958, new String[]{"out".toUpperCase(), "interval".toUpperCase()});
        }
    }

    private void checkExplicitInputOutputParm(FunctionParameter functionParameter, ITypeBinding parmType) {
        this.checkInputOrOutputOrInputOutputParm(functionParameter, parmType);
        if (functionParameter.isParmConst()) {
            this.validatePrimitiveConst(functionParameter.getType());
        }
    }

    private void checkImplicitInputOutputParm(FunctionParameter functionParameter, ITypeBinding parmType) {
        if (functionParameter.isParmConst()) {
            this.validatePrimitiveConst(functionParameter.getType());
        }
    }

    private void checkInputOrOutputParm(FunctionParameter functionParameter) {
        if (functionParameter.getAttrType() == FunctionParameter.AttrType.FIELD) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 4948, new String[]{functionParameter.getUseType().toString().toUpperCase()});
        }
    }

    private void checkInputParm(FunctionParameter functionParameter) {
        this.checkInputOrOutputParm(functionParameter);
    }

    private void checkOutputParm(FunctionParameter functionParameter) {
        this.checkInputOrOutputParm(functionParameter);
    }

    private void checkPartSpecificConditions(FunctionParameter functionParameter, FunctionParameterBinding parmBinding, IPartBinding enclosingPart) {
        ITypeBinding parmType = parmBinding.getType();
        if (parmType != null && parmType != IBinding.NOT_FOUND_BINDING && enclosingPart.getAnnotation(new String[]{"egl", "ui", "jasper"}, "JasperReport") != null && 3 != parmType.getKind()) {
            this.problemRequestor.acceptProblem(functionParameter.getType(), 7711);
        }
    }

    private void preVisitStatement(Statement statement) {
        this.preVisitStatement(statement, true);
    }

    private void preVisitStatement(Statement statement, boolean issueWarningIfUnreachable) {
        if (issueWarningIfUnreachable && this.nextStatementIsUnreachable) {
            this.problemRequestor.acceptProblem((Node)statement, 7755, 1);
            this.nextStatementIsUnreachable = false;
        }
        this.labelPrecedingStatement = null;
    }

    private void postVisitStatement(Statement statement) {
        if (statement.canIncludeOtherStatements()) {
            Iterator iter = statement.getStatementBlocks().iterator();
            while (iter.hasNext()) {
                Iterator stmtIter = ((List)iter.next()).iterator();
                while (stmtIter.hasNext()) {
                    ((Node)stmtIter.next()).accept(this);
                }
                this.nextStatementIsUnreachable = false;
            }
        }
    }

    private boolean checkStatementAllowedInContainer(Statement statement) {
        if (this.statementValidInContainerInfo != null && !this.statementValidInContainerInfo.statementIsValidInContainer(statement)) {
            this.problemRequestor.acceptProblem((Node)statement, this.statementValidInContainerInfo.getProblemKind(), new String[]{org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator.getName(statement)});
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(AddStatement addStatement) {
        StatementValidator val;
        this.preVisitStatement(addStatement);
        if (this.checkStatementAllowedInContainer(addStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(addStatement)) != null) {
            val.validateStatement(addStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(addStatement);
        return false;
    }

    @Override
    public boolean visit(AssignmentStatement assignmentStatement) {
        this.preVisitStatement(assignmentStatement);
        if (this.checkStatementAllowedInContainer(assignmentStatement)) {
            assignmentStatement.accept(new AssignmentStatementValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        }
        this.postVisitStatement(assignmentStatement);
        return false;
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        StatementValidator val;
        this.preVisitStatement(callStatement);
        if (this.checkStatementAllowedInContainer(callStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(callStatement)) != null) {
            val.validateStatement(callStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(callStatement);
        return false;
    }

    @Override
    public boolean visit(CaseStatement caseStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(caseStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(caseStatement);
        if (this.checkStatementAllowedInContainer(caseStatement)) {
            caseStatement.accept(new CaseStatementValidator(this.problemRequestor, this.compilerOptions));
        }
        this.postVisitStatement(caseStatement);
        return false;
    }

    @Override
    public boolean visit(CloseStatement closeStatement) {
        StatementValidator val;
        this.preVisitStatement(closeStatement);
        if (this.checkStatementAllowedInContainer(closeStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(closeStatement)) != null) {
            val.validateStatement(closeStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(closeStatement);
        return false;
    }

    @Override
    public boolean visit(ContinueStatement continueStatement) {
        this.preVisitStatement(continueStatement);
        if (this.checkStatementAllowedInContainer(continueStatement)) {
            continueStatement.accept(new ContinueStatementValidator(this.problemRequestor, this.labeledLoops));
            this.nextStatementIsUnreachable = true;
        }
        this.postVisitStatement(continueStatement);
        return false;
    }

    @Override
    public boolean visit(ConverseStatement converseStatement) {
        this.preVisitStatement(converseStatement);
        if (this.checkStatementAllowedInContainer(converseStatement)) {
            converseStatement.accept(new ConverseStatementValidator(this.problemRequestor, this.enclosingPart));
        }
        this.postVisitStatement(converseStatement);
        return false;
    }

    @Override
    public boolean visit(DeleteStatement deleteStatement) {
        StatementValidator val;
        this.preVisitStatement(deleteStatement);
        if (this.checkStatementAllowedInContainer(deleteStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(deleteStatement)) != null) {
            val.validateStatement(deleteStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(deleteStatement);
        return false;
    }

    @Override
    public boolean visit(DisplayStatement displayStatement) {
        this.preVisitStatement(displayStatement);
        if (this.checkStatementAllowedInContainer(displayStatement)) {
            displayStatement.accept(new DisplayStatementValidator(this.problemRequestor, this.enclosingPart, this.compilerOptions));
        }
        this.postVisitStatement(displayStatement);
        return false;
    }

    @Override
    public boolean visit(ExecuteStatement executeStatement) {
        StatementValidator val;
        this.preVisitStatement(executeStatement);
        if (this.checkStatementAllowedInContainer(executeStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(executeStatement)) != null) {
            val.validateStatement(executeStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(executeStatement);
        return false;
    }

    @Override
    public boolean visit(EmptyStatement emptyStatement) {
        this.preVisitStatement(emptyStatement, false);
        this.checkStatementAllowedInContainer(emptyStatement);
        this.postVisitStatement(emptyStatement);
        return false;
    }

    @Override
    public boolean visit(ExitStatement exitStatement) {
        this.preVisitStatement(exitStatement);
        if (this.checkStatementAllowedInContainer(exitStatement)) {
            exitStatement.accept(new ExitStatementValidator(this.problemRequestor, this.labeledLoops, this.enclosingPart, this.compilerOptions));
            this.nextStatementIsUnreachable = true;
        }
        this.postVisitStatement(exitStatement);
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        StatementValidator val;
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(forEachStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(forEachStatement);
        if (this.checkStatementAllowedInContainer(forEachStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(forEachStatement)) != null) {
            val.validateStatement(forEachStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(forEachStatement);
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(forStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(forStatement);
        if (this.checkStatementAllowedInContainer(forStatement)) {
            forStatement.accept(new ForStatementValidator(this.problemRequestor, this.compilerOptions));
        }
        this.postVisitStatement(forStatement);
        return false;
    }

    @Override
    public boolean visit(ForwardStatement forwardStatement) {
        this.preVisitStatement(forwardStatement);
        if (this.checkStatementAllowedInContainer(forwardStatement)) {
            forwardStatement.accept(new ForwardStatementValidator(this.problemRequestor, this.compilerOptions));
        }
        this.postVisitStatement(forwardStatement);
        return false;
    }

    @Override
    public boolean visit(FreeSQLStatement freeSQLStatement) {
        this.preVisitStatement(freeSQLStatement);
        if (this.checkStatementAllowedInContainer(freeSQLStatement)) {
            freeSQLStatement.accept(new FreeSQLStatementValidator(this.problemRequestor, this.compilerOptions));
        }
        this.postVisitStatement(freeSQLStatement);
        return false;
    }

    @Override
    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        this.preVisitStatement(functionInvocationStatement);
        this.checkStatementAllowedInContainer(functionInvocationStatement);
        this.postVisitStatement(functionInvocationStatement);
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        this.preVisitStatement(functionDataDeclaration);
        if (this.checkStatementAllowedInContainer(functionDataDeclaration)) {
            functionDataDeclaration.accept(new FunctionDataDeclarationValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        }
        this.postVisitStatement(functionDataDeclaration);
        return false;
    }

    @Override
    public boolean visit(GetByKeyStatement getByKeyStatement) {
        StatementValidator val;
        this.preVisitStatement(getByKeyStatement);
        if (this.checkStatementAllowedInContainer(getByKeyStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(getByKeyStatement)) != null) {
            val.validateStatement(getByKeyStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(getByKeyStatement);
        return false;
    }

    @Override
    public boolean visit(GetByPositionStatement getByPositionStatement) {
        StatementValidator val;
        this.preVisitStatement(getByPositionStatement);
        if (this.checkStatementAllowedInContainer(getByPositionStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(getByPositionStatement)) != null) {
            val.validateStatement(getByPositionStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(getByPositionStatement);
        return false;
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        this.preVisitStatement(gotoStatement);
        if (this.checkStatementAllowedInContainer(gotoStatement)) {
            gotoStatement.accept(new GotoStatementValidator(this.problemRequestor, this.compilerOptions));
            this.gotoList.add(gotoStatement);
        }
        this.postVisitStatement(gotoStatement);
        return false;
    }

    @Override
    public boolean visit(IfStatement ifStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(ifStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(ifStatement);
        if (this.checkStatementAllowedInContainer(ifStatement)) {
            ifStatement.accept(new IfStatementValidator(this.problemRequestor));
        }
        this.postVisitStatement(ifStatement);
        return false;
    }

    @Override
    public boolean visit(LabelStatement labelStatement) {
        this.nextStatementIsUnreachable = false;
        this.preVisitStatement(labelStatement);
        this.labelPrecedingStatement = labelStatement;
        if (this.checkStatementAllowedInContainer(labelStatement)) {
            labelStatement.accept(new LabelStatementValidator(this.problemRequestor, this.compilerOptions));
            if (this.labelMap.containsKey(labelStatement.getLabel())) {
                this.problemRequestor.acceptProblem((Node)labelStatement, 6625, new String[]{labelStatement.getLabel(), this.functionName});
            } else {
                this.labelMap.put(labelStatement.getLabel(), labelStatement);
            }
        }
        this.postVisitStatement(labelStatement);
        return false;
    }

    @Override
    public boolean visit(MoveStatement moveStatement) {
        this.preVisitStatement(moveStatement);
        if (this.checkStatementAllowedInContainer(moveStatement)) {
            moveStatement.accept(new MoveStatementValidator(this.problemRequestor, this.compilerOptions, this.enclosingPart));
        }
        this.postVisitStatement(moveStatement);
        return false;
    }

    @Override
    public boolean visit(OpenStatement openStatement) {
        StatementValidator val;
        this.preVisitStatement(openStatement);
        if (this.checkStatementAllowedInContainer(openStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(openStatement)) != null) {
            val.validateStatement(openStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(openStatement);
        return false;
    }

    @Override
    public boolean visit(OpenUIStatement openUIStatement) {
        this.preVisitStatement(openUIStatement);
        if (this.checkStatementAllowedInContainer(openUIStatement)) {
            openUIStatement.accept(new OpenUIStatementValidator(this.problemRequestor, this.compilerOptions));
        }
        this.postVisitStatement(openUIStatement);
        return false;
    }

    @Override
    public boolean visit(PrepareStatement prepareStatement) {
        StatementValidator val;
        this.preVisitStatement(prepareStatement);
        if (this.checkStatementAllowedInContainer(prepareStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(prepareStatement)) != null) {
            val.validateStatement(prepareStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(prepareStatement);
        return false;
    }

    @Override
    public boolean visit(PrintStatement printStatement) {
        this.preVisitStatement(printStatement);
        if (this.checkStatementAllowedInContainer(printStatement)) {
            printStatement.accept(new PrintStatementValidator(this.problemRequestor, this.enclosingPart));
        }
        this.postVisitStatement(printStatement);
        return false;
    }

    @Override
    public boolean visit(ReplaceStatement replaceStatement) {
        StatementValidator val;
        this.preVisitStatement(replaceStatement);
        if (this.checkStatementAllowedInContainer(replaceStatement) && this.enclosingPart != null && this.enclosingPart.getEnvironment() != null && this.enclosingPart.getEnvironment().getCompiler() != null && (val = this.enclosingPart.getEnvironment().getCompiler().getValidatorFor(replaceStatement)) != null) {
            val.validateStatement(replaceStatement, this.problemRequestor, this.compilerOptions);
        }
        this.postVisitStatement(replaceStatement);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement) {
        this.preVisitStatement(returnStatement);
        if (this.checkStatementAllowedInContainer(returnStatement)) {
            returnStatement.accept(new ReturnStatementValidator(this.problemRequestor, this.compilerOptions));
        }
        this.postVisitStatement(returnStatement);
        return false;
    }

    @Override
    public boolean visit(SetStatement setStatement) {
        this.preVisitStatement(setStatement);
        if (this.checkStatementAllowedInContainer(setStatement)) {
            setStatement.accept(new SetStatementValidator(this.problemRequestor, this.enclosingPart, this.compilerOptions));
        }
        this.postVisitStatement(setStatement);
        return false;
    }

    @Override
    public boolean visit(SetValuesStatement setValuesStatement) {
        this.preVisitStatement(setValuesStatement);
        this.checkStatementAllowedInContainer(setValuesStatement);
        this.postVisitStatement(setValuesStatement);
        return false;
    }

    @Override
    public boolean visit(ShowStatement showStatement) {
        this.preVisitStatement(showStatement);
        if (this.checkStatementAllowedInContainer(showStatement)) {
            showStatement.accept(new ShowStatementValidator(this.problemRequestor, this.enclosingPart, this.compilerOptions));
        }
        this.postVisitStatement(showStatement);
        return false;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement) {
        this.preVisitStatement(throwStatement);
        if (this.checkStatementAllowedInContainer(throwStatement)) {
            throwStatement.accept(new ThrowStatementValidator(this.problemRequestor, this.enclosingPart));
        }
        this.postVisitStatement(throwStatement);
        return false;
    }

    @Override
    public boolean visit(TransferStatement transferStatement) {
        this.preVisitStatement(transferStatement);
        if (this.checkStatementAllowedInContainer(transferStatement)) {
            transferStatement.accept(new TransferStatementValidator(this.problemRequestor, this.enclosingPart, this.compilerOptions));
        }
        this.postVisitStatement(transferStatement);
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.preVisitStatement(tryStatement);
        if (this.checkStatementAllowedInContainer(tryStatement)) {
            tryStatement.accept(new TryStatementValidator(this.problemRequestor, this.enclosingPart));
        }
        this.postVisitStatement(tryStatement);
        return false;
    }

    @Override
    public boolean visit(WhileStatement whileStatement) {
        if (this.labelPrecedingStatement != null) {
            this.labeledLoops.put(whileStatement, this.labelPrecedingStatement);
        }
        this.preVisitStatement(whileStatement);
        if (this.checkStatementAllowedInContainer(whileStatement)) {
            whileStatement.accept(new WhileStatementValidator(this.problemRequestor));
        }
        this.postVisitStatement(whileStatement);
        return false;
    }

    @Override
    public void endVisit(TopLevelFunction topLevelFunction) {
        this.validateGotoLabels();
    }

    @Override
    public void endVisit(NestedFunction nestedFunction) {
        this.validateGotoLabels();
    }

    private void validateGotoLabels() {
        for (GotoStatement gotoStatement : this.gotoList) {
            if (!this.labelMap.containsKey(gotoStatement.getLabel())) {
                this.problemRequestor.acceptProblem((Node)gotoStatement, 6624, new String[]{gotoStatement.getLabel(), this.functionName});
                continue;
            }
            if (this.inParents(gotoStatement, ((Node)this.labelMap.get(gotoStatement.getLabel())).getParent())) continue;
            this.problemRequestor.acceptProblem((Node)gotoStatement, 6728, new String[]{gotoStatement.getLabel(), this.functionName});
        }
    }

    private boolean inParents(Node child, Node node) {
        while (child != null) {
            if (child == node) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private Node getEnclosingOnEventBlock(Node node) {
        Node parent = node.getParent();
        while (parent != null && !(parent instanceof OnEventBlock)) {
            parent = parent.getParent();
        }
        return parent instanceof OnEventBlock ? parent : null;
    }

    private void validatePrimitiveConst(Type type) {
        org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator.validatePrimitiveConstant(type, this.problemRequestor);
    }
}

