/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.ServiceInterfaceValidatorUtil;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class InterfaceValidator
extends AbstractASTVisitor {
    protected IProblemRequestor problemRequestor;
    private InterfaceBinding partBinding;
    private ICompilerOptions compilerOptions;
    protected Interface iFaceNode = null;

    public InterfaceValidator(IProblemRequestor problemRequestor, InterfaceBinding partBinding, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.partBinding = partBinding;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(Interface interfaceNode) {
        this.iFaceNode = interfaceNode;
        EGLNameValidator.validate(interfaceNode.getName(), 38, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(interfaceNode);
        this.checkExtendedTypes(interfaceNode);
        return true;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        nestedFunction.accept(new FunctionValidator(this.problemRequestor, this.partBinding, this.compilerOptions));
        if (nestedFunction.isPrivate()) {
            this.problemRequestor.acceptProblem(nestedFunction.getName(), 7810);
        }
        ServiceInterfaceValidatorUtil.validateParametersAndReturn(nestedFunction, false, this.problemRequestor);
        if (InternUtil.intern((String)nestedFunction.getName().getCanonicalName()) == InternUtil.intern((String)"main")) {
            this.problemRequestor.acceptProblem((Node)this.iFaceNode.getName(), 5600, new String[]{this.partBinding.getCaseSensitiveName()});
        }
        return false;
    }

    @Override
    public boolean visit(Constructor constructor) {
        constructor.accept(new FunctionValidator(this.problemRequestor, this.partBinding, this.compilerOptions));
        return false;
    }

    private void checkExtendedTypes(Interface iface) {
        for (Name nameAST : iface.getExtendedTypes()) {
            ITypeBinding extendedType = (ITypeBinding)nameAST.resolveBinding();
            if (extendedType == null || IBinding.NOT_FOUND_BINDING == extendedType) continue;
            boolean typeIsValid = false;
            if (15 == extendedType.getKind()) {
                typeIsValid = true;
            }
            if (typeIsValid) continue;
            this.problemRequestor.acceptProblem((Node)nameAST, 3427, new String[]{extendedType.getCaseSensitiveName()});
        }
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }
}

