/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.ServiceBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.ServiceInterfaceValidatorUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ServiceValidator
extends FunctionContainerValidator {
    protected ServiceBinding serviceBinding = null;
    protected Service service = null;

    public ServiceValidator(IProblemRequestor problemRequestor, ServiceBinding partBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, partBinding, compilerOptions);
        this.serviceBinding = partBinding;
    }

    @Override
    public boolean visit(Service aservice) {
        this.service = aservice;
        this.partNode = aservice;
        EGLNameValidator.validate(this.service.getName(), 1, this.problemRequestor, this.compilerOptions);
        this.checkInterfaceFunctionsOverriden();
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(aservice);
        return true;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        super.visit(classDataDeclaration);
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        super.visit(nestedFunction);
        ServiceInterfaceValidatorUtil.validateParametersAndReturn(nestedFunction, true, this.problemRequestor);
        if (InternUtil.intern((String)nestedFunction.getName().getCanonicalName()) == InternUtil.intern((String)"main")) {
            this.problemRequestor.acceptProblem((Node)this.service.getName(), 5600, new String[]{this.serviceBinding.getCaseSensitiveName()});
        }
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(nestedFunction);
        return false;
    }

    private void checkInterfaceFunctionsOverriden() {
        Iterator iter = this.getInterfaceFunctionList().iterator();
        while (iter.hasNext()) {
            IFunctionBinding interfaceFunc = (IFunctionBinding)((NestedFunctionBinding)iter.next()).getType();
            boolean foundMatchingServiceFunc = false;
            Iterator iter2 = this.serviceBinding.getDeclaredFunctions().iterator();
            while (!foundMatchingServiceFunc && iter2.hasNext()) {
                IFunctionBinding serviceFunc = (IFunctionBinding)((NestedFunctionBinding)iter2.next()).getType();
                if (!TypeCompatibilityUtil.functionSignituresAreIdentical(serviceFunc, interfaceFunc, this.compilerOptions)) continue;
                foundMatchingServiceFunc = true;
            }
            if (foundMatchingServiceFunc) continue;
            this.problemRequestor.acceptProblem((Node)this.service.getName(), 3400, new String[]{this.service.getName().getCanonicalName(), String.valueOf(interfaceFunc.getCaseSensitiveName()) + "(" + ServiceValidator.getTypeNamesList(interfaceFunc.getParameters()) + ")", interfaceFunc.getDeclarer().getCaseSensitiveName()});
        }
    }

    private List getInterfaceFunctionList() {
        ArrayList<NestedFunctionBinding> retVal = new ArrayList<NestedFunctionBinding>();
        List interfaceList = this.serviceBinding.getImplementedInterfaces();
        int i = 0;
        while (i < interfaceList.size()) {
            InterfaceBinding interfaceBinding = (InterfaceBinding)interfaceList.get(i);
            for (NestedFunctionBinding fBinding : interfaceBinding.getDeclaredAndInheritedFunctions()) {
                if (fBinding.isPrivate()) continue;
                retVal.add(fBinding);
            }
            ++i;
        }
        return retVal;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        super.visit(settingsBlock);
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        super.visit(useStatement);
        return false;
    }

    private static String getTypeNamesList(List types) {
        StringBuffer sb = new StringBuffer();
        if (!types.isEmpty()) {
            sb.append(" ");
        }
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            FunctionParameterBinding nextParm = (FunctionParameterBinding)iter.next();
            ITypeBinding nextType = nextParm.getType();
            if (!StatementValidator.isValidBinding(nextType)) continue;
            sb.append(nextType.getCaseSensitiveName());
            if (nextParm.isInput()) {
                sb.append(" in");
            } else if (nextParm.isOutput()) {
                sb.append(" out");
            } else {
                sb.append(" inOut");
            }
            if (iter.hasNext()) {
                sb.append(", ");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }
}

