/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WithInlineDLIClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.validation.statement.DLIStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.SQLStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class AddStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IProblemRequestor problemRequestor;
    boolean targetIsDLISegmentOrSegmentArray = false;

    public AddStatementValidator(IProblemRequestor problemRequestor) {
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(final AddStatement aaddStatement) {
        StatementValidator.validateIOTargetsContainer(aaddStatement.getIOObjects(), this.problemRequestor);
        aaddStatement.accept(new AbstractASTExpressionVisitor(){
            int count = 0;
            boolean isdli = false;

            @Override
            public boolean visit(UsingPCBClause clause) {
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                ITypeBinding typeBinding = expression.resolveTypeBinding();
                if (!StatementValidator.isValidBinding(typeBinding)) {
                    return false;
                }
                if (++this.count > 1) {
                    if (!this.isdli || typeBinding.getAnnotation(EGLIODLI, "DLISegment") == null) {
                        AddStatementValidator.this.problemRequestor.acceptProblem((Node)expression, 7869, new String[]{"add"});
                    }
                } else {
                    this.isdli = typeBinding.getAnnotation(EGLIODLI, "DLISegment") != null;
                }
                AddStatementValidator.this.validateTargetType(expression);
                if (!AddStatementValidator.this.targetIsDLISegmentOrSegmentArray) {
                    AddStatementValidator.this.targetIsDLISegmentOrSegmentArray = typeBinding.getBaseType().getAnnotation(EGLIODLI, "DLISegment") != null;
                }
                return false;
            }
        });
        aaddStatement.accept(new AbstractASTVisitor(){
            Node inlinesql = null;
            Node inlinedli = null;
            UsingPCBClause pcbClause = null;

            @Override
            public boolean visit(UsingPCBClause usingPCBClause) {
                this.pcbClause = usingPCBClause;
                if (!AddStatementValidator.this.targetIsDLISegmentOrSegmentArray) {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)usingPCBClause, 7870, new String[]{"usingPCB"});
                }
                return false;
            }

            @Override
            public boolean visit(WithInlineDLIClause withInlineDLIClause) {
                if (this.inlinedli != null) {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineDLIClause, 6546, new String[]{"add".toUpperCase()});
                } else {
                    this.inlinedli = withInlineDLIClause;
                }
                Expression expr = (Expression)aaddStatement.getTargets().get(0);
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (!StatementValidator.isValidBinding(typeBinding)) {
                    return false;
                }
                if (typeBinding.getKind() == 2) {
                    typeBinding = typeBinding.getBaseType();
                }
                if (typeBinding.getAnnotation(EGLIODLI, "DLISegment") == null) {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineDLIClause, 7870, new String[]{"with #dli"});
                }
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (this.inlinesql != null) {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6512, new String[]{"add".toUpperCase()});
                } else {
                    this.inlinesql = withInlineSQLClause;
                    if (StatementValidator.isClauseEmpty(withInlineSQLClause.getSqlStmt().getValue())) {
                        AddStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6500, new String[]{"add".toUpperCase()});
                    } else if (aaddStatement.getSqlInfo() != null) {
                        SQLStatementValidator.checkAddClauses(withInlineSQLClause, aaddStatement.getSqlInfo().getParser(), AddStatementValidator.this.problemRequestor);
                    }
                }
                Expression expr = (Expression)aaddStatement.getTargets().get(0);
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (!StatementValidator.isValidBinding(typeBinding)) {
                    return false;
                }
                return false;
            }

            @Override
            public void endVisit(AddStatement addStatement) {
                if (addStatement.getDliInfo() != null) {
                    DLIStatementValidator validator = new DLIStatementValidator(addStatement, AddStatementValidator.this.problemRequestor, 1);
                    validator.validateDLI(this.pcbClause);
                }
            }
        });
        return false;
    }

    protected void validateTargetType(Expression expression) {
        boolean isValid = false;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        IDataBinding dataBinding = expression.resolveDataBinding();
        if (StatementValidator.isValidBinding(typeBinding) && StatementValidator.isValidBinding(dataBinding)) {
            if (typeBinding.getKind() == 2) {
                ITypeBinding arrayBinding = typeBinding.getBaseType();
                if (!StatementValidator.isValidBinding(arrayBinding)) {
                    return;
                }
                if (arrayBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null || arrayBinding.getAnnotation(EGLIOFILE, "CSVRecord") != null || arrayBinding.getAnnotation(EGLIODLI, "DLISegment") != null) {
                    isValid = true;
                }
            } else if (!(typeBinding.getKind() != 6 && typeBinding.getKind() != 7 || typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") == null && typeBinding.getAnnotation(EGLIOMQ, "MQRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "SerialRecord") == null && typeBinding.getAnnotation(EGLIODLI, "DLISegment") == null && typeBinding.getAnnotation(EGLIOFILE, "CSVRecord") == null && typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") == null)) {
                isValid = true;
            }
        }
    }
}

