/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.ProgramParameterValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class CallStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public CallStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        ITypeBinding targetType = callStatement.getInvocationTarget().resolveTypeBinding();
        if (Binding.isValidBinding(targetType) && (targetType.getKind() == 20 || targetType.getKind() == 27)) {
            return false;
        }
        if (callStatement.hasArguments()) {
            Iterator iter = callStatement.getArguments().iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).accept(new AbstractASTExpressionVisitor(){

                    @Override
                    public boolean visitExpression(Expression expression) {
                        ITypeBinding type = expression.resolveTypeBinding();
                        if (StatementValidator.isValidBinding(type)) {
                            new ProgramParameterValidator(CallStatementValidator.this.problemRequestor).validate(type, expression);
                        }
                        return false;
                    }

                    @Override
                    public boolean visit(SetValuesExpression setValuesExpression) {
                        CallStatementValidator.this.problemRequestor.acceptProblem(setValuesExpression, 7515);
                        return false;
                    }
                });
            }
        }
        callStatement.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                ITypeBinding type = expression.resolveTypeBinding();
                if (StatementValidator.isValidBinding(type) && (type.getKind() == 6 || type.getKind() == 7) && type.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
                    CallStatementValidator.this.problemRequestor.acceptProblem((Node)expression, 7930, new String[]{expression.getCanonicalString()});
                }
                return true;
            }
        });
        this.checkProgramArguments(callStatement);
        return false;
    }

    private void checkForExpressionsArgs(CallStatement callStatement) {
        int argNumber = 0;
        Iterator iter = callStatement.getArguments().iterator();
        while (iter.hasNext()) {
            ++argNumber;
            final boolean[] valid = new boolean[]{true};
            Expression arg = (Expression)iter.next();
            arg.accept(new AbstractASTExpressionVisitor(){

                @Override
                public boolean visit(BinaryExpression binaryExpression) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(StringLiteral stringLiteral) {
                    if (stringLiteral.getValue().length() == 0) {
                        valid[0] = false;
                    }
                    return false;
                }

                @Override
                public boolean visit(ArrayLiteral arrayLiteral) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(DecimalLiteral decimalLiteral) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(FloatLiteral floatLiteral) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(IntegerLiteral integerLiteral) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(NullLiteral nilLiteral) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(SubstringAccess substringAccess) {
                    valid[0] = false;
                    return false;
                }

                @Override
                public boolean visit(UnaryExpression unaryExpression) {
                    valid[0] = false;
                    return false;
                }
            });
            if (valid[0]) continue;
            this.problemRequestor.acceptProblem((Node)arg, 6706, new String[]{Integer.toString(argNumber), callStatement.getInvocationTarget().getCanonicalString()});
        }
    }

    private void checkProgramArguments(CallStatement callStatement) {
        ITypeBinding[] calltypes;
        ProgramBinding program = this.getProgram(callStatement);
        if (program == null) {
            if (callStatement.hasArguments()) {
                this.checkForExpressionsArgs(callStatement);
            }
            return;
        }
        if (!program.isCallable()) {
            this.problemRequestor.acceptProblem((Node)callStatement.getInvocationTarget(), 6544, new String[]{program.getCaseSensitiveName()});
            return;
        }
        ITypeBinding[] programtypes = this.getProgramParamTypes(program);
        if (!StatementValidator.checkArguments(programtypes, calltypes = this.getCallStatementArgTypes(callStatement), this.compilerOptions)) {
            this.problemRequestor.acceptProblem((Node)callStatement.getInvocationTarget(), 6707, new String[]{program.getCaseSensitiveName(), StatementValidator.getParmListString(programtypes), StatementValidator.getParmListString(calltypes)});
        }
        if (callStatement.hasArguments()) {
            Iterator iter = callStatement.getArguments().iterator();
            while (iter.hasNext()) {
                ((Expression)iter.next()).accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                        return true;
                    }

                    @Override
                    public boolean visit(SubstringAccess substringAccess) {
                        CallStatementValidator.this.problemRequestor.acceptProblem(substringAccess, 3364);
                        return false;
                    }
                });
            }
        }
    }

    private ProgramBinding getProgram(CallStatement callStatement) {
        ProgramBinding program = null;
        Expression invocationTarget = callStatement.getInvocationTarget();
        ITypeBinding tBinding = invocationTarget.resolveTypeBinding();
        if (tBinding != null && tBinding != IBinding.NOT_FOUND_BINDING && tBinding.getKind() == 13) {
            program = (ProgramBinding)tBinding;
        }
        return program;
    }

    private ITypeBinding[] getCallStatementArgTypes(CallStatement callStatement) {
        if (callStatement.hasArguments()) {
            ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
            for (Expression expr : callStatement.getArguments()) {
                list.add(expr.resolveTypeBinding());
            }
            return list.toArray(new ITypeBinding[list.size()]);
        }
        return new ITypeBinding[0];
    }

    private ITypeBinding[] getProgramParamTypes(ProgramBinding program) {
        ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
        for (IDataBinding binding : program.getParameters()) {
            list.add(binding.getType());
        }
        return list.toArray(new ITypeBinding[list.size()]);
    }

    public static boolean isFunctionCallStatement(CallStatement stmt) {
        return Binding.isValidBinding(stmt.getInvocationTarget().resolveDataBinding()) && 20 == stmt.getInvocationTarget().resolveDataBinding().getKind();
    }

    public static boolean isLocalFunctionCallStatement(CallStatement stmt) {
        if (!CallStatementValidator.isFunctionCallStatement(stmt)) {
            return false;
        }
        NestedFunctionBinding nestedBinding = (NestedFunctionBinding)stmt.getInvocationTarget().resolveDataBinding();
        if (Binding.isValidBinding(nestedBinding.getDeclaringPart())) {
            if (15 == nestedBinding.getDeclaringPart().getKind()) {
                return false;
            }
            if (14 != nestedBinding.getDeclaringPart().getKind()) {
                return true;
            }
            if (CallStatementValidator.getContainingPart(stmt) != nestedBinding.getDeclaringPart()) {
                return false;
            }
            final boolean[] isLocal = new boolean[1];
            DefaultASTVisitor visitor = new DefaultASTVisitor(){

                @Override
                public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                    return true;
                }

                @Override
                public boolean visit(SimpleName simpleName) {
                    isLocal[0] = true;
                    return false;
                }

                @Override
                public boolean visit(FieldAccess fieldAccess) {
                    isLocal[0] = fieldAccess.getPrimary() instanceof ThisExpression;
                    return false;
                }
            };
            stmt.getInvocationTarget().accept(visitor);
            return isLocal[0];
        }
        return false;
    }

    public static boolean isRemoteFunctionCallStatement(CallStatement stmt) {
        return CallStatementValidator.isFunctionCallStatement(stmt) && !CallStatementValidator.isLocalFunctionCallStatement(stmt);
    }

    private static IPartBinding getContainingPart(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Part && Binding.isValidBinding(((Part)node).getName().resolveBinding())) {
            return (IPartBinding)((Part)node).getName().resolveBinding();
        }
        return CallStatementValidator.getContainingPart(node.getParent());
    }
}

